/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.m2e.core.internal.ExtensionReader;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.URLConnectionCaches;
import org.eclipse.m2e.core.internal.builder.BuildDebugHook;
import org.eclipse.m2e.core.internal.builder.BuildProblemInfo;
import org.eclipse.m2e.core.internal.builder.BuildResultCollector;
import org.eclipse.m2e.core.internal.builder.DeltaProvider;
import org.eclipse.m2e.core.internal.builder.IIncrementalBuildFramework;
import org.eclipse.m2e.core.internal.builder.InternalBuildParticipant;
import org.eclipse.m2e.core.internal.builder.InternalBuildParticipant2;
import org.eclipse.m2e.core.internal.builder.MavenBuilder;
import org.eclipse.m2e.core.internal.builder.plexusbuildapi.AbstractEclipseBuildContext;
import org.eclipse.m2e.core.internal.builder.plexusbuildapi.PlexusBuildAPI;
import org.eclipse.m2e.core.internal.embedder.MavenProjectMutableState;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.internal.markers.SourceLocationHelper;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenBuilderImpl {
    private static Logger log = LoggerFactory.getLogger(MavenBuilderImpl.class);
    public static final QualifiedName BUILD_CONTEXT_KEY = new QualifiedName("org.eclipse.m2e.core", "BuildContext");
    private static final String BUILD_PARTICIPANT_ID_ATTR_NAME = "buildParticipantId";
    private final DeltaProvider deltaProvider;
    private final List<IIncrementalBuildFramework> incrementalBuildFrameworks;

    public MavenBuilderImpl(DeltaProvider deltaProvider) {
        this.deltaProvider = deltaProvider;
        this.incrementalBuildFrameworks = this.loadIncrementalBuildFrameworks();
    }

    private List<IIncrementalBuildFramework> loadIncrementalBuildFrameworks() {
        ArrayList<IIncrementalBuildFramework> frameworks = new ArrayList<IIncrementalBuildFramework>();
        frameworks.add(new PlexusBuildAPI());
        frameworks.addAll(ExtensionReader.readIncrementalBuildFrameworks());
        return frameworks;
    }

    public MavenBuilderImpl() {
        this(project -> null);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public Set<IProject> build(MavenSession session, IMavenProjectFacade projectFacade, int kind, Map<String, String> args, Map<MojoExecutionKey, List<AbstractBuildParticipant>> participants, IProgressMonitor monitor) throws CoreException {
        block21: {
            block20: {
                URLConnectionCaches.assertDisabled();
                debugHooks = MavenBuilder.getDebugHooks();
                dependencies = new HashSet<IProject>();
                mavenProject = projectFacade.getMavenProject();
                project = projectFacade.getProject();
                delta = this.getDeltaProvider().getDelta(project);
                participantResults = new BuildResultCollector();
                incrementalContexts = this.setupProjectBuildContext(project, kind, delta, participantResults);
                this.debugBuildStart(debugHooks, projectFacade, kind, args, participants, delta, monitor);
                buildErrors = new LinkedHashMap<Throwable, MojoExecutionKey>();
                snapshot = MavenProjectMutableState.takeSnapshot(mavenProject);
                try {
                    try {
                        for (Map.Entry<MojoExecutionKey, List<AbstractBuildParticipant>> entry : participants.entrySet()) {
                            mojoExecutionKey = entry.getKey();
                            for (InternalBuildParticipant participant : entry.getValue()) {
                                block19: {
                                    debugRefreshFiles = debugHooks.isEmpty() == false ? new LinkedHashSet<File>(participantResults.getFiles()) : null;
                                    MavenBuilderImpl.log.debug("Executing build participant {} for plugin execution {}", (Object)participant.getClass().getName(), (Object)mojoExecutionKey.toString());
                                    participantResults.setParticipantId(String.valueOf(mojoExecutionKey.getKeyString()) + "-" + participant.getClass().getName());
                                    participant.setMavenProjectFacade(projectFacade);
                                    participant.setGetDeltaCallback(this.getDeltaProvider());
                                    participant.setSession(session);
                                    participant.setBuildContext((AbstractEclipseBuildContext)incrementalContexts.get(0));
                                    if (participant instanceof InternalBuildParticipant2) {
                                        ((InternalBuildParticipant2)participant).setArgs(args);
                                    }
                                    executionStartTime = System.currentTimeMillis();
                                    try {
                                        try {
                                            if (this.isApplicable(participant, kind, delta) && (sub = participant.build(kind, monitor)) != null) {
                                                dependencies.addAll(sub);
                                            }
                                        }
                                        catch (Exception e) {
                                            MavenBuilderImpl.log.debug("Exception in build participant {}", (Object)participant.getClass().getName(), (Object)e);
                                            buildErrors.put(e, mojoExecutionKey);
                                            MavenBuilderImpl.log.debug("Finished executing build participant {} for plugin execution {} in {} ms", new Object[]{participant.getClass().getName(), mojoExecutionKey.toString(), System.currentTimeMillis() - executionStartTime});
                                            participant.setMavenProjectFacade(null);
                                            participant.setGetDeltaCallback(null);
                                            participant.setSession(null);
                                            participant.setBuildContext(null);
                                            if (participant instanceof InternalBuildParticipant2) {
                                                ((InternalBuildParticipant2)participant).setArgs(Collections.emptyMap());
                                            }
                                            this.processMavenSessionErrors(session, mojoExecutionKey, buildErrors);
                                            break block19;
                                        }
                                    }
                                    catch (Throwable var25_26) {
                                        MavenBuilderImpl.log.debug("Finished executing build participant {} for plugin execution {} in {} ms", new Object[]{participant.getClass().getName(), mojoExecutionKey.toString(), System.currentTimeMillis() - executionStartTime});
                                        participant.setMavenProjectFacade(null);
                                        participant.setGetDeltaCallback(null);
                                        participant.setSession(null);
                                        participant.setBuildContext(null);
                                        if (participant instanceof InternalBuildParticipant2) {
                                            ((InternalBuildParticipant2)participant).setArgs(Collections.emptyMap());
                                        }
                                        this.processMavenSessionErrors(session, mojoExecutionKey, buildErrors);
                                        throw var25_26;
                                    }
                                    MavenBuilderImpl.log.debug("Finished executing build participant {} for plugin execution {} in {} ms", new Object[]{participant.getClass().getName(), mojoExecutionKey.toString(), System.currentTimeMillis() - executionStartTime});
                                    participant.setMavenProjectFacade(null);
                                    participant.setGetDeltaCallback(null);
                                    participant.setSession(null);
                                    participant.setBuildContext(null);
                                    if (participant instanceof InternalBuildParticipant2) {
                                        ((InternalBuildParticipant2)participant).setArgs(Collections.emptyMap());
                                    }
                                    this.processMavenSessionErrors(session, mojoExecutionKey, buildErrors);
                                }
                                this.debugBuildParticipant(debugHooks, projectFacade, mojoExecutionKey, (AbstractBuildParticipant)participant, this.diff(debugRefreshFiles, participantResults.getFiles()), monitor);
                            }
                        }
                        break block20;
                    }
                    catch (Exception e) {
                        MavenBuilderImpl.log.debug("Unexpected build exception", (Throwable)e);
                        buildErrors.put(e, null);
                        snapshot.restore(mavenProject);
                        ** for (context : incrementalContexts)
                    }
                }
                catch (Throwable var26_33) {
                    snapshot.restore(mavenProject);
                    ** for (context : incrementalContexts)
                }
lbl-1000:
                // 1 sources

                {
                    context.release();
                    continue;
lbl78:
                    // 1 sources

                    break block21;
                }
lbl-1000:
                // 1 sources

                {
                    context.release();
                    continue;
                }
lbl84:
                // 1 sources

                throw var26_33;
            }
            snapshot.restore(mavenProject);
            for (IIncrementalBuildFramework.BuildContext context : incrementalContexts) {
                context.release();
            }
        }
        this.refreshResources(project, participantResults.getFiles(), monitor);
        result = session.getResult();
        this.processBuildResults(project, mavenProject, result, participantResults, buildErrors);
        return dependencies;
    }

    private List<IIncrementalBuildFramework.BuildContext> setupProjectBuildContext(IProject project, int kind, IResourceDelta delta, IIncrementalBuildFramework.BuildResultCollector results) throws CoreException {
        ArrayList<IIncrementalBuildFramework.BuildContext> contexts = new ArrayList<IIncrementalBuildFramework.BuildContext>();
        for (IIncrementalBuildFramework framework : this.incrementalBuildFrameworks) {
            contexts.add(framework.setupProjectBuildContext(project, kind, delta, results));
        }
        return contexts;
    }

    private void debugBuildParticipant(Collection<BuildDebugHook> hooks, IMavenProjectFacade projectFacade, MojoExecutionKey mojoExecutionKey, AbstractBuildParticipant participant, Set<File> files, IProgressMonitor monitor) {
        for (BuildDebugHook hook : hooks) {
            hook.buildParticipant(projectFacade, mojoExecutionKey, participant, files, monitor);
        }
    }

    private Set<File> diff(Set<File> before, Set<File> after) {
        if (before == null) {
            return after;
        }
        LinkedHashSet<File> result = new LinkedHashSet<File>(after);
        result.removeAll(before);
        return result;
    }

    private void debugBuildStart(Collection<BuildDebugHook> hooks, IMavenProjectFacade projectFacade, int kind, Map<String, String> args, Map<MojoExecutionKey, List<AbstractBuildParticipant>> participants, IResourceDelta delta, IProgressMonitor monitor) {
        for (BuildDebugHook hook : hooks) {
            hook.buildStart(projectFacade, kind, args, participants, delta, monitor);
        }
    }

    protected boolean isApplicable(InternalBuildParticipant participant, int kind, IResourceDelta delta) {
        return 6 == kind || delta != null || participant.callOnEmptyDelta();
    }

    private void processMavenSessionErrors(MavenSession session, MojoExecutionKey mojoExecutionKey, Map<Throwable, MojoExecutionKey> buildErrors) {
        MavenExecutionResult result = session.getResult();
        if (result.hasExceptions()) {
            for (Throwable e : result.getExceptions()) {
                log.debug("Exception during execution {}", (Object)mojoExecutionKey, (Object)e);
                buildErrors.put(e, mojoExecutionKey);
            }
            result.getExceptions().clear();
        }
    }

    private void refreshResources(IProject project, Collection<File> resources, IProgressMonitor monitor) throws CoreException {
        for (File file : resources) {
            IPath path = MavenBuilderImpl.getProjectRelativePath(project, file);
            if (path == null) {
                log.debug("Could not get relative path for file: ", (Object)file.getAbsoluteFile());
                continue;
            }
            Object resource = path.isEmpty() ? project : (!file.exists() ? project.findMember(path) : (file.isDirectory() ? project.getFolder(path) : project.getFile(path)));
            if (resource == null) continue;
            resource.refreshLocal(2, monitor);
            if (!resource.exists()) continue;
            resource.touch(monitor);
        }
    }

    public static IPath getProjectRelativePath(IProject project, File file) {
        if (project == null || file == null) {
            return null;
        }
        IPath projectPath = project.getLocation();
        if (projectPath == null) {
            return null;
        }
        Path filePath = new Path(file.getAbsolutePath());
        if (!projectPath.isPrefixOf((IPath)filePath)) {
            return null;
        }
        return filePath.removeFirstSegments(projectPath.segmentCount());
    }

    /*
     * WARNING - void declaration
     */
    private void processBuildResults(IProject project, MavenProject mavenProject, MavenExecutionResult result, BuildResultCollector results, Map<Throwable, MojoExecutionKey> buildErrors) {
        String buildParticipantId;
        IMavenMarkerManager markerManager = MavenPluginActivator.getDefault().getMavenMarkerManager();
        for (Map.Entry<String, List<File>> entry : results.getRemoveMessages().entrySet()) {
            buildParticipantId = entry.getKey();
            for (File file : entry.getValue()) {
                this.deleteBuildParticipantMarkers(project, markerManager, file, buildParticipantId);
            }
        }
        for (Map.Entry<String, List<Object>> entry : results.getMessages().entrySet()) {
            buildParticipantId = entry.getKey();
            for (BuildResultCollector.Message message : entry.getValue()) {
                this.addBuildParticipantMarker(project, markerManager, message, buildParticipantId);
                if (message.cause == null || !buildErrors.containsKey(message.cause)) continue;
                buildErrors.remove(message.cause);
            }
        }
        for (Throwable throwable : buildErrors.keySet()) {
            void var10_20;
            MojoExecutionKey mojoExecutionKey = buildErrors.get(throwable);
            if (mojoExecutionKey != null) {
                SourceLocation sourceLocation = SourceLocationHelper.findLocation(mavenProject, mojoExecutionKey);
            } else {
                SourceLocation sourceLocation = new SourceLocation(1, 0, 0);
            }
            BuildProblemInfo problem = new BuildProblemInfo(throwable, mojoExecutionKey, (SourceLocation)var10_20);
            markerManager.addErrorMarker((IResource)project.getFile("pom.xml"), "org.eclipse.m2e.core.maven2Problem.build", problem);
        }
        if (result.hasExceptions()) {
            markerManager.addMarkers((IResource)project.getFile("pom.xml"), "org.eclipse.m2e.core.maven2Problem.build", result);
        }
    }

    private void deleteBuildParticipantMarkers(IProject project, IMavenMarkerManager markerManager, File file, String buildParticipantId) {
        IPath path = MavenBuilderImpl.getProjectRelativePath(project, file);
        IResource resource = null;
        if (path != null) {
            resource = project.findMember(path);
        }
        if (resource == null) {
            resource = project.getFile("pom.xml");
        }
        try {
            markerManager.deleteMarkers(resource, "org.eclipse.m2e.core.maven2Problem.build.participant", BUILD_PARTICIPANT_ID_ATTR_NAME, buildParticipantId);
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void addBuildParticipantMarker(IProject project, IMavenMarkerManager markerManager, BuildResultCollector.Message buildMessage, String buildParticipantId) {
        IPath path = MavenBuilderImpl.getProjectRelativePath(project, buildMessage.file);
        IResource resource = null;
        if (path != null) {
            resource = project.findMember(path);
        }
        if (resource == null) {
            resource = project.getFile("pom.xml");
        }
        int at = buildParticipantId.lastIndexOf(45);
        String pluginExecutionKey = buildParticipantId.substring(0, at);
        String message = String.valueOf(buildMessage.message) + " (" + pluginExecutionKey + ')';
        IMarker marker = markerManager.addMarker(resource, "org.eclipse.m2e.core.maven2Problem.build.participant", message, buildMessage.line, buildMessage.severity);
        try {
            marker.setAttribute(BUILD_PARTICIPANT_ID_ATTR_NAME, (Object)buildParticipantId);
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void clean(MavenSession session, IMavenProjectFacade projectFacade, Map<MojoExecutionKey, List<AbstractBuildParticipant>> participants, IProgressMonitor monitor) throws CoreException {
        block15: {
            block14: {
                mavenProject = projectFacade.getMavenProject();
                project = projectFacade.getProject();
                participantResults = new BuildResultCollector();
                incrementalContexts = this.setupProjectBuildContext(project, 15, null, participantResults);
                buildErrors = new LinkedHashMap<Throwable, MojoExecutionKey>();
                try {
                    try {
                        for (Map.Entry<MojoExecutionKey, List<AbstractBuildParticipant>> entry : participants.entrySet()) {
                            mojoExecutionKey = entry.getKey();
                            for (InternalBuildParticipant participant : entry.getValue()) {
                                participantResults.setParticipantId(String.valueOf(mojoExecutionKey.getKeyString()) + "-" + participant.getClass().getName());
                                participant.setMavenProjectFacade(projectFacade);
                                participant.setGetDeltaCallback(this.getDeltaProvider());
                                participant.setSession(session);
                                participant.setBuildContext((AbstractEclipseBuildContext)incrementalContexts.get(0));
                                try {
                                    try {
                                        participant.clean(monitor);
                                    }
                                    catch (Exception e) {
                                        MavenBuilderImpl.log.debug("Exception in build participant", (Throwable)e);
                                        buildErrors.put(e, mojoExecutionKey);
                                        participant.setMavenProjectFacade(null);
                                        participant.setGetDeltaCallback(null);
                                        participant.setSession(null);
                                        participant.setBuildContext(null);
                                        this.processMavenSessionErrors(session, mojoExecutionKey, buildErrors);
                                        continue;
                                    }
                                }
                                catch (Throwable var16_17) {
                                    participant.setMavenProjectFacade(null);
                                    participant.setGetDeltaCallback(null);
                                    participant.setSession(null);
                                    participant.setBuildContext(null);
                                    this.processMavenSessionErrors(session, mojoExecutionKey, buildErrors);
                                    throw var16_17;
                                }
                                participant.setMavenProjectFacade(null);
                                participant.setGetDeltaCallback(null);
                                participant.setSession(null);
                                participant.setBuildContext(null);
                                this.processMavenSessionErrors(session, mojoExecutionKey, buildErrors);
                            }
                        }
                        break block14;
                    }
                    catch (Exception e) {
                        buildErrors.put(e, null);
                        ** for (context : incrementalContexts)
                    }
                }
                catch (Throwable var17_24) {
                    ** for (context : incrementalContexts)
                }
lbl-1000:
                // 1 sources

                {
                    context.release();
                    continue;
lbl52:
                    // 1 sources

                    break block15;
                }
lbl-1000:
                // 1 sources

                {
                    context.release();
                    continue;
                }
lbl57:
                // 1 sources

                throw var17_24;
            }
            for (IIncrementalBuildFramework.BuildContext context : incrementalContexts) {
                context.release();
            }
        }
        this.refreshResources(project, participantResults.getFiles(), monitor);
        result = session.getResult();
        this.processBuildResults(project, mavenProject, result, participantResults, buildErrors);
    }

    DeltaProvider getDeltaProvider() {
        return this.deltaProvider;
    }
}

