/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.properties;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.sirius.common.ui.SiriusTransPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class MiscPropertySource
implements IPropertySource {
    private Object selectedObject;

    public MiscPropertySource(Object selectedObject) {
        this.selectedObject = selectedObject;
    }

    public Object getEditableValue() {
        return this.selectedObject;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        LinkedList<Field> allFields = new LinkedList<Field>();
        Field[] fields = this.selectedObject.getClass().getDeclaredFields();
        allFields.addAll(Arrays.asList(fields));
        Class<?> currentClass = this.selectedObject.getClass().getSuperclass();
        while (currentClass != Object.class) {
            fields = currentClass.getDeclaredFields();
            allFields.addAll(Arrays.asList(fields));
            currentClass = currentClass.getSuperclass();
        }
        ReflectPropertyDescriptor[] propertyDescriptors = new ReflectPropertyDescriptor[allFields.size()];
        String categName = this.selectedObject.getClass().getName().substring(this.selectedObject.getClass().getName().lastIndexOf(46) + 1);
        Iterator iterFields = allFields.iterator();
        int i = 0;
        while (iterFields.hasNext()) {
            Field currentField = (Field)iterFields.next();
            if (Modifier.isStatic(currentField.getModifiers())) continue;
            ReflectPropertyDescriptor reflectPropertyDescriptor = new ReflectPropertyDescriptor(currentField, currentField.getName(), categName);
            propertyDescriptors[i++] = reflectPropertyDescriptor;
        }
        int realSize = i;
        ReflectPropertyDescriptor[] descriptors = new ReflectPropertyDescriptor[realSize];
        System.arraycopy(propertyDescriptors, 0, descriptors, 0, realSize);
        return descriptors;
    }

    public Object getPropertyValue(Object id) {
        Object value = null;
        if (id instanceof Field) {
            Field field = (Field)id;
            boolean oldAccessible = field.isAccessible();
            try {
                field.setAccessible(true);
                try {
                    value = field.get(this.selectedObject);
                }
                catch (IllegalArgumentException e) {
                    SiriusTransPlugin.getPlugin().error(Messages.MiscPropertySource_errorGettingValueMsg, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    SiriusTransPlugin.getPlugin().error(Messages.MiscPropertySource_errorGettingValueMsg, (Throwable)e);
                }
            }
            finally {
                field.setAccessible(oldAccessible);
            }
        }
        return value;
    }

    public boolean isPropertySet(Object id) {
        return true;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    private static class ReflectPropertyDescriptor
    extends PropertyDescriptor {
        private String category;

        ReflectPropertyDescriptor(Object id, String displayName, String category) {
            super(id, displayName);
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }
    }
}

