/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.listener;

import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.vcd.IVcdDiagram;
import fr.inria.aoste.timesquare.vcd.ListConnections;
import fr.inria.aoste.timesquare.vcd.model.Description;
import fr.inria.aoste.timesquare.vcd.preferences.VcdColorPreferences;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Label;

public class MouseClickListener
implements MouseListener {
    private IVcdDiagram _vcdDiagram;
    private int _xScroll;
    private int _yScroll;
    VcdColorPreferences _mca;
    private ListConnections _listConnections;

    public MouseClickListener(ListConnections listConnections, IVcdDiagram vcdDiagram) {
        this._listConnections = listConnections;
        this._vcdDiagram = vcdDiagram;
        this._mca = vcdDiagram.getColorPreferences();
    }

    private void buttonDown1(MouseEvent e) {
        try {
            this.buttonDownold1(e);
        }
        catch (Throwable ex) {
            ErrorConsole.printError((Throwable)ex);
        }
    }

    private void buttonDown2(MouseEvent e) {
    }

    private void buttonDown3(MouseEvent e) {
        try {
            this._vcdDiagram.getMarkerFactory().showMarker(e.x, this._xScroll);
            this._vcdDiagram.getMarkerFactory().showFireable(e.x + this._xScroll);
        }
        catch (Throwable ex) {
            ErrorConsole.printError((Throwable)ex);
        }
    }

    public void mouseDown(MouseEvent e) {
        this._xScroll = this._vcdDiagram.getCanvas().getHorizontalBar().getSelection();
        this._yScroll = this._vcdDiagram.getCanvas().getVerticalBar().getSelection();
        switch (e.button) {
            case 1: {
                this.buttonDown1(e);
                break;
            }
            case 2: {
                this.buttonDown2(e);
                break;
            }
            case 3: {
                this.buttonDown3(e);
                break;
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    private void buttonDownold1(MouseEvent e) {
        try {
            IFigure fig = this._vcdDiagram.getCanvas().getContents().findFigureAt(e.x + this._xScroll, e.y + this._yScroll);
            if (fig == null) {
                return;
            }
            Description descr = fig instanceof Label ? this._vcdDiagram.getVcdFactory().getFigureForDescription(fig.getParent()) : this._vcdDiagram.getVcdFactory().getFigureForDescription(fig);
            if (descr == null) {
                return;
            }
            if (!this._listConnections.getListFind().isEmpty() && this._listConnections.getListFind().contains(fig)) {
                this._listConnections.getListFind().remove(fig);
                fig.setForegroundColor(this._mca.colorLightGreenFirable());
            }
            if (this._listConnections.getListDescription().isEmpty()) {
                if (fig instanceof Label) {
                    this._listConnections.getListDescription().add(this._vcdDiagram.getVcdFactory().getFigureForDescription(fig.getParent()));
                } else {
                    this._listConnections.getListDescription().add(this._vcdDiagram.getVcdFactory().getFigureForDescription(fig));
                }
            } else if (!this._listConnections.getListDescription().contains(descr)) {
                this._listConnections.getListDescription().add(this._vcdDiagram.getVcdFactory().getFigureForDescription(fig));
            } else {
                this._listConnections.getListDescription().remove(descr);
            }
        }
        catch (Throwable ex) {
            ErrorConsole.printError((Throwable)ex);
        }
    }
}

