/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.menu;

import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.vcd.IVcdDiagram;
import fr.inria.aoste.timesquare.vcd.dialogs.PartialDialog;
import fr.inria.aoste.timesquare.vcd.menu.Mode;
import fr.inria.aoste.timesquare.vcd.menu.VcdMenu;
import org.eclipse.jface.action.Action;

public class GhostAction
extends Action {
    private final IVcdDiagram _vcdMultiPageEditor;
    private final int _n;
    private final String _labelActive;
    private boolean _checked;

    public GhostAction(IVcdDiagram vcdMultiPageEditor, String text, int style, int n) {
        super(text, style);
        this._labelActive = text;
        this._vcdMultiPageEditor = vcdMultiPageEditor;
        this._n = n;
        this._checked = false;
        super.setChecked(this._checked);
    }

    public void run() {
        try {
            if (!this.isChecked()) {
                return;
            }
            VcdMenu vcdMenu = this._vcdMultiPageEditor.getVcdmenu();
            switch (this._n) {
                case 0: {
                    this._vcdMultiPageEditor.setGhostMode(Mode.show);
                    vcdMenu.setGhostSelected(Mode.show);
                    break;
                }
                case 1: {
                    this._vcdMultiPageEditor.setGhostMode(Mode.hide);
                    vcdMenu.setGhostSelected(Mode.hide);
                    break;
                }
                case 2: {
                    Mode oldsel = vcdMenu.getGhostSelected();
                    if (vcdMenu.getPartialGhostAction().isChecked()) {
                        PartialDialog partialDialog = new PartialDialog(this._vcdMultiPageEditor.getMyShell(), "Clocks with hidden ghosts ", "Clocks with show ghosts", this._vcdMultiPageEditor, ".");
                        int ret = partialDialog.open();
                        if (ret == 0) {
                            partialDialog.apply();
                        }
                        if (ret == 1) {
                            vcdMenu.setGhostSelected(oldsel);
                            break;
                        }
                        vcdMenu.setGhostSelected(Mode.partial);
                    }
                    break;
                }
            }
        }
        catch (Throwable e) {
            ErrorConsole.printError((Throwable)e, (String)"Ghost run");
        }
        this._vcdMultiPageEditor.setFocus();
    }

    public void setChecked(boolean checked) {
        this._checked = checked;
        if (this.isEnabled()) {
            super.setChecked(checked);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.setText(this._labelActive);
            super.setChecked(this._checked);
        } else {
            this.setText("No ghost on VcdDiagram");
            super.setChecked(false);
        }
        super.setEnabled(enabled);
    }
}

