/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.view;

import fr.inria.aoste.timesquare.vcd.model.Description;
import fr.inria.aoste.timesquare.vcd.model.Value;
import fr.inria.aoste.timesquare.vcd.model.command.VarCommand;
import fr.inria.aoste.timesquare.vcd.view.VcdFactory;
import fr.inria.aoste.timesquare.vcd.view.figure.Draw0;
import fr.inria.aoste.timesquare.vcd.view.figure.Draw1;
import fr.inria.aoste.timesquare.vcd.view.figure.DrawTimer;
import fr.inria.aoste.timesquare.vcd.view.figure.DrawX;
import fr.inria.aoste.timesquare.vcd.view.figure.DrawZ;
import fr.inria.aoste.timesquare.vcd.view.figure.ExtendFigure;
import java.util.ArrayList;
import org.eclipse.draw2d.IFigure;

public final class VcdValueFactory {
    private VcdFactory _vcdFactory;
    private int _x;
    private int _y;
    private int _counter = 0;
    private String _clockXmiId;
    private String _clockName;
    private String _aliasName;
    private ArrayList<ExtendFigure> _tickFigures = new ArrayList();
    private ArrayList<DrawX> _ghostFigures = new ArrayList();
    private boolean _isGhostVisible;
    private int _time = 0;
    private int _edge = 0;
    private boolean _isLastvalueX = false;
    private boolean _ghostinclock = false;
    private int _nbGhost = 0;
    private Value _oldValue = null;
    private Value _currentValue = null;
    private ExtendFigure _precedent;
    private VarCommand _varCommand;
    private int _tickNum = 0;

    VcdValueFactory(VarCommand vcin, VcdFactory vcdFactory, int y, double zoom) {
        this._varCommand = vcin;
        Object obj = vcin.getData("xmi");
        this._clockXmiId = obj instanceof String ? ((String)obj).substring(((String)obj).indexOf("#") + 1) : null;
        this._vcdFactory = vcdFactory;
        this._y = y;
        this._x = vcdFactory.getNameWidth();
        this._clockName = vcin.getName();
        this._aliasName = vcin.getAlias();
    }

    public String getClockName() {
        return this._clockName;
    }

    public VcdFactory getVcdFactory() {
        if (this._vcdFactory == null) {
            return null;
        }
        return this._vcdFactory;
    }

    public boolean getIsGhostVisible() {
        return this._isGhostVisible;
    }

    public void setIsGhostVisible(boolean b) {
        this._isGhostVisible = b;
    }

    public int getNbGhost() {
        return this._nbGhost;
    }

    public boolean haveGhostinclock() {
        return this._ghostinclock;
    }

    public int getTickNum() {
        return this._tickNum;
    }

    public void buildEnd(Object value, int previousTime, int time) {
        if (value instanceof Value) {
            this._vcdFactory.modifyTimeLineSize(this._time);
            String clockId = null;
            clockId = this._clockXmiId == null ? this._clockName : this._clockXmiId;
            if ((Value)((Object)value) == Value._z) {
                this._vcdFactory.drawEnd(previousTime, clockId);
            }
            this._isLastvalueX = (Value)((Object)value) == Value._x;
        } else {
            int length = time + 20 - previousTime;
            Boolean b = this.ghostundisp(value.toString());
            Description d = this.getDescription(value.toString(), length);
            ExtendFigure f = this.get(value.toString(), length);
            this._isLastvalueX = value.toString().equals("x");
            if (f != null) {
                this._vcdFactory.add(f, d, b);
            }
        }
    }

    public void build(Object v, int t, int previousTime) {
        this._time = t;
        if (v instanceof Value) {
            String clockId = null;
            clockId = this._clockXmiId == null ? this._clockName : this._clockXmiId;
            boolean bl = this._isLastvalueX = (Value)((Object)v) == Value._x;
            if ((Value)((Object)v) == Value._0) {
                this._vcdFactory.drawNoTick(previousTime, clockId);
            } else if ((Value)((Object)v) == Value._1) {
                ++this._tickNum;
                this._vcdFactory.drawTick(previousTime, clockId);
            } else if ((Value)((Object)v) == Value._z) {
                this._vcdFactory.drawZ(previousTime, clockId);
            }
        } else {
            if (v == null) {
                return;
            }
            Boolean b = this.ghostundisp(v.toString());
            Description d = this.getDescription(v.toString(), this._time);
            ExtendFigure f = this.get(v.toString(), this._time - previousTime);
            this._isLastvalueX = v.toString().equals("x");
            if (f != null) {
                this._vcdFactory.add(f, d, b);
            }
        }
    }

    public boolean ghostundisp(Value value) {
        switch (value) {
            case _0: 
            case _1: 
            case _z: {
                return false;
            }
            case _x: {
                return true;
            }
        }
        return false;
    }

    public boolean ghostundisp(String value) {
        return value.equals("x");
    }

    public int getEdge() {
        return this._edge;
    }

    private Description getDescription(Value value, int time) {
        switch (value) {
            case _1: {
                return new Description(this._clockName, this._aliasName, this._counter, String.valueOf(this._counter), this._tickFigures, time);
            }
            case _0: {
                return new Description(this._clockName, this._aliasName, -1, "-1", this._tickFigures, time);
            }
            case _x: 
            case _z: {
                return new Description(this._clockName, this._aliasName, time);
            }
        }
        return null;
    }

    private Description getDescription(String value, int time) {
        return new Description(this._clockName, this._aliasName, -1, this._tickFigures, time);
    }

    private ExtendFigure get(Value value, int length) {
        Value tmp = this._currentValue;
        this._currentValue = value;
        switch (value) {
            case _0: {
                this._oldValue = tmp;
                return this.getZero(length);
            }
            case _1: {
                ++this._counter;
                Draw1 fig = this.getOne(length);
                this._tickFigures.add(fig);
                this._oldValue = tmp;
                return fig;
            }
            case _x: {
                ExtendFigure figx = this.getX(length);
                return figx;
            }
            case _z: {
                this._oldValue = tmp;
                return this.getZ(length, true);
            }
        }
        return null;
    }

    private ExtendFigure get(String value, int length) {
        if (value.equals("z")) {
            return this.getZ(length, false);
        }
        if (this._precedent instanceof DrawTimer) {
            this._precedent.incLength(length);
            this._precedent.mycompute();
            this._x += length;
            return null;
        }
        DrawTimer drawtime = new DrawTimer(this._vcdFactory, this._x, this._y, length, "Active");
        if (this._precedent != null) {
            drawtime.setPrecedeLevel(this._precedent.getLevel());
        }
        drawtime.mycompute();
        this._x += length;
        this._precedent = drawtime;
        return drawtime;
    }

    private Draw1 getOne(int length) {
        if (this._precedent instanceof Draw1) {
            this._precedent.incLength(length);
            this._precedent.mycompute();
            this._x += length;
            return null;
        }
        Draw1 dr1 = new Draw1(this._vcdFactory, this._x, this._y, length);
        dr1.linktoTick(this._varCommand, this._counter);
        if (this._precedent != null) {
            dr1.setPrecedeLevel(this._precedent.getLevel());
        }
        dr1.setoldValue(this._isLastvalueX ? 1 : 0);
        dr1.mycompute();
        this._x += length;
        ++this._edge;
        this._precedent = dr1;
        return dr1;
    }

    private Draw0 getZero(int length) {
        if (this._precedent instanceof Draw0) {
            this._precedent.incLength(length);
            this._precedent.mycompute();
            this._x += length;
            return null;
        }
        Draw0 dr0 = new Draw0(this._vcdFactory, this._x, this._y, length);
        if (this._precedent != null) {
            dr0.setPrecedeLevel(this._precedent.getLevel());
        }
        dr0.setoldValue(this._oldValue == Value._z ? 1 : 0);
        dr0.mycompute();
        this._precedent = dr0;
        this._x += length;
        return dr0;
    }

    private DrawZ getZ(int length, boolean b) {
        if (this._precedent instanceof DrawZ) {
            this._precedent.incLength(length);
            this._precedent.mycompute();
            this._x += length;
            return null;
        }
        if (this._precedent != null) {
            this._precedent.setFuturLevel(ExtendFigure.Level.z);
            this._precedent.mycompute();
            this._precedent.repaint();
        }
        DrawZ drz = new DrawZ(this._vcdFactory, this._x, this._y, length, b);
        if (this._precedent != null) {
            drz.setPrecedeLevel(this._precedent.getLevel());
        }
        drz.setoldValue(this._oldValue == Value._z ? 1 : 0);
        drz.mycompute();
        this._x += length;
        this._precedent = drz;
        return drz;
    }

    private ExtendFigure getX(int length) {
        if (this._precedent instanceof DrawX) {
            this._precedent.incLength(length);
            this._precedent.mycompute();
            this._x += length;
            return null;
        }
        DrawX drawX = new DrawX(this._vcdFactory, this._x, this._y, length);
        if (this._precedent != null) {
            drawX.setPrecedeLevel(this._precedent.getLevel());
        }
        this._x += length;
        drawX.setGhostvisible(this._isGhostVisible);
        this._ghostinclock = true;
        ++this._nbGhost;
        this._ghostFigures.add(drawX);
        this._precedent = drawX;
        return drawX;
    }

    public void setGhostVisible(boolean b) {
        for (DrawX f : this._ghostFigures) {
            f.setGhostvisible(b);
            f.mycompute();
            this._isGhostVisible = b;
        }
    }

    public void clear() {
        if (this._tickFigures != null) {
            for (IFigure iFigure : this._tickFigures) {
                if (iFigure == null) continue;
                iFigure.erase();
            }
            this._tickFigures.clear();
        }
        if (this._ghostFigures != null) {
            for (IFigure iFigure : this._ghostFigures) {
                if (iFigure == null) continue;
                iFigure.erase();
            }
            this._ghostFigures.clear();
        }
        this._ghostFigures = null;
        this._precedent = null;
        this._tickFigures = null;
        this._vcdFactory = null;
        this._currentValue = null;
    }
}

