/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.registration.view;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecoretools.registration.EMFRegistryHelper;
import org.eclipse.emf.ecoretools.registration.Messages;
import org.eclipse.emf.ecoretools.registration.RegistrationPlugin;
import org.eclipse.emf.ecoretools.registration.internal.RegistrationIcons;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class RegisteredPackagesLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final int NSURI_COLUMN = 0;
    public static final int PACKAGE_NAME_COLUMN = 1;
    public static final int ORIGIN_COLUMN = 2;
    public static final int STATUS_COLUMN = 3;

    public String getColumnText(Object obj, int index) {
        String nsURI = (String)obj;
        Object registeredObj = EPackage.Registry.INSTANCE.get((Object)nsURI);
        EPackage registeredPackage = null;
        if (registeredObj instanceof EPackage) {
            registeredPackage = (EPackage)registeredObj;
        }
        switch (index) {
            case 0: {
                return nsURI;
            }
            case 1: {
                if (registeredPackage != null) {
                    return registeredPackage.getName();
                }
                return Messages.RegisteredPackagesLabelProvider_Unknown;
            }
            case 2: {
                if (obj != null) {
                    if (EMFRegistryHelper.isDynamicallyRegistered(nsURI) && registeredPackage != null) {
                        return this.getText(registeredPackage.eResource().getURI());
                    }
                    return "" + EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)false).get(nsURI);
                }
            }
            case 3: {
                if (obj != null) {
                    if (EMFRegistryHelper.isDynamicallyRegistered(nsURI)) {
                        return Messages.RegisteredPackagesLabelProvider_DynamicallyRegistered;
                    }
                    if (EMFRegistryHelper.isRegisteredAndLoaded(nsURI)) {
                        return NLS.bind((String)Messages.RegisteredPackagesLabelProvider_RegisteredGeneratedJavaFromPlugin, (Object)RegistrationPlugin.getDefault().getPluginID(nsURI));
                    }
                    return NLS.bind((String)Messages.RegisteredPackagesLabelProvider_NotLoadedGeneratedJavaFromPlugin, (Object)RegistrationPlugin.getDefault().getPluginID(nsURI));
                }
                return "";
            }
        }
        return "";
    }

    public Image getColumnImage(Object obj, int index) {
        if (index == 2) {
            String nsURI = (String)obj;
            if (EMFRegistryHelper.isDynamicallyRegistered(nsURI)) {
                return RegistrationIcons.get("IMG_ECORE_FILE");
            }
            if (EMFRegistryHelper.isRegisteredAndLoaded(nsURI)) {
                return RegistrationIcons.get("IMG_GENERATED_PACKAGE");
            }
            return RegistrationIcons.get("IMG_LAZY_GENERATED_PACKAGE");
        }
        return null;
    }

    public Image getImage(Object obj) {
        return null;
    }
}

