/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.parser.xtext.ui.contentassist;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockConstraintSystem;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.AbstractEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExpressionDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.KernelRelationDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelationDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.ImportStatement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.NamedElement;
import fr.inria.aoste.timesquare.ccslkernel.parser.xtext.ui.RessourceImage;
import fr.inria.aoste.timesquare.ccslkernel.parser.xtext.ui.contentassist.AbstractExtendedCCSLProposalProvider;
import fr.inria.aoste.timesquare.ccslkernel.xtext.util.BindingPredicate;
import fr.inria.aoste.timesquare.utils.umlhelpers.UmlHelpers;
import java.util.ArrayList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class ExtendedCCSLProposalProvider
extends AbstractExtendedCCSLProposalProvider {
    @Inject
    ImportUriResolver resolver;
    @Inject
    private IResourceServiceProvider.Registry serviceProviderRegistry;

    private String generateName(String base, Resource r) {
        ArrayList<String> l = new ArrayList<String>();
        TreeIterator ieos = r.getAllContents();
        while (ieos.hasNext()) {
            EObject eo = (EObject)ieos.next();
            if (!(eo instanceof NamedElement)) continue;
            l.add(((NamedElement)eo).getName());
        }
        String name = base;
        int i = 0;
        do {
            name = String.valueOf(base) + i;
            ++i;
        } while (l.indexOf(name) != -1);
        return name;
    }

    @Override
    public void complete_Relation(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        try {
            ResourceSet rs = model.eResource().getResourceSet();
            String name = this.generateName("relation_", model.eResource());
            ArrayList<RelationDeclaration> l = new ArrayList<RelationDeclaration>();
            for (Resource r : rs.getResources()) {
                TreeIterator ieo = r.getAllContents();
                while (ieo.hasNext()) {
                    EObject eo = (EObject)ieo.next();
                    if (!(eo instanceof RelationDeclaration)) continue;
                    l.add((RelationDeclaration)eo);
                }
            }
            for (RelationDeclaration rd : l) {
                try {
                    String proposal = "Relation :" + rd.getName() + "    ";
                    String text = "Relation " + name + "[" + rd.getName() + "](  ";
                    boolean bool = false;
                    if (rd instanceof KernelRelationDeclaration) {
                        text = String.valueOf(text) + " " + ((KernelRelationDeclaration)rd).getLeftEntity().getName() + " -> . ,";
                        text = String.valueOf(text) + "\t" + ((KernelRelationDeclaration)rd).getRightEntity().getName() + " -> . ";
                        bool = true;
                    }
                    for (AbstractEntity b : rd.getParameters()) {
                        if (bool) {
                            text = String.valueOf(text) + ",\t";
                        }
                        text = String.valueOf(text) + b.getName() + "-> . ";
                        bool = true;
                    }
                    text = String.valueOf(text) + " )\n";
                    ICompletionProposal completionProposal = this.createCompletionProposal(text, proposal, RessourceImage.relationimage, context);
                    acceptor.accept(completionProposal);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable e) {
            System.err.println(e);
        }
    }

    @Override
    public void complete_Expression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        try {
            ResourceSet rs = model.eResource().getResourceSet();
            String name = this.generateName("expression_", model.eResource());
            ArrayList<ExpressionDeclaration> l = new ArrayList<ExpressionDeclaration>();
            for (Resource r : rs.getResources()) {
                TreeIterator ieo = r.getAllContents();
                while (ieo.hasNext()) {
                    EObject eo = (EObject)ieo.next();
                    if (!(eo instanceof ExpressionDeclaration)) continue;
                    l.add((ExpressionDeclaration)eo);
                }
            }
            for (ExpressionDeclaration rd : l) {
                try {
                    String proposal = "Expression " + rd.getName();
                    String text = "Expression " + name + "=" + rd.getName() + "( ";
                    boolean bool = false;
                    for (EObject b : rd.eContents()) {
                        if (bool) {
                            text = String.valueOf(text) + "\t,";
                        }
                        if (b instanceof AbstractEntity) {
                            text = String.valueOf(text) + ((AbstractEntity)b).getName() + " -> . ";
                        }
                        bool = true;
                    }
                    text = String.valueOf(text) + " )\n";
                    ICompletionProposal completionProposal = this.createCompletionProposal(text, proposal, RessourceImage.expressionimage, context);
                    acceptor.accept(completionProposal);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void completeEvent_ReferencedObjectRefs(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        try {
            ClockConstraintSystem ccslSpecification = (ClockConstraintSystem)context.getRootModel();
            for (ImportStatement importStatement : ccslSpecification.getImports()) {
                ICompletionProposal completionProposal;
                String text;
                String proposal;
                String extension;
                Resource importedResource;
                String importUri;
                if (importStatement.getImportURI() == null || importStatement.getImportURI().length() == 0 || (importUri = this.resolver.resolve((EObject)importStatement)) == null || "platform:/".equals(importUri) || (importedResource = EcoreUtil2.getResource((Resource)importStatement.eResource(), (String)importUri)) == null || (extension = importedResource.getURI().fileExtension()).equals("ccslLib") || this.serviceProviderRegistry.getResourceServiceProvider(importedResource.getURI()) != null) continue;
                String prefix = "";
                if (!prefix.isEmpty()) {
                    proposal = " " + prefix + " ...";
                    text = "\"" + prefix;
                    completionProposal = this.createCompletionProposal(text, proposal, null, context);
                    acceptor.accept(completionProposal);
                }
                TreeIterator contentIterator = importedResource.getAllContents();
                while (contentIterator.hasNext()) {
                    EObject targetObject = (EObject)contentIterator.next();
                    EClass targetClass = targetObject.eClass();
                    EStructuralFeature esf = null;
                    esf = targetClass.getEStructuralFeature("qualifiedName");
                    if (esf == null || !esf.isDerived()) {
                        esf = targetClass.getEStructuralFeature("name");
                    }
                    Object s = null;
                    if (esf != null) {
                        s = targetObject.eGet(esf);
                    }
                    if (s == null || !(s instanceof String)) continue;
                    proposal = String.valueOf((String)s) + "  [" + targetClass.getName() + "]";
                    text = "\"" + prefix + (String)s + "\"";
                    completionProposal = this.createCompletionProposal(text, proposal, this.getLabelProvider().getImage((Object)targetObject), context);
                    acceptor.accept(completionProposal);
                    for (EObject eo : targetObject.eClass().eContents()) {
                        if (!(eo instanceof EOperation)) continue;
                        String sOp = String.valueOf(((EOperation)eo).getName()) + "()";
                        String className = ((EOperation)eo).eClass().getName();
                        proposal = String.valueOf((String)s) + "::" + sOp + "  [" + className + "]";
                        text = "\"" + prefix + (String)s + "::" + sOp + "\"";
                        completionProposal = this.createCompletionProposal(text, proposal, this.getLabelProvider().getImage((Object)targetObject), context);
                        acceptor.accept(completionProposal);
                    }
                    UmlHelpers umlHelper = new UmlHelpers();
                    ArrayList additionnalPropName = umlHelper.getPropertyNameToDisplayInXtext(targetObject);
                    ArrayList additionnalProp = umlHelper.getPropertyToDisplayInXtext(targetObject);
                    int i = 0;
                    while (i < additionnalPropName.size()) {
                        String sProp = (String)additionnalPropName.get(i);
                        proposal = String.valueOf((String)s) + "::" + sProp + "  [" + ((EObject)additionnalProp.get(i)).getClass().getName() + "]";
                        text = "\"" + prefix + (String)s + "::" + sProp + "\"";
                        completionProposal = this.createCompletionProposal(text, proposal, this.getLabelProvider().getImage((Object)targetObject), context);
                        acceptor.accept(completionProposal);
                        ++i;
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        super.completeEvent_ReferencedObjectRefs(model, assignment, context, acceptor);
    }

    @Override
    public void completeBinding_Abstract(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.lookupCrossReference((CrossReference)assignment.getTerminal(), context, acceptor, (Predicate)new BindingPredicate(model, BindingPredicate.binding_Abstract));
    }

    @Override
    public void completeBinding_Bindable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.lookupCrossReference((CrossReference)assignment.getTerminal(), context, acceptor, (Predicate)new BindingPredicate(model, BindingPredicate.binding_Bindable));
    }
}

