/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.test.lib;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import fr.inria.diverse.melange.metamodel.melange.ModelTypingSpace;
import java.util.List;
import java.util.function.Consumer;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gemoc.trace.gemoc.generator.TraceAddonGeneratorIntegration;
import org.eclipse.gemoc.xdsmlframework.test.lib.WorkspaceTestHelper;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.junit4.ui.util.IResourcesSetupUtil;
import org.eclipse.xtext.junit4.ui.util.JavaProjectSetupUtil;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.OutlinePage;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.resource.XtextResourceSetProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.junit.Assert;

public class MelangeWorkspaceTestHelper
extends WorkspaceTestHelper {
    private static final String MELANGE_CMD_GENERATE_ALL = "fr.inria.diverse.melange.GenerateAll";
    private static final String MELANGE_CMD_GENERATE_ADAPTERS = "fr.inria.diverse.melange.GenerateAdapters";
    private static final String MELANGE_CMD_GENERATE_LANGUAGES = "fr.inria.diverse.melange.GenerateLanguages";
    private static final String MELANGE_CMD_GENERATE_INTERFACES = "fr.inria.diverse.melange.GenerateInterfaces";
    private static final String MELANGE_CMD_GENERATE_TRACE = "org.eclipse.gemoc.execution.sequential.javaxdsml.ide.ui.commands.GenerateTraceAddonPlugin";
    private static final String MELANGE_CMD_CLEAN_ALL = "fr.inria.diverse.melange.CleanAll";
    private static final String MELANGE_EDITOR_ID = "fr.inria.diverse.melange.Melange";
    @Inject
    private XtextResourceSetProvider rsProvider;

    @Override
    public void init() {
        Display _default = Display.getDefault();
        _default.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().showPerspective("org.eclipse.gemoc.xdsmlframework.ide.ui.xdsml.perspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                    MelangeWorkspaceTestHelper.this.closeWelcomePage();
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        });
    }

    public IProject deployMelangeProject(String projectName, String zipLocation) {
        try {
            IJavaProject newProject = JavaProjectSetupUtil.createJavaProject((String)projectName);
            JavaProjectSetupUtil.addSourceFolder((IJavaProject)newProject, (String)"src");
            JavaProjectSetupUtil.addSourceFolder((IJavaProject)newProject, (String)"src-gen");
            IResourcesSetupUtil.addNature((IProject)newProject.getProject(), (String)"org.eclipse.xtext.ui.shared.xtextNature");
            IResourcesSetupUtil.addNature((IProject)newProject.getProject(), (String)"org.eclipse.pde.PluginNature");
            IResourcesSetupUtil.addBuilder((IProject)newProject.getProject(), (String)"org.eclipse.xtext.ui.shared.xtextBuilder");
            IResourcesSetupUtil.addBuilder((IProject)newProject.getProject(), (String)"org.eclipse.pde.ManifestBuilder");
            IResourcesSetupUtil.addBuilder((IProject)newProject.getProject(), (String)"org.eclipse.pde.SchemaBuilder");
            Path _path = new Path("org.eclipse.xtend.XTEND_CONTAINER");
            JavaProjectSetupUtil.addToClasspath((IJavaProject)newProject, (IClasspathEntry)JavaCore.newContainerEntry((IPath)_path));
            Path _path_1 = new Path("org.eclipse.pde.core.requiredPlugins");
            JavaProjectSetupUtil.addToClasspath((IJavaProject)newProject, (IClasspathEntry)JavaCore.newContainerEntry((IPath)_path_1));
            ZipFile zip = new ZipFile(zipLocation);
            ZipLeveledStructureProvider structureProvider = new ZipLeveledStructureProvider(zip);
            IOverwriteQuery queryOverwrite = new IOverwriteQuery(){

                public String queryOverwrite(String file) {
                    return "ALL";
                }
            };
            IPath _fullPath = newProject.getProject().getFullPath();
            Object _root = structureProvider.getRoot();
            ImportOperation _importOperation = new ImportOperation(_fullPath, _root, (IImportStructureProvider)structureProvider, queryOverwrite);
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            _importOperation.run((IProgressMonitor)_nullProgressMonitor);
            zip.close();
            return newProject.getProject();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void generateAll(String melangeFile) {
        WorkspaceTestHelper.invokeCommandOnSelectedFile(MELANGE_CMD_GENERATE_ALL, melangeFile);
    }

    public void generateAdapters(String melangeFile) {
        WorkspaceTestHelper.invokeCommandOnSelectedFile(MELANGE_CMD_GENERATE_ADAPTERS, melangeFile);
    }

    public void generateLanguages(String melangeFile) {
        WorkspaceTestHelper.invokeCommandOnSelectedFile(MELANGE_CMD_GENERATE_LANGUAGES, melangeFile);
    }

    public void generateInterfaces(String melangeFile) {
        WorkspaceTestHelper.invokeCommandOnSelectedFile(MELANGE_CMD_GENERATE_INTERFACES, melangeFile);
    }

    public void generateTrace(String melangeFile, final String languageName, final String targetProjectName) {
        try {
            boolean _notEquals;
            IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
            Path _path = new Path(melangeFile);
            final IFile mlgFile = _root.getFile((IPath)_path);
            String _string = melangeFile.toString();
            String _plus = "Generating trace addon plugin for " + _string;
            abstract class __MelangeWorkspaceTestHelper_3
            extends Job {
                Exception reportedJobException;

                __MelangeWorkspaceTestHelper_3(String arg0) {
                    super(arg0);
                }
            }
            __MelangeWorkspaceTestHelper_3 j = new __MelangeWorkspaceTestHelper_3(this, _plus){
                {
                    super($anonymous0);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        TraceAddonGeneratorIntegration.generateAddon((IFile)mlgFile, (String)languageName, (String)targetProjectName, (boolean)true, (IProgressMonitor)monitor);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) {
                            Exception e;
                            this.reportedJobException = e = (Exception)_t;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    return new Status(0, "org.eclipse.gemoc.trace.gemoc.ui", "Multidimensional Trace addon plugin generated.");
                }
            };
            j.schedule();
            j.join();
            boolean bl = _notEquals = !Objects.equal((Object)j.reportedJobException, null);
            if (_notEquals) {
                throw j.reportedJobException;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void cleanAll(final String melangeFile) {
        Display _default = Display.getDefault();
        _default.syncExec(new Runnable(){

            @Override
            public void run() {
                WorkspaceTestHelper.invokeCommandOnSelectedFile(MelangeWorkspaceTestHelper.MELANGE_CMD_CLEAN_ALL, melangeFile);
            }
        });
    }

    public XtextEditor openEditor(String melangeFile) {
        try {
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot _root = ws.getRoot();
            Path _path = new Path(melangeFile);
            IFile mlgFile = _root.getFile((IPath)_path);
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchPage _activePage = wb.getActiveWorkbenchWindow().getActivePage();
            FileEditorInput _fileEditorInput = new FileEditorInput(mlgFile);
            IEditorPart openEditor = _activePage.openEditor((IEditorInput)_fileEditorInput, MELANGE_EDITOR_ID);
            XtextEditor xtextEditor = EditorUtils.getXtextEditor((IEditorPart)openEditor);
            if (xtextEditor != null) {
                xtextEditor.selectAndReveal(0, 0);
                xtextEditor.getInternalSourceViewer().setSelectedRange(0, 0);
                xtextEditor.getInternalSourceViewer().getTextWidget().setFocus();
                return xtextEditor;
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return null;
    }

    public TreeViewer getOutline(String melangeFile) {
        XtextEditor editor = this.openEditor(melangeFile);
        IContentOutlinePage _adapter = (IContentOutlinePage)editor.getAdapter(IContentOutlinePage.class);
        OutlinePage outlinePage = (OutlinePage)_adapter;
        TreeViewer treeViewer = outlinePage.getTreeViewer();
        return treeViewer;
    }

    public void assertK3AspectsExists(List<Pair<String, String>> aspects, String project) {
        String ASPECTS_NS = String.valueOf(project) + ".aspects";
        String ASPECTS_FOLDER = ASPECTS_NS.replaceAll("\\.", "/");
        String SRC_GEN = "src-gen";
        Consumer<Pair> _function = asp -> {
            String aspectName = (String)asp.getKey();
            String targetClass = (String)asp.getValue();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(project);
            _builder.append("/");
            _builder.append("src-gen");
            _builder.append("/");
            _builder.append(ASPECTS_FOLDER);
            _builder.append("/");
            _builder.append(aspectName);
            _builder.append(".java");
            String aspect = _builder.toString();
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(project);
            _builder_1.append("/");
            _builder_1.append("src-gen");
            _builder_1.append("/");
            _builder_1.append(ASPECTS_FOLDER);
            _builder_1.append("/");
            _builder_1.append(aspectName);
            _builder_1.append(targetClass);
            _builder_1.append("AspectContext.java");
            String context = _builder_1.toString();
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append(project);
            _builder_2.append("/");
            _builder_2.append("src-gen");
            _builder_2.append("/");
            _builder_2.append(ASPECTS_FOLDER);
            _builder_2.append("/");
            _builder_2.append(aspectName);
            _builder_2.append(targetClass);
            _builder_2.append("AspectProperties.java");
            String properties = _builder_2.toString();
            this.assertFileExists(aspect);
            this.assertFileExists(context);
            this.assertFileExists(properties);
        };
        aspects.forEach(_function);
    }

    public void assertK3AspectsDontExists(List<Pair<String, String>> aspects, String project) {
        String ASPECTS_NS = String.valueOf(project) + ".aspects";
        String ASPECTS_FOLDER = ASPECTS_NS.replaceAll("\\.", "/");
        String SRC_GEN = "src-gen";
        Consumer<Pair> _function = asp -> {
            String aspectName = (String)asp.getKey();
            String targetClass = (String)asp.getValue();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(project);
            _builder.append("/");
            _builder.append("src-gen");
            _builder.append("/");
            _builder.append(ASPECTS_FOLDER);
            _builder.append("/");
            _builder.append(aspectName);
            _builder.append(".java");
            String aspect = _builder.toString();
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(project);
            _builder_1.append("/");
            _builder_1.append("src-gen");
            _builder_1.append("/");
            _builder_1.append(ASPECTS_FOLDER);
            _builder_1.append("/");
            _builder_1.append(aspectName);
            _builder_1.append(targetClass);
            _builder_1.append("AspectContext.java");
            String context = _builder_1.toString();
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append(project);
            _builder_2.append("/");
            _builder_2.append("src-gen");
            _builder_2.append("/");
            _builder_2.append(ASPECTS_FOLDER);
            _builder_2.append("/");
            _builder_2.append(aspectName);
            _builder_2.append(targetClass);
            _builder_2.append("AspectProperties.java");
            String properties = _builder_2.toString();
            this.assertFileDontExists(aspect);
            this.assertFileDontExists(context);
            this.assertFileDontExists(properties);
        };
        aspects.forEach(_function);
    }

    public EPackage getMT(IProject project, String mtName) {
        ResourceSetImpl rs = new ResourceSetImpl();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("platform:/resource/");
        String _name = project.getName();
        _builder.append(_name);
        _builder.append("/model-gen/");
        _builder.append(mtName);
        _builder.append(".ecore");
        Resource res = rs.getResource(URI.createURI((String)_builder.toString()), true);
        EObject _head = (EObject)IterableExtensions.head((Iterable)res.getContents());
        return (EPackage)_head;
    }

    public void assertMatch(EPackage pkg, String refEcore) {
        boolean _not;
        ResourceSetImpl rs = new ResourceSetImpl();
        URI uri = URI.createURI((String)refEcore);
        Resource res = rs.getResource(uri, true);
        EObject _head = (EObject)IterableExtensions.head((Iterable)res.getContents());
        EPackage ref = (EPackage)_head;
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)pkg, (Notifier)ref, null);
        EMFCompare.Builder _builder = EMFCompare.builder();
        Comparison comparison = _builder.setDiffEngine((IDiffEngine)new DefaultDiffEngine(){

            public FeatureFilter createFeatureFilter() {
                return new FeatureFilter(){

                    public boolean isIgnoredReference(Match match, EReference ref) {
                        return Objects.equal((Object)ref, (Object)EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS) || super.isIgnoredReference(match, ref);
                    }

                    public boolean checkForOrderingChanges(EStructuralFeature f) {
                        return false;
                    }
                };
            }
        }).build().compare((IComparisonScope)scope);
        boolean _isEmpty = comparison.getDifferences().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Assert.fail((String)IterableExtensions.join((Iterable)comparison.getDifferences(), (CharSequence)", "));
        }
        Assert.assertTrue((boolean)comparison.getDifferences().isEmpty());
    }

    public void assertMatch(EPackage pkg, IOutlineNode node) {
        Assert.assertEquals((Object)pkg.getName(), (Object)node.getText().toString());
        EList subPack = pkg.getESubpackages();
        EList classes = pkg.getEClassifiers();
        List subNodes = node.getChildren();
        Consumer<EPackage> _function = p -> {
            Functions.Function1 _function_1 = it -> {
                String _string = it.getText().toString();
                String _name = p.getName();
                return Objects.equal((Object)_string, (Object)_name);
            };
            IOutlineNode n = (IOutlineNode)IterableExtensions.findFirst((Iterable)subNodes, (Functions.Function1)_function_1);
            Assert.assertNotNull((Object)n);
            this.assertMatch((EPackage)p, n);
        };
        subPack.forEach(_function);
        Consumer<EClassifier> _function_1 = c -> {
            Functions.Function1 _function_2 = it -> {
                String _string = it.getText().toString();
                String _name = c.getName();
                return Objects.equal((Object)_string, (Object)_name);
            };
            IOutlineNode n = (IOutlineNode)IterableExtensions.findFirst((Iterable)subNodes, (Functions.Function1)_function_2);
            Assert.assertNotNull((Object)n);
            if (c instanceof EClass) {
                this.assertMatch((EClass)c, n);
            }
        };
        classes.forEach(_function_1);
    }

    public void assertMatch(EClass cls, IOutlineNode node) {
        Assert.assertEquals((Object)cls.getName(), (Object)node.getText().toString());
        EList ref = cls.getEAllReferences();
        EList att = cls.getEAllAttributes();
        EList op = cls.getEAllOperations();
        List subNodes = node.getChildren();
        Consumer<EReference> _function = r -> {
            Functions.Function1 _function_1 = it -> {
                String _string = it.getText().toString();
                String _name = r.getName();
                String _plus = String.valueOf(_name) + " : ";
                String _name_1 = r.getEType().getName();
                String _plus_1 = String.valueOf(_plus) + _name_1;
                return Objects.equal((Object)_string, (Object)_plus_1);
            };
            IOutlineNode n = (IOutlineNode)IterableExtensions.findFirst((Iterable)subNodes, (Functions.Function1)_function_1);
            Assert.assertNotNull((Object)n);
        };
        ref.forEach(_function);
        Consumer<EAttribute> _function_1 = a -> {
            Functions.Function1 _function_2 = it -> {
                String _string = it.getText().toString();
                String _name = a.getName();
                String _plus = String.valueOf(_name) + " : ";
                String _name_1 = a.getEType().getName();
                String _plus_1 = String.valueOf(_plus) + _name_1;
                return Objects.equal((Object)_string, (Object)_plus_1);
            };
            IOutlineNode n = (IOutlineNode)IterableExtensions.findFirst((Iterable)subNodes, (Functions.Function1)_function_2);
            Assert.assertNotNull((Object)n);
        };
        att.forEach(_function_1);
        Consumer<EOperation> _function_2 = o -> {
            Functions.Function1 _function_3 = it -> {
                String _string = it.getText().toString();
                String _name = o.getName();
                String _plus = String.valueOf(_name) + " : ";
                String _name_1 = o.getEType().getName();
                String _plus_1 = String.valueOf(_plus) + _name_1;
                return Objects.equal((Object)_string, (Object)_plus_1);
            };
            IOutlineNode n = (IOutlineNode)IterableExtensions.findFirst((Iterable)subNodes, (Functions.Function1)_function_3);
            Assert.assertNotNull((Object)n);
        };
        op.forEach(_function_2);
    }

    public void assertMatch(String refEcore, IOutlineNode node) {
        ResourceSetImpl rs = new ResourceSetImpl();
        URI uri = URI.createURI((String)refEcore);
        Resource res = rs.getResource(uri, true);
        EObject _head = (EObject)IterableExtensions.head((Iterable)res.getContents());
        EPackage ref = (EPackage)_head;
        this.assertMatch(ref, node);
    }

    public ModelTypingSpace getResource(String projectName, String melangeFile) {
        IProject melangeProject = this.getProject(projectName);
        ResourceSet rs = this.rsProvider.get(melangeProject);
        URI uri = URI.createPlatformResourceURI((String)melangeFile, (boolean)true);
        Resource _resource = rs.getResource(uri, true);
        DerivedStateAwareResource res = (DerivedStateAwareResource)_resource;
        res.installDerivedState(false);
        EObject _head = (EObject)IterableExtensions.head((Iterable)res.getContents());
        return (ModelTypingSpace)_head;
    }
}

