/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.themes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tm4e.ui.internal.themes.AbstractThemeManager;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;
import org.eclipse.tm4e.ui.themes.IThemeManager;
import org.osgi.service.prefs.BackingStoreException;

public class WorkingCopyThemeManager
extends AbstractThemeManager {
    private final IThemeManager manager;
    private List<ITheme> themeAdded;
    private List<ITheme> themeRemoved;
    private List<IThemeAssociation> associationAdded;
    private List<IThemeAssociation> associationRemoved;

    public WorkingCopyThemeManager(IThemeManager manager) {
        this.manager = manager;
        this.load();
    }

    private void load() {
        IThemeAssociation[] associations;
        ITheme[] themes;
        ITheme[] iThemeArray = themes = this.manager.getThemes();
        int n = themes.length;
        int n2 = 0;
        while (n2 < n) {
            ITheme theme = iThemeArray[n2];
            super.registerTheme(theme);
            ++n2;
        }
        IThemeAssociation[] iThemeAssociationArray = associations = this.manager.getAllThemeAssociations();
        int n3 = associations.length;
        n = 0;
        while (n < n3) {
            IThemeAssociation association = iThemeAssociationArray[n];
            super.registerThemeAssociation(association);
            ++n;
        }
    }

    @Override
    public void registerTheme(ITheme theme) {
        super.registerTheme(theme);
        if (this.themeAdded == null) {
            this.themeAdded = new ArrayList<ITheme>();
        }
        this.themeAdded.add(theme);
    }

    @Override
    public void unregisterTheme(ITheme theme) {
        super.unregisterTheme(theme);
        if (this.themeAdded != null && this.themeAdded.contains(theme)) {
            this.themeAdded.remove(theme);
        } else {
            if (this.themeRemoved == null) {
                this.themeRemoved = new ArrayList<ITheme>();
            }
            this.themeRemoved.add(theme);
        }
    }

    @Override
    public void registerThemeAssociation(IThemeAssociation association) {
        super.registerThemeAssociation(association);
        if (this.associationAdded == null) {
            this.associationAdded = new ArrayList<IThemeAssociation>();
        }
        this.associationAdded.add(association);
    }

    @Override
    public void unregisterThemeAssociation(IThemeAssociation association) {
        super.unregisterThemeAssociation(association);
        if (this.associationAdded != null && this.associationAdded.contains(association)) {
            this.associationAdded.remove(association);
        } else {
            if (this.associationRemoved == null) {
                this.associationRemoved = new ArrayList<IThemeAssociation>();
            }
            this.associationRemoved.add(association);
        }
    }

    @Override
    public void save() throws BackingStoreException {
        if (this.themeAdded != null) {
            for (ITheme theme : this.themeAdded) {
                this.manager.registerTheme(theme);
            }
        }
        if (this.themeRemoved != null) {
            for (ITheme theme : this.themeRemoved) {
                this.manager.unregisterTheme(theme);
            }
        }
        if (this.associationAdded != null) {
            for (IThemeAssociation association : this.associationAdded) {
                this.manager.registerThemeAssociation(association);
            }
        }
        if (this.associationRemoved != null) {
            for (IThemeAssociation association : this.associationRemoved) {
                this.manager.unregisterThemeAssociation(association);
            }
        }
        if (this.themeAdded != null || this.themeRemoved != null || this.associationAdded != null || this.associationRemoved != null) {
            this.manager.save();
        }
    }
}

