/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.db;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.aspectj.org.eclipse.jdt.internal.core.nd.IndexExceptionBuilder;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.Chunk;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.ChunkCache;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.ChunkWriter;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.DBStatus;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.IString;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.IndexException;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.LargeBlock;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.LongString;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.MemoryStats;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.ModificationLog;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.Package;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.ShortString;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class Database {
    public static final int CHAR_SIZE = 2;
    public static final int BYTE_SIZE = 1;
    public static final int SHORT_SIZE = 2;
    public static final int INT_SIZE = 4;
    public static final int LONG_SIZE = 8;
    public static final int CHUNK_SIZE = 4096;
    public static final int OFFSET_IN_CHUNK_MASK = 4095;
    public static final int BLOCK_HEADER_SIZE = 2;
    public static final int BLOCK_SIZE_DELTA_BITS = 3;
    public static final int BLOCK_SIZE_DELTA = 8;
    private static final int BLOCK_PREV_OFFSET = 2;
    private static final int BLOCK_NEXT_OFFSET = 6;
    private static final int FREE_BLOCK_HEADER_SIZE = 10;
    public static final int MIN_BLOCK_DELTAS = 2;
    public static final int MAX_BLOCK_DELTAS = (4096 - LargeBlock.HEADER_SIZE - LargeBlock.FOOTER_SIZE) / 8;
    public static final int MAX_SINGLE_BLOCK_MALLOC_SIZE = MAX_BLOCK_DELTAS * 8 - 2;
    public static final int PTR_SIZE = 4;
    public static final int STRING_SIZE = 4;
    public static final int FLOAT_SIZE = 4;
    public static final int DOUBLE_SIZE = 8;
    public static final long MAX_DB_SIZE = 0x800000000L;
    public static final long MAX_MALLOC_SIZE = 0x800000000L - (long)LargeBlock.HEADER_SIZE - (long)LargeBlock.FOOTER_SIZE - 4096L - 2L;
    public static final int VERSION_OFFSET = 0;
    public static final int MALLOC_TABLE_OFFSET = 4;
    public static final int FREE_BLOCK_OFFSET = 2048;
    public static final int WRITE_NUMBER_OFFSET = 2052;
    public static final int MALLOC_STATS_OFFSET = 2060;
    public static final int DATA_AREA_OFFSET = 2060 + MemoryStats.SIZE;
    public static final int NUM_HEADER_CHUNKS = 1;
    public static final short POOL_MISC = 0;
    public static final short POOL_BTREE = 1;
    public static final short POOL_DB_PROPERTIES = 2;
    public static final short POOL_STRING_LONG = 3;
    public static final short POOL_STRING_SHORT = 4;
    public static final short POOL_LINKED_LIST = 5;
    public static final short POOL_STRING_SET = 6;
    public static final short POOL_GROWABLE_ARRAY = 7;
    public static final short POOL_FIRST_NODE_TYPE = 256;
    private static final int MAX_ITERATIONS_PER_LOCK = 256;
    private static final int WRITE_BUFFER_SIZE = 131072;
    public static boolean DEBUG_FREE_SPACE;
    public static boolean DEBUG_PAGE_CACHE;
    private final File fLocation;
    private final boolean fReadOnly;
    private RandomAccessFile fFile;
    private boolean fExclusiveLock;
    private boolean fLocked;
    private boolean fIsMarkedIncomplete;
    private int fVersion;
    private final Chunk fHeaderChunk;
    Chunk[] fChunks;
    private int fChunksUsed;
    private ChunkCache fCache;
    private long malloced;
    private long freed;
    private long cacheHits;
    private long cacheMisses;
    private long bytesWritten;
    private long totalReadTimeMs;
    private MemoryStats memoryUsage;
    public Chunk fMostRecentlyFetchedChunk;
    private HashSet<Chunk> dirtyChunkSet = new HashSet();
    private long totalFlushTime;
    private long totalWriteTimeMs;
    private long pageWritesBytes;
    private long nextValidation;
    private long validateCounter;
    public static final double MIN_BYTES_PER_MILLISECOND = 20480.0;
    private final ModificationLog log = new ModificationLog(0);
    private final ModificationLog.Tag mallocTag = ModificationLog.createTag("Calling Database.malloc");
    private final ModificationLog.Tag freeTag = ModificationLog.createTag("Calling Database.free");

    public Database(File location, ChunkCache cache, int version, boolean openReadOnly) throws IndexException {
        try {
            this.fLocation = location;
            this.fReadOnly = openReadOnly;
            this.fCache = cache;
            this.openFile();
            int nChunksOnDisk = (int)(this.fFile.length() / 4096L);
            this.fHeaderChunk = new Chunk(this, 0);
            if (nChunksOnDisk <= 0) {
                this.fVersion = version;
                this.fChunks = new Chunk[1];
                this.fChunksUsed = this.fChunks.length;
            } else {
                this.fHeaderChunk.read();
                this.fVersion = this.fHeaderChunk.getInt(0L);
                this.fChunks = new Chunk[nChunksOnDisk];
                this.fChunksUsed = nChunksOnDisk;
            }
        }
        catch (IOException e) {
            throw new IndexException((IStatus)new DBStatus(e));
        }
        this.memoryUsage = new MemoryStats(this.fHeaderChunk, 2060L);
    }

    private static int divideRoundingUp(long num, long den) {
        return (int)((num + den - 1L) / den);
    }

    private void openFile() throws FileNotFoundException {
        this.fFile = new RandomAccessFile(this.fLocation, this.fReadOnly ? "r" : "rw");
    }

    void read(ByteBuffer buf, long position) throws IOException {
        int retries = 0;
        while (true) {
            try {
                this.fFile.getChannel().read(buf, position);
                return;
            }
            catch (ClosedChannelException e) {
                this.openFile();
                if (!(e instanceof ClosedByInterruptException)) continue;
                throw new OperationCanceledException();
                if (++retries < 20) continue;
                throw e;
            }
            break;
        }
    }

    public ModificationLog getLog() {
        return this.log;
    }

    boolean write(ByteBuffer buf, long position) throws IOException {
        this.bytesWritten += (long)buf.limit();
        return this.performUninterruptableWrite(() -> this.fFile.getChannel().write(buf, position));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean performUninterruptableWrite(IORunnable runnable) throws IOException {
        boolean interrupted = false;
        int retries = 0;
        while (true) {
            try {
                runnable.run();
                return interrupted;
            }
            catch (ClosedChannelException e) {
                this.openFile();
                if (e instanceof ClosedByInterruptException) {
                    interrupted = true;
                    continue;
                }
                if (++retries > 20) throw e;
                continue;
            }
            break;
        }
    }

    public void transferTo(FileChannel target) throws IOException {
        assert (this.fLocked);
        FileChannel from = this.fFile.getChannel();
        long nRead = 0L;
        long position = 0L;
        long size = from.size();
        while (position < size) {
            nRead = from.transferTo(position, 65536L, target);
            if (nRead == 0L) break;
            position += nRead;
        }
    }

    public int getVersion() {
        return this.fVersion;
    }

    public void setVersion(int version) throws IndexException {
        assert (this.fExclusiveLock);
        this.fHeaderChunk.putInt(0L, version);
        this.fVersion = version;
    }

    public boolean clear(int version) throws IndexException {
        assert (this.fExclusiveLock);
        boolean wasCanceled = false;
        this.removeChunksFromCache();
        this.log.clear();
        this.fVersion = version;
        this.fHeaderChunk.clear(0L, 4096);
        this.fChunks = new Chunk[1];
        this.dirtyChunkSet.clear();
        this.fChunksUsed = this.fChunks.length;
        try {
            wasCanceled = this.fHeaderChunk.flush() || wasCanceled;
            wasCanceled = this.performUninterruptableWrite(() -> this.fFile.getChannel().truncate(4096L)) || wasCanceled;
            this.bytesWritten += 4096L;
        }
        catch (IOException e) {
            Package.log(e);
        }
        this.freed = 0L;
        this.malloced = 0L;
        long setasideChunks = Long.getLong("org.aspectj.org.eclipse.jdt.core.parser.nd.chunks", 0L);
        if (setasideChunks != 0L) {
            this.setVersion(this.getVersion());
            this.createNewChunks((int)setasideChunks);
            wasCanceled = this.flush() || wasCanceled;
        }
        this.memoryUsage.refresh();
        this.fHeaderChunk.makeDirty();
        return wasCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChunksFromCache() {
        int scanIndex = 1;
        while (scanIndex < this.fChunksUsed) {
            ChunkCache chunkCache = this.fCache;
            synchronized (chunkCache) {
                int countMax = Math.min(256, this.fChunksUsed - scanIndex);
                int count = 0;
                while (count < countMax) {
                    Chunk chunk;
                    if ((chunk = this.fChunks[scanIndex++]) != null) {
                        this.fCache.remove(chunk);
                        if (DEBUG_PAGE_CACHE) {
                            System.out.println("CHUNK " + chunk.fSequenceNumber + ": removing from vector in removeChunksFromCache - instance " + System.identityHashCode(chunk));
                        }
                        this.fChunks[chunk.fSequenceNumber] = null;
                    }
                    ++count;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk getChunk(long offset) throws IndexException {
        boolean cacheMiss;
        Chunk chunk;
        assert (offset >= 0L);
        this.assertLocked();
        if (offset < 4096L) {
            this.fMostRecentlyFetchedChunk = this.fHeaderChunk;
            return this.fHeaderChunk;
        }
        long long_index = offset / 4096L;
        assert (long_index < Integer.MAX_VALUE);
        int index = (int)long_index;
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            assert (this.fLocked);
            if (index < 0 || index >= this.fChunks.length) {
                this.databaseCorruptionDetected();
            }
            chunk = this.fChunks[index];
        }
        long readStartMs = 0L;
        long readEndMs = 0L;
        boolean bl = cacheMiss = chunk == null;
        if (cacheMiss) {
            readStartMs = System.currentTimeMillis();
            chunk = new Chunk(this, index);
            chunk.read();
            readEndMs = System.currentTimeMillis();
        }
        ChunkCache chunkCache2 = this.fCache;
        synchronized (chunkCache2) {
            if (cacheMiss) {
                ++this.cacheMisses;
                this.totalReadTimeMs += readEndMs - readStartMs;
            } else {
                ++this.cacheHits;
            }
            Chunk newChunk = this.fChunks[index];
            if (newChunk != chunk && newChunk != null) {
                if (DEBUG_PAGE_CACHE) {
                    System.out.println("CHUNK " + chunk.fSequenceNumber + ": already fetched by another thread - instance " + System.identityHashCode(chunk));
                }
                chunk = newChunk;
            } else if (cacheMiss) {
                if (DEBUG_PAGE_CACHE) {
                    System.out.println("CHUNK " + chunk.fSequenceNumber + ": inserted into vector - instance " + System.identityHashCode(chunk));
                }
                this.fChunks[index] = chunk;
            }
            this.fCache.add(chunk);
            this.fMostRecentlyFetchedChunk = chunk;
        }
        return chunk;
    }

    public void assertLocked() {
        if (!this.fLocked) {
            throw new IllegalStateException("Database not locked!");
        }
    }

    private void databaseCorruptionDetected() throws IndexException {
        String msg = "Corrupted database: " + this.fLocation.getName();
        throw new IndexException((IStatus)new DBStatus(msg));
    }

    public void memcpy(long dest, long source, int numBytes) {
        assert (numBytes >= 0);
        long endAddress = source + (long)numBytes;
        assert (endAddress <= (long)this.fChunksUsed * 4096L);
        int count = 0;
        while (count < numBytes) {
            this.putByte(dest + (long)count, this.getByte(source + (long)count));
            ++count;
        }
    }

    public long malloc(long datasize, short poolId) throws IndexException {
        boolean performedValidation;
        long result;
        int usedSize;
        assert (this.fExclusiveLock);
        assert (datasize >= 0L);
        assert (datasize <= MAX_MALLOC_SIZE);
        this.log.start(this.mallocTag);
        try {
            if (datasize >= (long)MAX_SINGLE_BLOCK_MALLOC_SIZE) {
                int newChunkNum = this.createLargeBlock(datasize);
                usedSize = Math.abs(this.getBlockHeaderForChunkNum(newChunkNum)) * 4096;
                result = (long)newChunkNum * 4096L + (long)LargeBlock.HEADER_SIZE;
                this.clearRange(result, usedSize - LargeBlock.HEADER_SIZE - LargeBlock.FOOTER_SIZE);
                result += 2L;
            } else {
                Chunk chunk;
                long freeBlock = 0L;
                int needDeltas = Database.divideRoundingUp(datasize + 2L, 8L);
                if (needDeltas < 2) {
                    needDeltas = 2;
                }
                int useDeltas = needDeltas;
                while (useDeltas <= MAX_BLOCK_DELTAS) {
                    freeBlock = this.getFirstBlock(useDeltas * 8);
                    if (freeBlock != 0L) break;
                    ++useDeltas;
                }
                if (freeBlock == 0L) {
                    freeBlock = (long)this.createLargeBlock(datasize) * 4096L + (long)LargeBlock.HEADER_SIZE;
                    useDeltas = MAX_BLOCK_DELTAS;
                    chunk = this.getChunk(freeBlock);
                } else {
                    chunk = this.getChunk(freeBlock);
                    chunk.makeDirty();
                    short blockReportedSize = chunk.getShort(freeBlock);
                    if (blockReportedSize != useDeltas * 8) {
                        throw this.describeProblem().addProblemAddress("block size", freeBlock, 2).build("Heap corruption detected in free space list. Block " + freeBlock + " reports a size of " + blockReportedSize + " but was in the list for blocks of size " + useDeltas * 8);
                    }
                    this.removeBlock(chunk, useDeltas * 8, freeBlock);
                }
                int unusedDeltas = useDeltas - needDeltas;
                if (unusedDeltas >= 2) {
                    this.addBlock(chunk, unusedDeltas * 8, freeBlock + (long)(needDeltas * 8));
                    useDeltas = needDeltas;
                }
                usedSize = useDeltas * 8;
                chunk.putShort(freeBlock, (short)(-usedSize));
                chunk.clear(freeBlock + 2L, usedSize - 2);
                result = freeBlock + 2L;
            }
        }
        finally {
            this.log.end(this.mallocTag);
        }
        this.log.recordMalloc(result, usedSize - 2);
        this.malloced += (long)usedSize;
        this.memoryUsage.recordMalloc(poolId, usedSize);
        if (DEBUG_FREE_SPACE && (performedValidation = this.periodicValidateFreeSpace())) {
            this.verifyNotInFreeSpaceList(result);
        }
        return result;
    }

    public void clearRange(long startAddress, long bytesToClear) {
        Chunk nextBlock;
        if (bytesToClear == 0L) {
            return;
        }
        long endAddress = startAddress + bytesToClear;
        assert (endAddress <= (long)this.fChunksUsed * 4096L);
        int blockNumber = (int)(startAddress / 4096L);
        int firstBlockBytesToClear = (int)Math.min((long)(blockNumber + 1) * 4096L - startAddress, bytesToClear);
        Chunk firstBlock = this.getChunk(startAddress);
        firstBlock.clear(startAddress, firstBlockBytesToClear);
        startAddress += (long)firstBlockBytesToClear;
        bytesToClear -= (long)firstBlockBytesToClear;
        while (bytesToClear > 4096L) {
            nextBlock = this.getChunk(startAddress);
            nextBlock.clear(startAddress, 4096);
            startAddress += 4096L;
            bytesToClear -= 4096L;
        }
        if (bytesToClear > 0L) {
            nextBlock = this.getChunk(startAddress);
            nextBlock.clear(startAddress, (int)bytesToClear);
        }
    }

    private int createLargeBlock(long datasize) {
        int resultChunkNum;
        int numChunks;
        int neededChunks = Database.getChunksNeededForBytes(datasize);
        int freeBlockChunkNum = this.getFreeBlockFromTrie(neededChunks);
        if (freeBlockChunkNum == 0) {
            int lastChunkNum = this.fChunksUsed;
            numChunks = neededChunks;
            int lastBlockSize = this.getBlockFooterForChunkBefore(lastChunkNum);
            if (lastBlockSize > 0) {
                int startChunkNum = this.getFirstChunkOfBlockBefore(lastChunkNum);
                this.unlinkFreeBlock(startChunkNum);
                this.createNewChunks(neededChunks - lastBlockSize);
                freeBlockChunkNum = startChunkNum;
            } else {
                freeBlockChunkNum = this.createNewChunks(numChunks);
            }
        } else {
            numChunks = this.getBlockHeaderForChunkNum(freeBlockChunkNum);
            if (numChunks < neededChunks) {
                throw this.describeProblem().addProblemAddress("chunk header", (long)freeBlockChunkNum * 4096L, 4).build("A block in the free space trie was too small or wasn't actually free. Reported size = " + numChunks + " chunks, requested size = " + neededChunks + " chunks");
            }
            int footer = this.getBlockFooterForChunkBefore(freeBlockChunkNum + numChunks);
            if (footer != numChunks) {
                throw this.describeProblem().addProblemAddress("chunk header", (long)freeBlockChunkNum * 4096L, 4).addProblemAddress("chunk footer", (long)(freeBlockChunkNum + numChunks) * 4096L - 4L, 4).build("The header and footer didn't match for a block in the free space trie. Expected " + numChunks + " but found " + footer);
            }
            this.unlinkFreeBlock(freeBlockChunkNum);
        }
        if (numChunks > neededChunks) {
            int nextBlockChunkNum = freeBlockChunkNum + numChunks;
            int nextBlockSize = Math.abs(this.getBlockHeaderForChunkNum(nextBlockChunkNum));
            int prevBlockSize = Math.abs(this.getBlockFooterForChunkBefore(freeBlockChunkNum));
            int unusedChunks = numChunks - neededChunks;
            if (nextBlockSize >= prevBlockSize) {
                resultChunkNum = freeBlockChunkNum;
                this.linkFreeBlockToTrie(freeBlockChunkNum + neededChunks, unusedChunks);
            } else {
                resultChunkNum = freeBlockChunkNum + unusedChunks;
                this.linkFreeBlockToTrie(freeBlockChunkNum, unusedChunks);
            }
        } else {
            resultChunkNum = freeBlockChunkNum;
        }
        this.setBlockHeader(resultChunkNum, -neededChunks);
        return resultChunkNum;
    }

    private void unlinkFreeBlock(int freeBlockChunkNum) {
        int firstDifference;
        long locationOfChildPointer;
        int childChunkNum;
        int currentSize;
        int difference;
        long freeBlockAddress = (long)freeBlockChunkNum * 4096L;
        int anotherBlockOfSameSize = 0;
        int nextBlockChunkNum = this.getInt(freeBlockAddress + (long)LargeBlock.NEXT_BLOCK_OFFSET);
        int prevBlockChunkNum = this.getInt(freeBlockAddress + (long)LargeBlock.PREV_BLOCK_OFFSET);
        if (nextBlockChunkNum != 0) {
            anotherBlockOfSameSize = nextBlockChunkNum;
            this.putInt((long)nextBlockChunkNum * 4096L + (long)LargeBlock.PREV_BLOCK_OFFSET, prevBlockChunkNum);
        }
        if (prevBlockChunkNum != 0) {
            anotherBlockOfSameSize = prevBlockChunkNum;
            this.putInt((long)prevBlockChunkNum * 4096L + (long)LargeBlock.NEXT_BLOCK_OFFSET, nextBlockChunkNum);
        }
        boolean wasInTrie = false;
        long root = this.getInt(2048L);
        if (root == (long)freeBlockChunkNum) {
            this.putInt(2048L, 0);
            wasInTrie = true;
        }
        int freeBlockSize = this.getBlockHeaderForChunkNum(freeBlockChunkNum);
        int parentChunkNum = this.getInt(freeBlockAddress + (long)LargeBlock.PARENT_OFFSET);
        if (parentChunkNum != 0 && (difference = (currentSize = this.getBlockHeaderForChunkNum(parentChunkNum)) ^ freeBlockSize) != 0 && (childChunkNum = this.getInt(locationOfChildPointer = (long)parentChunkNum * 4096L + (long)LargeBlock.CHILD_TABLE_OFFSET + (long)((firstDifference = 32 - Integer.numberOfLeadingZeros(difference) - 1) * 4))) == freeBlockChunkNum) {
            wasInTrie = true;
            this.putInt(locationOfChildPointer, 0);
        }
        if (wasInTrie && anotherBlockOfSameSize != 0) {
            this.insertChild(parentChunkNum, anotherBlockOfSameSize);
        }
        int currentParent = parentChunkNum;
        int childIdx = 0;
        while (childIdx < 32) {
            long childAddress = freeBlockAddress + (long)LargeBlock.CHILD_TABLE_OFFSET + (long)(childIdx * 4);
            int nextChildChunkNum = this.getInt(childAddress);
            if (nextChildChunkNum != 0) {
                if (!wasInTrie) {
                    throw this.describeProblem().addProblemAddress("non-null child pointer", childAddress, 4).build("All child pointers should be null for a free chunk that is in the sibling list but not part of the trie. Problematic chunk number: " + freeBlockChunkNum);
                }
                this.insertChild(currentParent, nextChildChunkNum);
                if (currentParent == parentChunkNum) {
                    currentParent = nextChildChunkNum;
                }
            }
            ++childIdx;
        }
    }

    private int getFreeBlockFromTrie(int numChunks) {
        int currentChunkNum = this.getInt(2048L);
        int resultChunkNum = this.getSmallestChildNoSmallerThan(currentChunkNum, numChunks);
        if (resultChunkNum == 0) {
            return 0;
        }
        int nextResultChunkNum = this.getInt((long)resultChunkNum * 4096L + (long)LargeBlock.NEXT_BLOCK_OFFSET);
        if (nextResultChunkNum != 0) {
            return nextResultChunkNum;
        }
        return resultChunkNum;
    }

    private int getSmallestChildNoSmallerThan(int trieNodeChunkNum, int numChunks) {
        if (trieNodeChunkNum == 0) {
            return 0;
        }
        int currentSize = this.getBlockHeaderForChunkNum(trieNodeChunkNum);
        assert (currentSize >= 0);
        int difference = currentSize ^ numChunks;
        if (difference == 0) {
            return trieNodeChunkNum;
        }
        int bitMask = Integer.highestOneBit(difference);
        int firstDifference = 32 - Integer.numberOfLeadingZeros(bitMask) - 1;
        boolean lookingForSmallerChild = currentSize > numChunks;
        int testPosition = firstDifference;
        while (testPosition < 32) {
            int nextChildChunkNum;
            int childResultChunkNum;
            if ((currentSize & bitMask) != 0 == lookingForSmallerChild && (childResultChunkNum = this.getSmallestChildNoSmallerThan(nextChildChunkNum = this.getInt((long)trieNodeChunkNum * 4096L + (long)LargeBlock.CHILD_TABLE_OFFSET + (long)(testPosition * 4)), numChunks)) != 0) {
                return childResultChunkNum;
            }
            bitMask <<= 1;
            ++testPosition;
        }
        if (lookingForSmallerChild) {
            return trieNodeChunkNum;
        }
        return 0;
    }

    private void linkFreeBlockToTrie(int freeBlockChunkNum, int numChunks) {
        this.setBlockHeader(freeBlockChunkNum, numChunks);
        long freeBlockAddress = (long)freeBlockChunkNum * 4096L;
        Chunk chunk = this.getChunk(freeBlockAddress);
        chunk.clear(freeBlockAddress + (long)LargeBlock.HEADER_SIZE, LargeBlock.UNALLOCATED_HEADER_SIZE - LargeBlock.HEADER_SIZE);
        this.insertChild(this.getInt(2048L), freeBlockChunkNum);
    }

    public void validateFreeSpace() {
        this.validateFreeSpaceLists();
        this.validateFreeSpaceTries();
    }

    private void validateFreeSpaceLists() {
        int useDeltas = 2;
        while (useDeltas <= MAX_BLOCK_DELTAS) {
            this.validateFreeBlocksFor(useDeltas);
            ++useDeltas;
        }
    }

    private void verifyNotInFreeSpaceList(long result) {
        int useDeltas = 2;
        while (useDeltas <= MAX_BLOCK_DELTAS) {
            int correctSize = useDeltas * 8;
            long block = this.getFirstBlock(correctSize);
            long addressOfPrevBlockPointer = this.getAddressOfFirstBlockPointer(correctSize);
            while (block != 0L) {
                long followingBlock;
                if (block == result) {
                    throw this.describeProblem().addProblemAddress("incoming pointer", addressOfPrevBlockPointer, 4).build("Block " + result + " was found in the free space list, even though it wasn't free");
                }
                addressOfPrevBlockPointer = block + 6L;
                block = followingBlock = this.getFreeRecPtr(addressOfPrevBlockPointer);
            }
            ++useDeltas;
        }
        int currentChunkNum = this.getInt(2048L);
        if (currentChunkNum == 0) {
            return;
        }
        int targetChunkNum = (int)(result / 4096L);
        if (currentChunkNum == targetChunkNum) {
            throw this.describeProblem().build("Block " + result + " was not supposed to be in the free space list, but was linked as the root of the list");
        }
        this.verifyNotInLargeBlockFreeSpaceTrie(targetChunkNum, currentChunkNum, 0);
    }

    private void verifyNotInLargeBlockFreeSpaceTrie(int targetChunkNum, int chunkNum, int parent) {
        long chunkStart = (long)chunkNum * 4096L;
        int testPosition = 0;
        while (testPosition < 32) {
            long chunkAddress = chunkStart + (long)LargeBlock.CHILD_TABLE_OFFSET + (long)(testPosition * 4);
            int nextChildChunkNum = this.getInt(chunkAddress);
            if (nextChildChunkNum != 0) {
                if (nextChildChunkNum == targetChunkNum) {
                    throw this.describeProblem().addProblemAddress("trie child address", chunkAddress, 4).build("Chunk number " + nextChildChunkNum + " was found in the free space trie even though it was in use");
                }
                this.verifyNotInLargeBlockFreeSpaceTrie(targetChunkNum, nextChildChunkNum, chunkNum);
            }
            ++testPosition;
        }
    }

    private void validateFreeBlocksFor(int numberOfDeltas) {
        int correctSize = numberOfDeltas * 8;
        long lastBlock = 0L;
        long block = this.getFirstBlock(correctSize);
        long addressOfPrevBlockPointer = this.getAddressOfFirstBlockPointer(correctSize);
        while (block != 0L) {
            long measuredLastBlock = this.getFreeRecPtr(block + 2L);
            short blockReportedSize = this.getShort(block);
            long followingBlock = this.getFreeRecPtr(block + 6L);
            if (measuredLastBlock != lastBlock) {
                throw this.describeProblem().addProblemAddress("last block", block + 2L, 4).addProblemAddress("incoming pointer", addressOfPrevBlockPointer, 4).build("The free space block (" + block + ") of size " + correctSize + " had an incorrect prev pointer to " + measuredLastBlock + ", but it should have been pointing to " + lastBlock);
            }
            if (blockReportedSize != correctSize) {
                throw this.describeProblem().addProblemAddress("block size", block, 2).addProblemAddress("incoming pointer", addressOfPrevBlockPointer, 4).build("A block (" + block + ") of size " + measuredLastBlock + " was in the free space list for blocks of size " + correctSize);
            }
            addressOfPrevBlockPointer = block + 6L;
            lastBlock = block;
            block = followingBlock;
        }
    }

    private void validateFreeSpaceTries() {
        int currentChunkNum = this.getInt(2048L);
        if (currentChunkNum == 0) {
            return;
        }
        HashSet<Integer> visited = new HashSet<Integer>();
        this.validateFreeSpaceNode(visited, currentChunkNum, 0);
    }

    private void validateFreeSpaceNode(Set<Integer> visited, int chunkNum, int parent) {
        if (visited.contains(chunkNum)) {
            throw this.describeProblem().build("Chunk " + chunkNum + "(parent = " + parent + " appeared twice in the free space tree");
        }
        long chunkStart = (long)chunkNum * 4096L;
        int parentChunk = this.getInt(chunkStart + (long)LargeBlock.PARENT_OFFSET);
        if (parentChunk != parent) {
            throw this.describeProblem().addProblemAddress("parent pointer", chunkStart + (long)LargeBlock.PARENT_OFFSET, 4).build("Chunk " + chunkNum + " has the wrong parent. Expected " + parent + " but found  " + parentChunk);
        }
        visited.add(chunkNum);
        int numChunks = this.getBlockHeaderForChunkNum(chunkNum);
        int testPosition = 0;
        while (testPosition < 32) {
            long nextChildChunkNumAddress = chunkStart + (long)LargeBlock.CHILD_TABLE_OFFSET + (long)(testPosition * 4);
            int nextChildChunkNum = this.getInt(nextChildChunkNumAddress);
            if (nextChildChunkNum != 0) {
                int nextSize = this.getBlockHeaderForChunkNum(nextChildChunkNum);
                int sizeDifference = nextSize ^ numChunks;
                int firstDifference = 32 - Integer.numberOfLeadingZeros(Integer.highestOneBit(sizeDifference)) - 1;
                if (firstDifference != testPosition) {
                    IndexExceptionBuilder descriptor = this.describeProblem();
                    this.attachBlockHeaderForChunkNum(descriptor, chunkNum);
                    this.attachBlockHeaderForChunkNum(descriptor, nextChildChunkNum);
                    throw descriptor.build("Chunk " + nextChildChunkNum + " contained an incorrect size of " + nextSize + ". It was at position " + testPosition + " in parent " + chunkNum + " which had size " + numChunks);
                }
                try {
                    this.validateFreeSpaceNode(visited, nextChildChunkNum, chunkNum);
                }
                catch (IndexException e) {
                    this.describeProblem().addProblemAddress("child pointer from parent " + chunkNum, nextChildChunkNumAddress, 4).attachTo(e);
                    throw e;
                }
            }
            ++testPosition;
        }
    }

    private void insertChild(int parentChunkNum, int newChildChunkNum) {
        if (parentChunkNum == 0) {
            this.putInt((long)newChildChunkNum * 4096L + (long)LargeBlock.PARENT_OFFSET, parentChunkNum);
            this.putInt(2048L, newChildChunkNum);
            return;
        }
        int numChunks = this.getBlockHeaderForChunkNum(newChildChunkNum);
        while (true) {
            int currentSize;
            int difference;
            if ((difference = (currentSize = this.getBlockHeaderForChunkNum(parentChunkNum)) ^ numChunks) == 0) {
                this.insertFreeBlockAfter(parentChunkNum, newChildChunkNum);
                return;
            }
            int firstDifference = 32 - Integer.numberOfLeadingZeros(difference) - 1;
            long locationOfChildPointer = (long)parentChunkNum * 4096L + (long)LargeBlock.CHILD_TABLE_OFFSET + (long)(firstDifference * 4);
            int childChunkNum = this.getInt(locationOfChildPointer);
            if (childChunkNum == 0) {
                this.putInt(locationOfChildPointer, newChildChunkNum);
                this.putInt((long)newChildChunkNum * 4096L + (long)LargeBlock.PARENT_OFFSET, parentChunkNum);
                return;
            }
            parentChunkNum = childChunkNum;
        }
    }

    private void insertFreeBlockAfter(int prevChunkNum, int newChunkNum) {
        long prevChunkAddress = (long)prevChunkNum * 4096L;
        int nextChunkNum = this.getInt(prevChunkAddress + (long)LargeBlock.NEXT_BLOCK_OFFSET);
        long nextChunkAddress = (long)nextChunkNum * 4096L;
        long newLockAddress = (long)newChunkNum * 4096L;
        this.putInt(prevChunkAddress + (long)LargeBlock.NEXT_BLOCK_OFFSET, newChunkNum);
        if (nextChunkNum != 0) {
            this.putInt(nextChunkAddress + (long)LargeBlock.PREV_BLOCK_OFFSET, newChunkNum);
        }
        this.putInt(newLockAddress + (long)LargeBlock.PREV_BLOCK_OFFSET, prevChunkNum);
        this.putInt(newLockAddress + (long)LargeBlock.NEXT_BLOCK_OFFSET, nextChunkNum);
    }

    private int getFirstChunkOfBlockBefore(int chunkNum) {
        int blockChunks = Math.abs(this.getBlockFooterForChunkBefore(chunkNum));
        return chunkNum - blockChunks;
    }

    private void setBlockHeader(int firstChunkNum, int headerContent) {
        assert (headerContent != 0);
        assert (firstChunkNum < this.fChunksUsed);
        int numBlocks = Math.abs(headerContent);
        long firstChunkAddress = (long)firstChunkNum * 4096L;
        this.putInt(firstChunkAddress, headerContent);
        this.putInt(firstChunkAddress + (long)numBlocks * 4096L - (long)LargeBlock.FOOTER_SIZE, headerContent);
    }

    private int getBlockHeaderForChunkNum(int firstChunkNum) {
        if (firstChunkNum >= this.fChunksUsed) {
            return 0;
        }
        return this.getInt((long)firstChunkNum * 4096L);
    }

    private void attachBlockHeaderForChunkNum(IndexExceptionBuilder builder, int firstChunkNum) {
        if (firstChunkNum >= this.fChunksUsed) {
            return;
        }
        builder.addProblemAddress("block header for chunk " + firstChunkNum, (long)firstChunkNum * 4096L, 4);
    }

    private int getBlockFooterForChunkBefore(int chunkNum) {
        if (chunkNum < 2) {
            return 0;
        }
        return this.getInt((long)chunkNum * 4096L - (long)LargeBlock.FOOTER_SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createNewChunks(int numChunks) throws IndexException {
        assert (this.fExclusiveLock);
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            int firstChunkIndex = this.fChunksUsed;
            int lastChunkIndex = firstChunkIndex + numChunks - 1;
            Chunk lastChunk = new Chunk(this, lastChunkIndex);
            if (lastChunkIndex >= this.fChunks.length) {
                int increment = Math.max(1024, this.fChunks.length / 20);
                int newNumChunks = Math.max(lastChunkIndex + 1, this.fChunks.length + increment);
                Chunk[] newChunks = new Chunk[newNumChunks];
                System.arraycopy(this.fChunks, 0, newChunks, 0, this.fChunks.length);
                this.fChunks = newChunks;
            }
            this.fChunksUsed = lastChunkIndex + 1;
            if (DEBUG_PAGE_CACHE) {
                System.out.println("CHUNK " + lastChunk.fSequenceNumber + ": inserted into vector - instance " + System.identityHashCode(lastChunk));
            }
            this.fChunks[lastChunkIndex] = lastChunk;
            this.fMostRecentlyFetchedChunk = lastChunk;
            lastChunk.makeDirty();
            this.fCache.add(lastChunk);
            long result = (long)firstChunkIndex * 4096L;
            long endAddress = result + (long)numChunks * 4096L;
            if (endAddress > 0x800000000L) {
                Object[] bindings = new Object[]{this.getLocation().getAbsolutePath(), 0x800000000L};
                throw new IndexException((IStatus)new Status(4, Package.PLUGIN_ID, 4, NLS.bind((String)("Database too large! Address = " + endAddress + ", max size = " + 0x800000000L), (Object[])bindings), null));
            }
            return firstChunkIndex;
        }
    }

    private long getAddressOfFirstBlockPointer(int blockSize) {
        return 4 + (blockSize / 8 - 2) * 4;
    }

    private long getFirstBlock(int blockSize) throws IndexException {
        assert (this.fLocked);
        return this.fHeaderChunk.getFreeRecPtr(this.getAddressOfFirstBlockPointer(blockSize));
    }

    private void setFirstBlock(int blockSize, long block) throws IndexException {
        assert (this.fExclusiveLock);
        this.fHeaderChunk.putFreeRecPtr(this.getAddressOfFirstBlockPointer(blockSize), block);
    }

    private void removeBlock(Chunk chunk, int blocksize, long block) throws IndexException {
        assert (this.fExclusiveLock);
        long prevblock = chunk.getFreeRecPtr(block + 2L);
        long nextblock = chunk.getFreeRecPtr(block + 6L);
        if (prevblock != 0L) {
            this.putFreeRecPtr(prevblock + 6L, nextblock);
        } else {
            this.setFirstBlock(blocksize, nextblock);
        }
        if (nextblock != 0L) {
            this.putFreeRecPtr(nextblock + 2L, prevblock);
        }
    }

    private void addBlock(Chunk chunk, int blocksize, long block) throws IndexException {
        assert (this.fExclusiveLock);
        chunk.putShort(block, (short)blocksize);
        long prevfirst = this.getFirstBlock(blocksize);
        chunk.putFreeRecPtr(block + 2L, 0L);
        chunk.putFreeRecPtr(block + 6L, prevfirst);
        if (prevfirst != 0L) {
            this.putFreeRecPtr(prevfirst + 2L, block);
        }
        this.setFirstBlock(blocksize, block);
    }

    public void free(long address, short poolId) throws IndexException {
        this.getLog().start(this.freeTag);
        try {
            assert (this.fExclusiveLock);
            if (address == 0L) {
                return;
            }
            long block = address - 2L;
            Chunk chunk = this.getChunk(block);
            long blockSize = -chunk.getShort(block);
            if (blockSize == 0L) {
                int offsetIntoChunk = (int)(address % 4096L);
                assert (offsetIntoChunk == LargeBlock.HEADER_SIZE + 2);
                int chunkNum = (int)(address / 4096L);
                int numChunks = -this.getBlockHeaderForChunkNum(chunkNum);
                if (numChunks < 0) {
                    IndexExceptionBuilder builder = this.describeProblem();
                    if (chunkNum < this.fChunksUsed) {
                        builder.addProblemAddress("block header", (long)chunkNum * 4096L, 4);
                    }
                    throw builder.build("Already freed large block " + address);
                }
                blockSize = (long)numChunks * 4096L;
                this.log.recordFree(address, (int)(blockSize - 2L));
                this.freeLargeChunk(chunkNum, numChunks);
            } else {
                if (blockSize < 0L) {
                    throw this.describeProblem().addProblemAddress("block size", block, 2).build("Already freed record " + address);
                }
                this.log.recordFree(address, (int)(blockSize - 2L));
                int offset = Chunk.recPtrToIndex(address);
                if ((long)offset + blockSize > 4096L) {
                    throw this.describeProblem().addProblemAddress("block size", block, 2).build("Attempting to free chunk of impossible size. The block at address " + address + " in chunk " + chunk.fSequenceNumber + " offset " + offset + " can't be as large as " + blockSize + " bytes since that would make it extend beyond the end of the chunk");
                }
                this.addBlock(chunk, (int)blockSize, block);
            }
            if (DEBUG_FREE_SPACE) {
                this.periodicValidateFreeSpace();
            }
            this.freed += blockSize;
            this.memoryUsage.recordFree(poolId, blockSize);
        }
        finally {
            this.getLog().end(this.freeTag);
        }
    }

    private boolean periodicValidateFreeSpace() {
        ++this.validateCounter;
        if (this.validateCounter > this.nextValidation) {
            this.validateFreeSpace();
            this.nextValidation = this.validateCounter * 2L;
            return true;
        }
        return false;
    }

    private void freeLargeChunk(int chunkNum, int numChunks) {
        assert (chunkNum > 0);
        assert (numChunks > 0);
        int prevBlockHeader = this.getBlockFooterForChunkBefore(chunkNum);
        int nextBlockChunkNum = chunkNum + numChunks;
        int nextBlockHeader = this.getBlockHeaderForChunkNum(nextBlockChunkNum);
        if (prevBlockHeader > 0) {
            int prevBlockChunkNum = this.getFirstChunkOfBlockBefore(chunkNum);
            this.unlinkFreeBlock(prevBlockChunkNum);
            chunkNum = prevBlockChunkNum;
            numChunks += prevBlockHeader;
        }
        if (nextBlockHeader > 0) {
            this.unlinkFreeBlock(nextBlockChunkNum);
            numChunks += nextBlockHeader;
        }
        this.linkFreeBlockToTrie(chunkNum, numChunks);
    }

    public void putByte(long offset, byte value) throws IndexException {
        this.getChunk(offset).putByte(offset, value);
    }

    public byte getByte(long offset) throws IndexException {
        return this.getChunk(offset).getByte(offset);
    }

    public void putInt(long offset, int value) throws IndexException {
        this.getChunk(offset).putInt(offset, value);
    }

    public int getInt(long offset) throws IndexException {
        return this.getChunk(offset).getInt(offset);
    }

    public void putRecPtr(long offset, long value) throws IndexException {
        this.getChunk(offset).putRecPtr(offset, value);
    }

    public long getRecPtr(long offset) throws IndexException {
        return this.getChunk(offset).getRecPtr(offset);
    }

    private void putFreeRecPtr(long offset, long value) throws IndexException {
        this.getChunk(offset).putFreeRecPtr(offset, value);
    }

    private long getFreeRecPtr(long offset) throws IndexException {
        return this.getChunk(offset).getFreeRecPtr(offset);
    }

    public void put3ByteUnsignedInt(long offset, int value) throws IndexException {
        this.getChunk(offset).put3ByteUnsignedInt(offset, value);
    }

    public int get3ByteUnsignedInt(long offset) throws IndexException {
        return this.getChunk(offset).get3ByteUnsignedInt(offset);
    }

    public void putShort(long offset, short value) throws IndexException {
        this.getChunk(offset).putShort(offset, value);
    }

    public short getShort(long offset) throws IndexException {
        return this.getChunk(offset).getShort(offset);
    }

    public void putLong(long offset, long value) throws IndexException {
        this.getChunk(offset).putLong(offset, value);
    }

    public void putDouble(long offset, double value) throws IndexException {
        this.getChunk(offset).putDouble(offset, value);
    }

    public void putFloat(long offset, float value) throws IndexException {
        this.getChunk(offset).putFloat(offset, value);
    }

    public long getLong(long offset) throws IndexException {
        return this.getChunk(offset).getLong(offset);
    }

    public double getDouble(long offset) throws IndexException {
        return this.getChunk(offset).getDouble(offset);
    }

    public float getFloat(long offset) throws IndexException {
        return this.getChunk(offset).getFloat(offset);
    }

    public void putChar(long offset, char value) throws IndexException {
        this.getChunk(offset).putChar(offset, value);
    }

    public char getChar(long offset) throws IndexException {
        return this.getChunk(offset).getChar(offset);
    }

    public void clearBytes(long offset, int byteCount) throws IndexException {
        this.getChunk(offset).clear(offset, byteCount);
    }

    public void putBytes(long offset, byte[] data, int len) throws IndexException {
        this.getChunk(offset).put(offset, data, len);
    }

    public void putBytes(long offset, byte[] data, int dataPos, int len) throws IndexException {
        this.getChunk(offset).put(offset, data, dataPos, len);
    }

    public void getBytes(long offset, byte[] data) throws IndexException {
        this.getChunk(offset).get(offset, data);
    }

    public void getBytes(long offset, byte[] data, int dataPos, int len) throws IndexException {
        this.getChunk(offset).get(offset, data, dataPos, len);
    }

    public IString newString(String string) throws IndexException {
        return this.newString(string.toCharArray());
    }

    public IString newString(char[] chars) throws IndexException {
        int len = chars.length;
        boolean useBytes = this.useBytes(chars);
        int bytelen = useBytes ? len : 2 * len;
        if (bytelen > ShortString.MAX_BYTE_LENGTH) {
            return new LongString(this, chars, useBytes);
        }
        return new ShortString(this, chars, useBytes);
    }

    private boolean useBytes(char[] chars) {
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if ((c & 0xFF00) != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public IString getString(long offset) throws IndexException {
        int bytelen;
        int l = this.getInt(offset);
        int n = bytelen = l < 0 ? -l : 2 * l;
        if (bytelen > ShortString.MAX_BYTE_LENGTH) {
            return new LongString(this, offset);
        }
        return new ShortString(this, offset);
    }

    public long getDatabaseSize() {
        return (long)this.fChunksUsed * 4096L;
    }

    public long getBytesFreed() {
        return this.freed;
    }

    public long getBytesAllocated() {
        return this.malloced;
    }

    public void reportFreeBlocks() throws IndexException {
        System.out.println("Allocated size: " + Database.formatByteString(this.getDatabaseSize()));
        System.out.println("malloc'ed: " + Database.formatByteString(this.malloced));
        System.out.println("free'd: " + Database.formatByteString(this.freed));
        System.out.println("wasted: " + Database.formatByteString(this.getDatabaseSize() - (this.malloced - this.freed)));
        System.out.println("Free blocks");
        int bs = 16;
        while (bs <= 4096) {
            int count = 0;
            long block = this.getFirstBlock(bs);
            while (block != 0L) {
                ++count;
                block = this.getFreeRecPtr(block + 6L);
            }
            if (count != 0) {
                System.out.println("Block size: " + bs + "=" + count);
            }
            bs += 8;
        }
    }

    public void close() throws IndexException {
        assert (this.fExclusiveLock);
        this.flush();
        this.removeChunksFromCache();
        this.log.clear();
        this.fHeaderChunk.clear(0L, 4096);
        this.memoryUsage.refresh();
        this.fHeaderChunk.fDirty = false;
        this.dirtyChunkSet.clear();
        this.fChunks = new Chunk[1];
        this.fChunksUsed = this.fChunks.length;
        try {
            this.fFile.close();
        }
        catch (IOException e) {
            throw new IndexException((IStatus)new DBStatus(e));
        }
    }

    public File getLocation() {
        return this.fLocation;
    }

    void checkIfChunkReleased(Chunk chunk) {
        if (!chunk.fDirty && chunk.fCacheIndex < 0) {
            if (DEBUG_PAGE_CACHE) {
                System.out.println("CHUNK " + chunk.fSequenceNumber + ": removing from vector in releaseChunk - instance " + System.identityHashCode(chunk));
            }
            this.fChunks[chunk.fSequenceNumber] = null;
        }
    }

    void chunkDirtied(Chunk chunk) {
        if (chunk.fSequenceNumber < 1) {
            return;
        }
        this.dirtyChunkSet.add(chunk);
    }

    void chunkCleaned(Chunk chunk) {
        if (chunk.fSequenceNumber < 1) {
            return;
        }
        this.dirtyChunkSet.remove(chunk);
        this.checkIfChunkReleased(chunk);
    }

    public ChunkCache getChunkCache() {
        return this.fCache;
    }

    public void setExclusiveLock() {
        this.fExclusiveLock = true;
        this.fLocked = true;
    }

    public void setLocked(boolean val) {
        this.fLocked = val;
    }

    public void giveUpExclusiveLock() {
        this.fExclusiveLock = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush() throws IndexException {
        boolean wasInterrupted = false;
        assert (this.fLocked);
        ArrayList<Chunk> dirtyChunks = new ArrayList<Chunk>();
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            dirtyChunks.addAll(this.dirtyChunkSet);
        }
        this.sortBySequenceNumber(dirtyChunks);
        long startTime = System.currentTimeMillis();
        wasInterrupted = this.flushAndUnlockChunks(dirtyChunks, true) || wasInterrupted;
        long elapsedTime = System.currentTimeMillis() - startTime;
        this.totalFlushTime += elapsedTime;
        return wasInterrupted;
    }

    private void sortBySequenceNumber(ArrayList<Chunk> dirtyChunks) {
        dirtyChunks.sort((a, b) -> a.fSequenceNumber - b.fSequenceNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flushAndUnlockChunks(ArrayList<Chunk> dirtyChunks, boolean isComplete) throws IndexException {
        boolean haveDirtyChunks;
        boolean wasInterrupted = false;
        assert (!Thread.holdsLock(this.fCache));
        boolean bl = haveDirtyChunks = !dirtyChunks.isEmpty();
        if (haveDirtyChunks || this.fHeaderChunk.fDirty) {
            boolean bl2 = wasInterrupted = this.markFileIncomplete() || wasInterrupted;
        }
        if (haveDirtyChunks) {
            double desiredWriteBytesPerMs = 20480.0;
            ChunkCache chunkCache = this.fCache;
            synchronized (chunkCache) {
                double measuredReadBytesPerMs;
                if (this.cacheMisses > 100L && (measuredReadBytesPerMs = this.getAverageReadBytesPerMs()) > 0.0) {
                    desiredWriteBytesPerMs = measuredReadBytesPerMs / 2.0;
                }
            }
            desiredWriteBytesPerMs = Math.max(desiredWriteBytesPerMs, 20480.0);
            ChunkWriter writer = new ChunkWriter(131072, desiredWriteBytesPerMs, this::write);
            try {
                for (Chunk chunk : dirtyChunks) {
                    byte[] nextBytes;
                    if (!chunk.fDirty) continue;
                    boolean wasCanceled = false;
                    if (DEBUG_PAGE_CACHE) {
                        System.out.println("CHUNK " + chunk.fSequenceNumber + ": flushing - instance " + System.identityHashCode(chunk));
                    }
                    ChunkCache chunkCache2 = this.fCache;
                    synchronized (chunkCache2) {
                        nextBytes = chunk.getBytes();
                        chunk.fDirty = false;
                        this.chunkCleaned(chunk);
                    }
                    wasCanceled = writer.write((long)chunk.fSequenceNumber * 4096L, nextBytes);
                    boolean bl3 = wasInterrupted = wasCanceled || wasInterrupted;
                }
                writer.flush();
                ChunkCache chunkCache3 = this.fCache;
                synchronized (chunkCache3) {
                    this.pageWritesBytes += writer.getBytesWritten();
                    this.totalWriteTimeMs += writer.getTotalWriteTimeMs();
                }
            }
            catch (IOException iOException) {
                throw new IndexException((IStatus)new DBStatus(iOException));
            }
        }
        if (isComplete && (this.fHeaderChunk.fDirty || this.fIsMarkedIncomplete)) {
            this.fHeaderChunk.putInt(0L, this.fVersion);
            wasInterrupted = this.fHeaderChunk.flush() || wasInterrupted;
            this.fIsMarkedIncomplete = false;
        }
        return wasInterrupted;
    }

    private boolean markFileIncomplete() throws IndexException {
        boolean wasInterrupted = false;
        if (!this.fIsMarkedIncomplete) {
            this.fIsMarkedIncomplete = true;
            try {
                ByteBuffer buf = ByteBuffer.wrap(new byte[4]);
                wasInterrupted = this.performUninterruptableWrite(() -> {
                    int n = this.fFile.getChannel().write(buf, 0L);
                });
                this.bytesWritten += 4L;
            }
            catch (IOException e) {
                throw new IndexException((IStatus)new DBStatus(e));
            }
        }
        return wasInterrupted;
    }

    public void resetCacheCounters() {
        this.cacheHits = 0L;
        this.cacheMisses = 0L;
        this.bytesWritten = 0L;
        this.totalFlushTime = 0L;
        this.pageWritesBytes = 0L;
        this.totalWriteTimeMs = 0L;
        this.totalReadTimeMs = 0L;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public double getAverageReadBytesPerMs() {
        long reads = this.cacheMisses;
        long time = this.totalReadTimeMs;
        if (time == 0L) {
            return 0.0;
        }
        return (double)(reads * 4096L) / (double)time;
    }

    public double getAverageWriteBytesPerMs() {
        long time = this.totalWriteTimeMs;
        long writes = this.pageWritesBytes;
        return (double)writes / (double)time;
    }

    public long getBytesRead() {
        return this.cacheMisses * 4096L;
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    public long getCacheMisses() {
        return this.cacheMisses;
    }

    public long getCumulativeFlushTimeMs() {
        return this.totalFlushTime;
    }

    public long getSizeBytes() throws IOException {
        return this.fFile.length();
    }

    public int getChunkCount() {
        return this.fChunksUsed;
    }

    public static void putRecPtr(long value, byte[] buffer, int idx) {
        int denseValue = value == 0L ? 0 : Chunk.compressFreeRecPtr(value - 2L);
        Chunk.putInt(denseValue, buffer, idx);
    }

    public static long getRecPtr(byte[] buffer, int idx) {
        int value = Chunk.getInt(buffer, idx);
        long address = Chunk.expandToFreeRecPtr(value);
        return address != 0L ? address + 2L : address;
    }

    public MemoryStats getMemoryStats() {
        return this.memoryUsage;
    }

    public static long getBytesThatFitInChunks(int numChunks) {
        return 4096L * (long)numChunks - (long)LargeBlock.HEADER_SIZE - (long)LargeBlock.FOOTER_SIZE - 2L;
    }

    public static int getChunksNeededForBytes(long datasize) {
        return Database.divideRoundingUp(datasize + 2L + (long)LargeBlock.HEADER_SIZE + (long)LargeBlock.FOOTER_SIZE, 4096L);
    }

    public ChunkCache getCache() {
        return this.fCache;
    }

    public int getDirtyChunkCount() {
        return this.dirtyChunkSet.size();
    }

    public static String formatByteString(long valueInBytes) {
        double MB = 1048576.0;
        double value = valueInBytes;
        String suffix = "B";
        if (value > 1024.0) {
            suffix = "MiB";
            value /= 1048576.0;
        }
        DecimalFormat mbFormat = new DecimalFormat("#0.###");
        return String.valueOf(mbFormat.format(value)) + suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkStats getChunkStats() {
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            int count = 0;
            int dirtyChunks = 0;
            int nonDirtyChunksNotInCache = 0;
            Chunk[] chunkArray = this.fChunks;
            int n = this.fChunks.length;
            int n2 = 0;
            while (n2 < n) {
                Chunk next = chunkArray[n2];
                if (next != null) {
                    ++count;
                    if (next.fDirty) {
                        ++dirtyChunks;
                    } else if (next.fCacheIndex < 0) {
                        ++nonDirtyChunksNotInCache;
                    }
                }
                ++n2;
            }
            return new ChunkStats(this.fChunks.length, count, dirtyChunks, nonDirtyChunksNotInCache);
        }
    }

    public IndexExceptionBuilder describeProblem() {
        return new IndexExceptionBuilder(this);
    }

    public static class ChunkStats {
        public final int totalChunks;
        public final int chunksInMemory;
        public final int dirtyChunks;
        public final int nonDirtyChunksNotInCache;

        public ChunkStats(int totalChunks, int chunksInMemory, int dirtyChunks, int nonDirtyChunksNotInCache) {
            this.totalChunks = totalChunks;
            this.chunksInMemory = chunksInMemory;
            this.dirtyChunks = dirtyChunks;
            this.nonDirtyChunksNotInCache = nonDirtyChunksNotInCache;
        }

        public String toString() {
            return "Chunks: total = " + this.totalChunks + ", in memory = " + this.chunksInMemory + ", dirty = " + this.dirtyChunks + ", not in cache = " + this.nonDirtyChunksNotInCache;
        }
    }

    private static interface IORunnable {
        public void run() throws IOException;
    }
}

