/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.utils.ccsl;

import com.google.inject.Injector;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockConstraintSystem;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.ImportStatement;
import fr.inria.aoste.timesquare.ccslkernel.parser.xtext.ExtendedCCSLStandaloneSetup;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.api.MessagingSystem;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.api.MessagingSystemManager;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

public class QvtoTransformationPerformer {
    private XtextResourceSet aModelResourceSet = null;
    private XtextResourceSet outputResourceSet = null;
    protected static MessagingSystem messagingSystem = null;

    public static MessagingSystem getMessagingSystem() {
        if (messagingSystem == null) {
            MessagingSystemManager msm = new MessagingSystemManager();
            messagingSystem = msm.createBestPlatformMessagingSystem("org.eclipse.gemoc.executionframework.engine", "Modeling Workbench Console");
        }
        return messagingSystem;
    }

    private void initializeXtext() {
        ExtendedCCSLStandaloneSetup ess = new ExtendedCCSLStandaloneSetup();
        Injector injector = ess.createInjector();
        this.aModelResourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
        this.outputResourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
        this.aModelResourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
        ExtendedCCSLStandaloneSetup.doSetup();
    }

    public void run(ResourceSet resourceSet, String transformationPath, String modelPath, String outputMoCPath, String outputFeedbackPath, String outputPriorityPath) {
        QvtoTransformationPerformer.getMessagingSystem();
        URI transformationURI = URI.createURI((String)transformationPath, (boolean)true);
        URI modelURI = URI.createURI((String)modelPath, (boolean)true);
        IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(modelURI);
        this.initializeXtext();
        Resource modelResource = resourceSet.getResource(modelURI, true);
        TransformationExecutor executor = new TransformationExecutor(transformationURI);
        BasicModelExtent input = new BasicModelExtent((List)modelResource.getContents());
        BasicModelExtent outputMoC = new BasicModelExtent();
        BasicModelExtent outputFeedback = new BasicModelExtent();
        BasicModelExtent outputPriority = new BasicModelExtent();
        ExecutionContextImpl context = new ExecutionContextImpl();
        ExecutionDiagnostic diagnostic = executor.execute((ExecutionContext)context, new ModelExtent[]{input, outputMoC, outputFeedback, outputPriority});
        System.out.println(diagnostic);
        if (diagnostic.getSeverity() != 0) {
            messagingSystem.error(diagnostic.getMessage(), "org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.utils");
            throw new ExceptionInInitializerError("the QVTo file compiled from the ECL contains syntactic errors. Please double check your ECL:" + diagnostic.getMessage());
        }
        URI outputMoCUri = URI.createURI((String)outputMoCPath, (boolean)true);
        URI outputFeedbackUri = URI.createURI((String)outputFeedbackPath, (boolean)true);
        URI outputPriorityUri = URI.createURI((String)outputPriorityPath, (boolean)true);
        Resource outputMoCResource = null;
        Resource outputFeedbackResource = null;
        Resource outputPriorityResource = null;
        try {
            outputMoCResource = this.outputResourceSet.createResource(outputMoCUri);
            outputFeedbackResource = this.outputResourceSet.createResource(outputFeedbackUri);
            outputPriorityResource = this.outputResourceSet.createResource(outputPriorityUri);
            outputMoCResource.getContents().addAll((Collection)outputMoC.getContents());
            outputFeedbackResource.getContents().addAll((Collection)outputFeedback.getContents());
            outputPriorityResource.getContents().addAll((Collection)outputPriority.getContents());
            this.hackImportStatements(modelURI, (ModelExtent)outputMoC);
            outputMoCResource.save(null);
            outputFeedbackResource.save(null);
            outputPriorityResource.save(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hackImportStatements(URI modelURI, ModelExtent output) {
        if (output.getContents().size() > 0 && output.getContents().get(0) instanceof ClockConstraintSystem) {
            ClockConstraintSystem system = (ClockConstraintSystem)output.getContents().get(0);
            for (ImportStatement i : system.getImports()) {
                if (i.getImportURI().equals(modelURI.toString())) continue;
                String pluginBasedURI = i.getImportURI().replace("platform:/resource", "platform:/plugin");
                i.setImportURI(pluginBasedURI);
            }
        }
    }
}

