/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.builder;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.core.builder.ClasspathLocation;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.Util;

class ClasspathDirectory
extends ClasspathLocation {
    IContainer binaryFolder;
    boolean isOutputFolder;
    String binaryLocation;
    SimpleLookupTable directoryCache;
    String[] missingPackageHolder = new String[1];
    AccessRuleSet accessRuleSet;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    ClasspathDirectory(IContainer binaryFolder, boolean isOutputFolder, AccessRuleSet accessRuleSet) {
        this.binaryFolder = binaryFolder;
        this.isOutputFolder = isOutputFolder;
        IPath location = binaryFolder.getLocation();
        this.binaryLocation = location != null ? location.addTrailingSeparator().toString() : "";
        this.directoryCache = new SimpleLookupTable(5);
        this.accessRuleSet = accessRuleSet;
    }

    @Override
    public void cleanup() {
        this.directoryCache = null;
    }

    String[] directoryList(String qualifiedPackageName) {
        String[] dirList = (String[])this.directoryCache.get((Object)qualifiedPackageName);
        if (dirList == this.missingPackageHolder) {
            return null;
        }
        if (dirList != null) {
            return dirList;
        }
        try {
            IResource container = this.binaryFolder.findMember(qualifiedPackageName);
            if (container instanceof IContainer) {
                IResource[] members = ((IContainer)container).members();
                dirList = new String[members.length];
                int index = 0;
                int i = 0;
                int l = members.length;
                while (i < l) {
                    IResource m = members[i];
                    if (m.getType() == 1 && Util.isClassFileName((String)m.getName())) {
                        dirList[index++] = m.getName();
                    }
                    ++i;
                }
                if (index < dirList.length) {
                    String[] stringArray = dirList;
                    dirList = new String[index];
                    System.arraycopy(stringArray, 0, dirList, 0, index);
                }
                this.directoryCache.put((Object)qualifiedPackageName, (Object)dirList);
                return dirList;
            }
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        this.directoryCache.put((Object)qualifiedPackageName, (Object)this.missingPackageHolder);
        return null;
    }

    boolean doesFileExist(String fileName, String qualifiedPackageName) {
        String[] dirList = this.directoryList(qualifiedPackageName);
        if (dirList == null) {
            return false;
        }
        int i = dirList.length;
        while (--i >= 0) {
            if (!fileName.equals(dirList[i])) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int num1 = this.accessRuleSet == null ? 0 : this.accessRuleSet.hashCode();
        int num2 = this.binaryFolder == null ? 0 : this.binaryFolder.hashCode();
        return num1 * num2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathDirectory)) {
            return false;
        }
        ClasspathDirectory dir = (ClasspathDirectory)o;
        if (!(this.accessRuleSet == dir.accessRuleSet || this.accessRuleSet != null && this.accessRuleSet.equals((Object)dir.accessRuleSet))) {
            return false;
        }
        return this.binaryFolder.equals((Object)dir.binaryFolder);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String qualifiedBinaryFileName) {
        block9: {
            Exception exception722222;
            block13: {
                ClassFileReader reader;
                block11: {
                    IPath location;
                    IResource file;
                    Exception exception2222222;
                    block12: {
                        ClassFileReader reader2;
                        block10: {
                            if (!this.doesFileExist(binaryFileName, qualifiedPackageName)) {
                                return null;
                            }
                            reader2 = ClassFileReader.read((String)(String.valueOf(this.binaryLocation) + qualifiedBinaryFileName));
                            if (reader2 == null) break block9;
                            if (this.accessRuleSet != null) break block10;
                            return new NameEnvironmentAnswer((IBinaryType)reader2, null);
                        }
                        return new NameEnvironmentAnswer((IBinaryType)reader2, this.accessRuleSet.getViolatedRestriction(qualifiedBinaryFileName.toCharArray()));
                        catch (Exception exception3) {
                            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception3, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
                            Exception exception4 = exception3;
                        }
                        break block12;
                        catch (Exception exception2222222) {
                            // empty catch block
                        }
                    }
                    CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception2222222, this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_3);
                    if (!(this.binaryFolder instanceof IProject) || !((file = this.binaryFolder.findMember(qualifiedBinaryFileName)) instanceof IFile) || (location = file.getLocation()) == null) break block9;
                    reader = ClassFileReader.read((String)location.toString());
                    if (reader == null) break block9;
                    if (this.accessRuleSet != null) break block11;
                    return new NameEnvironmentAnswer((IBinaryType)reader, null);
                }
                return new NameEnvironmentAnswer((IBinaryType)reader, this.accessRuleSet.getViolatedRestriction(qualifiedBinaryFileName.toCharArray()));
                catch (Exception exception5) {
                    CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception5, this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_3);
                    Exception exception6 = exception5;
                }
                break block13;
                catch (Exception exception722222) {
                    // empty catch block
                }
            }
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception722222, this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_3);
        }
        return null;
    }

    @Override
    public IPath getProjectRelativePath() {
        return this.binaryFolder.getProjectRelativePath();
    }

    @Override
    public boolean isOutputFolder() {
        return this.isOutputFolder;
    }

    @Override
    public boolean isPackage(String qualifiedPackageName) {
        return this.directoryList(qualifiedPackageName) != null;
    }

    @Override
    public void reset() {
        this.directoryCache = new SimpleLookupTable(5);
    }

    public String toString() {
        return "Binary classpath directory " + this.binaryFolder.getFullPath().toString();
    }

    @Override
    public String toOSString() {
        return this.binaryFolder.getLocation().toOSString();
    }

    static {
        ClasspathDirectory.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ClasspathDirectory.java", ClasspathDirectory.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.builder.ClasspathDirectory", "org.eclipse.core.runtime.CoreException", "<missing>"), 73);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("0", "directoryList", "org.eclipse.ajdt.internal.core.builder.ClasspathDirectory", "java.lang.String", "qualifiedPackageName", "", "[Ljava.lang.String;"), 51);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.builder.ClasspathDirectory", "java.lang.Exception", "<missing>"), 118);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "findClass", "org.eclipse.ajdt.internal.core.builder.ClasspathDirectory", "java.lang.String:java.lang.String:java.lang.String", "binaryFileName:qualifiedPackageName:qualifiedBinaryFileName", "", "org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer"), 108);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.builder.ClasspathDirectory", "java.lang.Exception", "<missing>"), 118);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.builder.ClasspathDirectory", "java.lang.Exception", "<missing>"), 132);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.builder.ClasspathDirectory", "java.lang.Exception", "<missing>"), 132);
    }
}

