/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.viewpoint.DMappingBased;

public class EdgeCreationDescriptionQuery {
    private EdgeCreationDescription tool;

    public EdgeCreationDescriptionQuery(EdgeCreationDescription tool) {
        this.tool = tool;
    }

    public boolean canCreate(DMappingBased source, DMappingBased target) {
        ArrayList<DiagramElementMapping> sources = new ArrayList<DiagramElementMapping>();
        ArrayList<DiagramElementMapping> targets = new ArrayList<DiagramElementMapping>();
        for (EdgeMapping edge : this.tool.getEdgeMappings()) {
            sources.addAll((Collection<DiagramElementMapping>)edge.getSourceMapping());
            targets.addAll((Collection<DiagramElementMapping>)edge.getTargetMapping());
        }
        return this.doCheckAtLeastOneIsInstanceOf(source, sources.iterator()) && this.doCheckAtLeastOneIsInstanceOf(target, targets.iterator());
    }

    public boolean canBeAppliedOn(DMappingBased source, DMappingBased target) {
        return this.isValidAsSourceElement(source) && this.isValidAsTargetElement(target);
    }

    public boolean isValidAsSourceElement(DMappingBased element) {
        Iterator<DiagramElementMapping> it = this.collectApplicableToolSourceMappings().iterator();
        return this.doCheckAtLeastOneIsInstanceOf(element, it);
    }

    public boolean isValidAsTargetElement(DMappingBased element) {
        Iterator<DiagramElementMapping> it = this.collectApplicableToolTargetMappings().iterator();
        return this.doCheckAtLeastOneIsInstanceOf(element, it);
    }

    private boolean doCheckAtLeastOneIsInstanceOf(DMappingBased element, Iterator<DiagramElementMapping> it) {
        while (it.hasNext()) {
            DiagramElementMapping next = it.next();
            if (!new DiagramElementMappingQuery(next).isInstanceOf(element)) continue;
            return true;
        }
        return false;
    }

    private Iterable<DiagramElementMapping> collectApplicableToolSourceMappings() {
        ArrayList<DiagramElementMapping> sources = new ArrayList<DiagramElementMapping>();
        for (EdgeMapping edge : this.tool.getEdgeMappings()) {
            sources.addAll((Collection<DiagramElementMapping>)edge.getSourceMapping());
        }
        sources.addAll((Collection<DiagramElementMapping>)this.tool.getExtraSourceMappings());
        return sources;
    }

    private Iterable<DiagramElementMapping> collectApplicableToolTargetMappings() {
        ArrayList<DiagramElementMapping> targets = new ArrayList<DiagramElementMapping>();
        for (EdgeMapping edge : this.tool.getEdgeMappings()) {
            targets.addAll((Collection<DiagramElementMapping>)edge.getTargetMapping());
        }
        targets.addAll((Collection<DiagramElementMapping>)this.tool.getExtraTargetMappings());
        return targets;
    }
}

