/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.serialization.relation;

import fr.inria.aoste.timesquare.backend.manager.serialization.OptionsSerializer;
import fr.inria.aoste.timesquare.backend.manager.serialization.PersistentEntity;
import fr.inria.aoste.timesquare.backend.manager.serialization.SpecialObjectInputStream;
import fr.inria.aoste.timesquare.backend.manager.serialization.relation.RelationBehaviorPersistentEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class RelationBehaviorOptionsSerializer
extends OptionsSerializer {
    private Map<String, List<RelationBehaviorPersistentEntity>> _data = new HashMap<String, List<RelationBehaviorPersistentEntity>>();

    public Map<String, List<RelationBehaviorPersistentEntity>> getData() {
        return this._data;
    }

    public void addPersistentEntity(String pluginName, RelationBehaviorPersistentEntity persistentEntity) {
        if (this._data != null) {
            boolean find = false;
            for (Map.Entry<String, List<RelationBehaviorPersistentEntity>> e : this._data.entrySet()) {
                if (!e.getKey().equals(pluginName)) continue;
                e.getValue().add(persistentEntity);
                find = true;
            }
            if (!find) {
                this._data.put(pluginName, new ArrayList());
                this._data.get(pluginName).add(persistentEntity);
            }
        }
    }

    public void addPersistentEntities(String pluginName, List<RelationBehaviorPersistentEntity> persistentEntities) {
        if (this._data != null && !this._data.containsKey(pluginName)) {
            this._data.put(pluginName, persistentEntities);
        }
    }

    @Override
    public boolean doesPluginNeedSerialization(String pluginName) {
        if (this._data == null) {
            return false;
        }
        return this._data.containsKey(pluginName);
    }

    @Override
    public String getSerializedOptions(String pluginName) {
        String result = "";
        if (this._data == null) {
            return result;
        }
        List<RelationBehaviorPersistentEntity> list = this._data.get(pluginName);
        if (list == null) {
            return result;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(list);
                oos.flush();
            }
            finally {
                try {
                    oos.close();
                }
                finally {
                    result = this.transformByteInString(baos.toByteArray());
                    baos.close();
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result;
    }

    @Override
    public void deserializeOptions(String options, BehaviorManager behaviorManager) {
        if (options == null || options.length() == 0 || behaviorManager == null || this._data == null) {
            return;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.transformStringInByte(options));
            SpecialObjectInputStream sois = new SpecialObjectInputStream(bais, behaviorManager.getClass().getClassLoader());
            try {
                List readObject = (List)sois.readObject();
                if (readObject != null) {
                    ArrayList<RelationBehaviorPersistentEntity> list = new ArrayList<RelationBehaviorPersistentEntity>();
                    ListIterator li = readObject.listIterator();
                    while (li.hasNext()) {
                        Object o = li.next();
                        if (!(o instanceof PersistentEntity)) continue;
                        list.add((RelationBehaviorPersistentEntity)o);
                    }
                    this.addPersistentEntities(behaviorManager.getPluginName(), list);
                }
            }
            finally {
                try {
                    sois.close();
                }
                finally {
                    bais.close();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

