/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.view;

import fr.inria.aoste.timesquare.backend.manager.controller.Controller;
import fr.inria.aoste.timesquare.backend.manager.datastructure.DataStructureManager;
import fr.inria.aoste.timesquare.backend.manager.launcher.extensionpoint.OutputSetup;
import fr.inria.aoste.timesquare.backend.manager.view.AssertBehaviorView;
import fr.inria.aoste.timesquare.backend.manager.view.BehaviorManagerDialog;
import fr.inria.aoste.timesquare.backend.manager.view.BehaviorView;
import fr.inria.aoste.timesquare.backend.manager.view.ClockBehaviorView;
import fr.inria.aoste.timesquare.backend.manager.view.RelationBehaviorView;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorManager;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorManagerGUI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class View {
    private Controller _controller;
    private DataStructureManager _ds;
    private Composite _rootComposite;
    private BehaviorManager _bm;
    private final List<BehaviorView> _behaviorList;
    private OutputSetup outputSetup;

    public View(Controller c, Composite composite, OutputSetup oSetup) {
        this.outputSetup = oSetup;
        this.setController(c);
        this._rootComposite = composite;
        this._behaviorList = new ArrayList<BehaviorView>();
        this._behaviorList.add(new ClockBehaviorView("behavior.clock.tree"));
        this._behaviorList.add(new AssertBehaviorView("behavior.assert.tree"));
        this._behaviorList.add(new RelationBehaviorView("behavior.relation.tree"));
    }

    public void setController(Controller controller) {
        this._controller = controller;
        this._ds = controller == null ? null : this._controller.getDsm();
    }

    public void setBehaviorManagers(BehaviorManager bm) {
        this._bm = bm;
    }

    public void display() {
        this._rootComposite.setLayout((Layout)new GridLayout(1, true));
        Composite boutons = new Composite(this._rootComposite, 0);
        boutons.setLayout((Layout)new RowLayout());
        Group behaviorGroup = new Group(this._rootComposite, 4);
        GridLayout gridData = new GridLayout(1, true);
        behaviorGroup.setLayout((Layout)gridData);
        GridData layoutData2 = new GridData(4, 4, true, true);
        behaviorGroup.setLayoutData((Object)layoutData2);
        behaviorGroup.setText("");
        this.createBehaviorContents((Composite)behaviorGroup);
        Button addButton = new Button(boutons, 8);
        addButton.setText("Add");
        this.outputSetup.register((Widget)addButton, "behavior.add");
        Button deleteButton = new Button(boutons, 8);
        deleteButton.setText("Delete");
        this.outputSetup.register((Widget)deleteButton, "behavior.delete");
        Button deleteAllButton = new Button(boutons, 8);
        deleteAllButton.setText("Delete All");
        this.outputSetup.register((Widget)deleteAllButton, "behavior.deleteAll");
        boutons.pack();
        addButton.addSelectionListener((SelectionListener)new AddButtonSelectionAdapter());
        deleteButton.addSelectionListener((SelectionListener)new DeleteButtonSelectionAdapter());
        deleteAllButton.addSelectionListener((SelectionListener)new DeleteAllButtonSelectionAdapter());
    }

    private void createBehaviorContents(Composite composite) {
        if (composite == null || this._behaviorList == null) {
            return;
        }
        for (BehaviorView bv : this._behaviorList) {
            bv.createContent(composite, this.outputSetup);
        }
    }

    public void refresh() {
        if (this._behaviorList == null) {
            return;
        }
        for (BehaviorView bv : this._behaviorList) {
            bv.clear();
        }
        if (this._ds != null) {
            for (BehaviorView bv : this._behaviorList) {
                bv.displayModel(this._ds);
            }
        }
    }

    public void managerSelected(BehaviorManager behaviorManager) {
        this._controller.notifyBehaviorManager(behaviorManager);
    }

    public void displayBehaviorManagerDialog(BehaviorManagerGUI behaviorManagerGUI) {
        if (behaviorManagerGUI == null) {
            return;
        }
        BehaviorManagerDialog behaviorManagerDialog = new BehaviorManagerDialog(this._rootComposite.getShell());
        behaviorManagerDialog.setBehaviorManagerGUI(behaviorManagerGUI);
        behaviorManagerDialog.open();
    }

    private final class AddButtonSelectionAdapter
    extends SelectionAdapter {
        private AddButtonSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            View.this.managerSelected(View.this._bm);
            View.this._controller.refresh();
        }
    }

    private final class DeleteAllButtonSelectionAdapter
    extends SelectionAdapter {
        private DeleteAllButtonSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            View.this._controller.deleteEntitiesByPluginName(View.this._bm.getPluginName());
            View.this._bm.clear();
            View.this._controller.getDsm().clear();
            for (BehaviorView bv : View.this._behaviorList) {
                bv.clear();
            }
            View.this._controller.refresh();
        }
    }

    private final class DeleteButtonSelectionAdapter
    extends SelectionAdapter {
        private DeleteButtonSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            if (View.this._behaviorList == null || View.this._controller == null) {
                return;
            }
            for (BehaviorView bv : View.this._behaviorList) {
                bv.deleteBehavior(View.this._controller, arg0);
            }
            View.this._controller.refresh();
        }
    }
}

