/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.common.graph;

import fr.kairos.common.graph.MyGraph;

public class AllPathsDFS {
    private boolean[] marked;
    private int[] edgeTo;
    private MyGraph graph;

    public AllPathsDFS(MyGraph graph, String source) {
        this.marked = new boolean[graph.getNodeNumber()];
        this.edgeTo = new int[graph.getNodeNumber()];
        this.graph = graph;
        this.dfs(graph.nameToIndex(source));
    }

    private void dfs(int current) {
        this.marked[current] = true;
        for (int neighbour : this.graph.neighbours(current)) {
            if (this.marked[neighbour]) continue;
            this.edgeTo[neighbour] = current;
            this.dfs(neighbour);
        }
    }

    public boolean hasPathTo(String node) {
        return this.marked[this.graph.nameToIndex(node)];
    }
}

