/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.reduce;

import fr.kairos.timesquare.ccsl.reduce.IFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AliasRepository {
    private Map<String, String> aliases;

    public AliasRepository() {
        this(new HashMap<String, String>());
    }

    public AliasRepository(Map<String, String> aliases) {
        this.aliases = aliases;
    }

    public String resolve(String name) {
        String res = this.aliases.get(name);
        if (res == null) {
            return name;
        }
        return this.resolve(res);
    }

    public String[] resolve(String ... names) {
        String[] res = new String[names.length];
        int i = 0;
        while (i < res.length) {
            res[i] = this.resolve(names[i]);
            ++i;
        }
        return res;
    }

    public String declare(String alias, String realClock) {
        realClock = this.resolve(realClock);
        alias = this.resolve(alias);
        this.aliases.put(alias, realClock);
        return realClock;
    }

    public IFilter<String> filterClock() {
        return s -> this.resolve((String)s);
    }

    public IFilter<String[]> filterClocks() {
        return s -> this.resolve((String)s);
    }

    public void reduce() {
        Iterator<String> iterator = this.aliases.keySet().iterator();
        while (iterator.hasNext()) {
            String other;
            String key;
            String localKey = key = iterator.next();
            while ((other = this.resolve(localKey)) != localKey) {
                localKey = other;
            }
            if (key == localKey) continue;
            this.aliases.put(key, localKey);
        }
    }
}

