/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.reduce;

import fr.kairos.timesquare.ccsl.ISimpleSpecification;
import fr.kairos.timesquare.ccsl.reduce.IFilter;

public class FilterSpecification
implements ISimpleSpecification {
    private ISimpleSpecification delegate;
    private IFilter<String> filterClock;
    private IFilter<String[]> filterClocks;

    public FilterSpecification(ISimpleSpecification spec, IFilter<String> filterClock, IFilter<String[]> filterClocks) {
        this.delegate = spec;
        this.filterClock = filterClock;
        this.filterClocks = filterClocks;
    }

    private String resolve(String clock) {
        return this.filterClock.filter(clock);
    }

    private String[] resolve(String[] clocks) {
        return this.filterClocks.filter(clocks);
    }

    @Override
    public void addClock(String name) {
        this.delegate.addClock(this.resolve(name));
    }

    @Override
    public void subclock(String left, String right) {
        this.delegate.subclock(this.resolve(left), this.resolve(right));
    }

    @Override
    public void exclusion(String left, String right) {
        this.delegate.exclusion(this.resolve(left), this.resolve(right));
    }

    @Override
    public void precedence(String left, String right) {
        this.delegate.precedence(this.resolve(left), this.resolve(right));
    }

    @Override
    public void precedence(String left, String right, int min, int max) {
        this.delegate.precedence(this.resolve(left), this.resolve(right), min, max);
    }

    @Override
    public void causality(String left, String right) {
        this.delegate.causality(this.resolve(left), this.resolve(right));
    }

    @Override
    public void causality(String left, String right, int min, int max) {
        if (max == 0) {
            return;
        }
        this.delegate.causality(this.resolve(left), this.resolve(right), min, max);
    }

    @Override
    public void inf(String defClock, String ... clocks) {
        if (clocks.length == 1) {
            return;
        }
        this.delegate.inf(this.resolve(defClock), this.resolve(clocks));
    }

    @Override
    public void sup(String defClock, String ... clocks) {
        if (clocks.length == 1) {
            return;
        }
        this.delegate.sup(this.resolve(defClock), this.resolve(clocks));
    }

    @Override
    public void union(String defClock, String ... clocks) {
        if (clocks.length == 1) {
            return;
        }
        this.delegate.union(this.resolve(defClock), this.resolve(clocks));
    }

    @Override
    public void intersection(String defClock, String ... clocks) {
        if (clocks.length == 1) {
            return;
        }
        this.delegate.intersection(this.resolve(defClock), this.resolve(clocks));
    }

    @Override
    public void minus(String defClock, String ... clocks) {
        if (clocks.length == 1) {
            return;
        }
        this.delegate.minus(this.resolve(defClock), this.resolve(clocks));
    }

    @Override
    public void periodic(String defClock, String ref, int period, int from, int upTo) {
        if (period == 1 && from == 0 && upTo == -1) {
            return;
        }
        this.delegate.periodic(this.resolve(defClock), this.resolve(ref), period, from, upTo);
    }

    @Override
    public void delayFor(String defClock, String ref, int from, int upTo, String base) {
        if (from != 0 || upTo != -1) {
            this.delegate.delayFor(this.resolve(defClock), this.resolve(ref), from, upTo, this.resolve(base));
        }
    }
}

