/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.safety;

import fr.kairos.common.graph.AllPathsDFS;
import fr.kairos.common.graph.MyGraph;
import fr.kairos.timesquare.ccsl.IDefinition;
import fr.kairos.timesquare.ccsl.IRelation;
import fr.kairos.timesquare.ccsl.ISpecification;
import fr.kairos.timesquare.ccsl.graph.Helper;
import fr.kairos.timesquare.ccsl.simple.CopyWithReplace;
import fr.kairos.timesquare.ccsl.simple.Definition;
import fr.kairos.timesquare.ccsl.simple.Specification;

public class Simplification
implements ISpecification {
    private MyGraph graph;
    private CopyWithReplace copy;

    private Simplification(String name, MyGraph graph) {
        this.copy = new CopyWithReplace(String.valueOf(name) + "_s");
        this.graph = graph;
    }

    public static Specification simplify(ISpecification spec) {
        if (spec instanceof Specification) {
            return Simplification.simplify((Specification)spec);
        }
        throw new RuntimeException("Do not know how to copy a generic ISpecification");
    }

    public static Specification simplify(Specification spec) {
        Simplification simple = new Simplification(spec.getName(), Helper.buildCausalityGraph(spec));
        spec.visit(simple);
        return simple.copy.getResult();
    }

    private boolean hasPathTo(String source, String target) {
        AllPathsDFS dfs = new AllPathsDFS(this.graph, source);
        return dfs.hasPathTo(target);
    }

    private String[] inf(String defClock, String ... clocks) {
        clocks = this.copy.replace(clocks);
        int iMin = 0;
        int toBeRemoved = 0;
        int i = 1;
        while (i < clocks.length) {
            if (this.hasPathTo(clocks[i], clocks[iMin])) {
                clocks[iMin] = null;
                iMin = i;
                ++toBeRemoved;
            } else if (this.hasPathTo(clocks[iMin], clocks[i])) {
                clocks[i] = null;
                ++toBeRemoved;
            }
            ++i;
        }
        if (toBeRemoved == clocks.length - 1) {
            this.copy.replace(defClock, clocks[iMin]);
        }
        return this.removeNull(clocks, toBeRemoved);
    }

    private String[] removeNull(String[] init, int toBeRemoved) {
        if (toBeRemoved == 0) {
            return init;
        }
        String[] res = new String[init.length - toBeRemoved];
        int i = 0;
        String[] stringArray = init;
        int n = init.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null) {
                res[i++] = s;
            }
            ++n2;
        }
        return res;
    }

    private String[] sup(String defClock, String ... clocks) {
        clocks = this.copy.replace(clocks);
        int iMax = 0;
        int toBeRemoved = 0;
        int i = 1;
        while (i < clocks.length) {
            if (this.hasPathTo(clocks[iMax], clocks[i])) {
                clocks[iMax] = null;
                iMax = i;
                ++toBeRemoved;
            } else if (this.hasPathTo(clocks[i], clocks[iMax])) {
                clocks[i] = null;
                ++toBeRemoved;
            }
            ++i;
        }
        if (toBeRemoved == clocks.length - 1) {
            this.copy.replace(defClock, clocks[iMax]);
        }
        return this.removeNull(clocks, toBeRemoved);
    }

    @Override
    public void addClock(String name) {
        this.copy.addClock(name);
    }

    @Override
    public void add(IDefinition def) {
        if (def.getConstraintName().equals("Inf")) {
            String[] clocks = this.inf(def.getDefinedClock(), def.getRefClocks());
            if (clocks.length == 1) {
                return;
            }
            def = new Definition(def.getDefinedClock(), "Inf", clocks);
        } else if (def.getConstraintName().equals("Sup")) {
            String[] clocks = this.sup(def.getDefinedClock(), def.getRefClocks());
            if (clocks.length == 1) {
                return;
            }
            def = new Definition(def.getDefinedClock(), "Sup", clocks);
        }
        this.copy.add(def);
    }

    @Override
    public void add(IRelation relation) {
        this.copy.add(relation);
    }

    @Override
    public boolean isConstraintSupported(String name) {
        return true;
    }
}

