/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.refresh;

import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.sequence.business.internal.refresh.SequenceSlidableAnchor;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.view.EdgeLayoutData;
import org.eclipse.sirius.diagram.ui.business.internal.view.LayoutData;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;

public class FixBendpointsOnCreationCommand
extends RecordingCommand {
    private Edge newEdge;
    private View source;
    private View target;
    private String sourceTerminal;
    private String targetTerminal;
    private PointList pointList;
    private Routing routing;

    public FixBendpointsOnCreationCommand(TransactionalEditingDomain domain, Edge createdEdge) {
        super(domain);
        this.newEdge = createdEdge;
    }

    protected void doExecute() {
        EObject element;
        this.source = this.newEdge.getSource();
        this.target = this.newEdge.getTarget();
        if (this.source != null && this.target != null && (element = this.newEdge.getElement()) instanceof DEdge) {
            DEdge dEdge = (DEdge)element;
            this.updateEdge(dEdge);
        }
    }

    private void updateEdge(DEdge dEdge) {
        this.pointList = new PointList();
        Point sourceRefPoint = new Point(0, 0);
        Point targetRefPoint = new Point(0, 0);
        EdgeLayoutData edgeLayoutData = null;
        SiriusLayoutDataManager.INSTANCE.setIgnoreConsumeState(true);
        try {
            edgeLayoutData = SiriusLayoutDataManager.INSTANCE.getData(dEdge, false);
        }
        finally {
            SiriusLayoutDataManager.INSTANCE.setIgnoreConsumeState(false);
        }
        if (edgeLayoutData != null) {
            this.sourceTerminal = edgeLayoutData.getSourceTerminal();
            this.targetTerminal = edgeLayoutData.getTargetTerminal();
            if (edgeLayoutData.getPointList() != null) {
                this.pointList = edgeLayoutData.getPointList();
            }
            if (edgeLayoutData.getSourceRefPoint() != null) {
                sourceRefPoint = edgeLayoutData.getSourceRefPoint();
            }
            if (edgeLayoutData.getTargetRefPoint() != null) {
                targetRefPoint = edgeLayoutData.getTargetRefPoint();
            }
            this.routing = edgeLayoutData.getRouting();
        } else {
            this.computeEdgeDataWithoutEdgeLayoutData();
        }
        this.updateConnectionAnchors();
        this.updateBendpoints(sourceRefPoint, targetRefPoint);
    }

    private void computeEdgeDataWithoutEdgeLayoutData() {
        Point firstClick = new Point(0, 0);
        Rectangle sourceBounds = GMFHelper.getAbsoluteBounds((Node)((Node)this.source));
        if (this.source.getElement() instanceof AbstractDNode) {
            Point sourceLocation;
            AbstractDNode parentDNode;
            AbstractDNode sourceDNode = (AbstractDNode)this.source.getElement();
            if (sourceDNode.eContainer() instanceof AbstractDNode && (parentDNode = (AbstractDNode)sourceDNode.eContainer()).getOwnedBorderedNodes().contains((Object)sourceDNode)) {
                sourceBounds.y += IBorderItemOffsets.DEFAULT_OFFSET.height;
                sourceBounds.height += 5;
            }
            LayoutData sourceLayoutData = null;
            SiriusLayoutDataManager.INSTANCE.setIgnoreConsumeState(true);
            try {
                sourceLayoutData = SiriusLayoutDataManager.INSTANCE.getData(sourceDNode);
            }
            finally {
                SiriusLayoutDataManager.INSTANCE.setIgnoreConsumeState(false);
            }
            firstClick = sourceLayoutData == null ? sourceBounds.getCenter() : (sourceLocation = sourceLayoutData.getLocation());
        }
        PrecisionPoint sourceRelativeLocation = this.getAnchorRelativeLocation(firstClick, sourceBounds);
        this.sourceTerminal = "(" + sourceRelativeLocation.preciseX() + "," + sourceRelativeLocation.preciseY() + ")";
        Point secondClick = new Point(0, 0);
        Rectangle targetBounds = GMFHelper.getAbsoluteBounds((Node)((Node)this.target));
        if (this.target.getElement() instanceof AbstractDNode) {
            Point targetLocation;
            AbstractDNode parentDNode;
            AbstractDNode targetDNode = (AbstractDNode)this.target.getElement();
            if (targetDNode.eContainer() instanceof AbstractDNode && (parentDNode = (AbstractDNode)targetDNode.eContainer()).getOwnedBorderedNodes().contains((Object)targetDNode)) {
                targetBounds.y += IBorderItemOffsets.DEFAULT_OFFSET.height;
                targetBounds.height += 5;
            }
            LayoutData targetLayoutData = null;
            SiriusLayoutDataManager.INSTANCE.setIgnoreConsumeState(true);
            try {
                targetLayoutData = SiriusLayoutDataManager.INSTANCE.getData(targetDNode);
            }
            finally {
                SiriusLayoutDataManager.INSTANCE.setIgnoreConsumeState(false);
            }
            secondClick = targetLayoutData == null ? targetBounds.getCenter() : (targetLocation = targetLayoutData.getLocation());
        }
        PrecisionPoint targetRelativeLocation = this.getAnchorRelativeLocation(secondClick, targetBounds);
        this.targetTerminal = "(" + targetRelativeLocation.preciseX() + "," + targetRelativeLocation.preciseY() + ")";
        PrecisionPoint sourceRelativeReference = SequenceSlidableAnchor.parseTerminalString((String)this.sourceTerminal);
        SequenceSlidableAnchor sourceAnchor = new SequenceSlidableAnchor((Node)this.source, sourceRelativeReference);
        this.pointList.addPoint(sourceAnchor.getLocation(sourceAnchor.getReferencePoint()));
        PrecisionPoint targetRelativeReference = SequenceSlidableAnchor.parseTerminalString((String)this.targetTerminal);
        SequenceSlidableAnchor targetAnchor = new SequenceSlidableAnchor((Node)this.target, targetRelativeReference);
        this.pointList.addPoint(targetAnchor.getLocation(targetAnchor.getReferencePoint()));
    }

    private PrecisionPoint getAnchorRelativeLocation(Point p, Rectangle bounds) {
        PrecisionPoint relLocation;
        if (bounds.width == 0 || bounds.height == 0) {
            return new PrecisionPoint(0.5, 0.5);
        }
        PrecisionPoint temp = new PrecisionPoint(p);
        if (p.x < bounds.x || p.x > bounds.x + bounds.width || p.y < bounds.y || p.y > bounds.y + bounds.height) {
            if (p.x < bounds.x || p.x > bounds.x + bounds.width) {
                temp.setPreciseX((double)(p.x < bounds.x ? bounds.x : bounds.x + bounds.width));
            }
            if (p.y < bounds.y || p.y > bounds.y + bounds.height) {
                temp.setPreciseY((double)(p.y < bounds.y ? bounds.y : bounds.y + bounds.height));
            }
            relLocation = new PrecisionPoint((temp.preciseX() - (double)bounds.x) / (double)bounds.width, (temp.preciseY() - (double)bounds.y) / (double)bounds.height);
        } else {
            relLocation = new PrecisionPoint((temp.preciseX() - (double)bounds.x) / (double)bounds.width, (temp.preciseY() - (double)bounds.y) / (double)bounds.height);
        }
        return relLocation;
    }

    private void updateConnectionAnchors() {
        IdentityAnchor a;
        if (this.sourceTerminal != null) {
            if (this.sourceTerminal.length() == 0) {
                this.newEdge.setSourceAnchor(null);
            } else {
                a = (IdentityAnchor)this.newEdge.getSourceAnchor();
                if (a == null) {
                    a = NotationFactory.eINSTANCE.createIdentityAnchor();
                }
                a.setId(this.sourceTerminal);
                this.newEdge.setSourceAnchor((Anchor)a);
            }
        }
        if (this.targetTerminal != null) {
            if (this.targetTerminal.length() == 0) {
                this.newEdge.setTargetAnchor(null);
            } else {
                a = (IdentityAnchor)this.newEdge.getTargetAnchor();
                if (a == null) {
                    a = NotationFactory.eINSTANCE.createIdentityAnchor();
                }
                a.setId(this.targetTerminal);
                this.newEdge.setTargetAnchor((Anchor)a);
            }
        }
    }

    private void updateBendpoints(Point sourceRefPoint, Point targetRefPoint) {
        ArrayList<RelativeBendpoint> newBendpoints = new ArrayList<RelativeBendpoint>();
        int numOfPoints = this.pointList.size();
        int i = 0;
        while (i < numOfPoints) {
            Dimension s = this.pointList.getPoint(i).getDifference(sourceRefPoint);
            Dimension t = this.pointList.getPoint(i).getDifference(targetRefPoint);
            newBendpoints.add(new RelativeBendpoint(s.width, s.height, t.width, t.height));
            i = (short)(i + 1);
        }
        RelativeBendpoints points = (RelativeBendpoints)this.newEdge.getBendpoints();
        points.setPoints(newBendpoints);
        if (this.routing != null) {
            Style routingStyle = this.newEdge.getStyle(NotationPackage.Literals.ROUTING_STYLE);
            routingStyle.eSet((EStructuralFeature)NotationPackage.Literals.ROUTING_STYLE__ROUTING, (Object)this.routing);
        }
    }
}

