/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.messagingsystem.api.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.api.MessagingSystem;
import org.eclipse.gemoc.commons.messagingsystem.api.impl.StdioSimpleMessagingSystem;
import org.eclipse.gemoc.commons.messagingsystem.api.reference.Reference;

public class ErrorAwareMessagingSystem
extends StdioSimpleMessagingSystem {
    public List<String> errorTrace = new ArrayList<String>();

    @Override
    public void log(MessagingSystem.Kind msgKind, String message, String messageGroup) {
        System.out.println(String.valueOf(this.getKindString(msgKind)) + " [" + messageGroup + "] " + message + " " + this.getCallerString());
        switch (msgKind) {
            case UserERROR: {
                this.errorTrace.add(String.valueOf(this.getKindString(msgKind)) + " [" + messageGroup + "] " + message + " " + " " + this.getCallerString());
                break;
            }
            case DevERROR: {
                this.errorTrace.add(String.valueOf(this.getKindString(msgKind)) + " [" + messageGroup + "] " + message + " " + " " + this.getCallerString());
                break;
            }
        }
    }

    @Override
    public void log(MessagingSystem.Kind msgKind, String message, String messageGroup, Throwable throwable) {
        StringWriter sw = new StringWriter();
        if (throwable != null) {
            throwable.printStackTrace(new PrintWriter(sw));
        }
        String stackTrace = sw.toString();
        System.out.println(String.valueOf(this.getKindString(msgKind)) + " [" + messageGroup + "] " + message + " " + this.getCallerString() + "\n" + stackTrace);
        switch (msgKind) {
            case UserERROR: {
                this.errorTrace.add(String.valueOf(this.getKindString(msgKind)) + " [" + messageGroup + "] " + message + " " + " " + this.getCallerString());
                break;
            }
            case DevERROR: {
                this.errorTrace.add(String.valueOf(this.getKindString(msgKind)) + " [" + messageGroup + "] " + message + " " + " " + this.getCallerString());
                break;
            }
        }
    }

    @Override
    public void logProblem(MessagingSystem.Kind msgKind, String message, String messageGroup, Reference causeObject) {
        System.out.println(String.valueOf(this.getKindString(msgKind)) + " [" + messageGroup + "] " + message + " " + causeObject + " " + this.getCallerString());
        this.errorTrace.add(String.valueOf(this.getKindString(msgKind)) + " [" + messageGroup + "] " + message + " " + causeObject + " " + this.getCallerString());
    }

    @Override
    public void logProblem(MessagingSystem.Kind msgKind, String message, String messageGroup, Throwable throwable, Reference causeObject) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        String stackTrace = sw.toString();
        System.out.println(String.valueOf(this.getKindString(msgKind)) + " [" + messageGroup + "] " + message + " " + causeObject + " " + this.getCallerString() + "\n" + stackTrace);
        this.errorTrace.add(String.valueOf(this.getKindString(msgKind)) + " [" + messageGroup + "] " + message + " " + causeObject + " " + this.getCallerString());
    }
}

