/**
 */
package org.eclipse.gemoc.trace.commons.model.generictrace.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.gemoc.trace.commons.model.generictrace.util.GenerictraceAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class GenerictraceItemProviderAdapterFactory extends GenerictraceAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GenerictraceItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.GenericSequentialStep} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenericSequentialStepItemProvider genericSequentialStepItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.GenericSequentialStep}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenericSequentialStepAdapter() {
		if (genericSequentialStepItemProvider == null) {
			genericSequentialStepItemProvider = new GenericSequentialStepItemProvider(this);
		}

		return genericSequentialStepItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.GenericParallelStep} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenericParallelStepItemProvider genericParallelStepItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.GenericParallelStep}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenericParallelStepAdapter() {
		if (genericParallelStepItemProvider == null) {
			genericParallelStepItemProvider = new GenericParallelStepItemProvider(this);
		}

		return genericParallelStepItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.GenericSmallStep} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenericSmallStepItemProvider genericSmallStepItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.GenericSmallStep}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenericSmallStepAdapter() {
		if (genericSmallStepItemProvider == null) {
			genericSmallStepItemProvider = new GenericSmallStepItemProvider(this);
		}

		return genericSmallStepItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.GenericDimension} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenericDimensionItemProvider genericDimensionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.GenericDimension}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenericDimensionAdapter() {
		if (genericDimensionItemProvider == null) {
			genericDimensionItemProvider = new GenericDimensionItemProvider(this);
		}

		return genericDimensionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.GenericTracedObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenericTracedObjectItemProvider genericTracedObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.GenericTracedObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenericTracedObjectAdapter() {
		if (genericTracedObjectItemProvider == null) {
			genericTracedObjectItemProvider = new GenericTracedObjectItemProvider(this);
		}

		return genericTracedObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.GenericState} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenericStateItemProvider genericStateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.GenericState}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenericStateAdapter() {
		if (genericStateItemProvider == null) {
			genericStateItemProvider = new GenericStateItemProvider(this);
		}

		return genericStateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.GenericTrace} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenericTraceItemProvider genericTraceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.GenericTrace}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenericTraceAdapter() {
		if (genericTraceItemProvider == null) {
			genericTraceItemProvider = new GenericTraceItemProvider(this);
		}

		return genericTraceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.BooleanAttributeValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BooleanAttributeValueItemProvider booleanAttributeValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.BooleanAttributeValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBooleanAttributeValueAdapter() {
		if (booleanAttributeValueItemProvider == null) {
			booleanAttributeValueItemProvider = new BooleanAttributeValueItemProvider(this);
		}

		return booleanAttributeValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.IntegerAttributeValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntegerAttributeValueItemProvider integerAttributeValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.IntegerAttributeValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIntegerAttributeValueAdapter() {
		if (integerAttributeValueItemProvider == null) {
			integerAttributeValueItemProvider = new IntegerAttributeValueItemProvider(this);
		}

		return integerAttributeValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.StringAttributeValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringAttributeValueItemProvider stringAttributeValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.StringAttributeValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringAttributeValueAdapter() {
		if (stringAttributeValueItemProvider == null) {
			stringAttributeValueItemProvider = new StringAttributeValueItemProvider(this);
		}

		return stringAttributeValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.ManyBooleanAttributeValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ManyBooleanAttributeValueItemProvider manyBooleanAttributeValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.ManyBooleanAttributeValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createManyBooleanAttributeValueAdapter() {
		if (manyBooleanAttributeValueItemProvider == null) {
			manyBooleanAttributeValueItemProvider = new ManyBooleanAttributeValueItemProvider(this);
		}

		return manyBooleanAttributeValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.ManyIntegerAttributeValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ManyIntegerAttributeValueItemProvider manyIntegerAttributeValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.ManyIntegerAttributeValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createManyIntegerAttributeValueAdapter() {
		if (manyIntegerAttributeValueItemProvider == null) {
			manyIntegerAttributeValueItemProvider = new ManyIntegerAttributeValueItemProvider(this);
		}

		return manyIntegerAttributeValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.ManyStringAttributeValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ManyStringAttributeValueItemProvider manyStringAttributeValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.ManyStringAttributeValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createManyStringAttributeValueAdapter() {
		if (manyStringAttributeValueItemProvider == null) {
			manyStringAttributeValueItemProvider = new ManyStringAttributeValueItemProvider(this);
		}

		return manyStringAttributeValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.SingleReferenceValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleReferenceValueItemProvider singleReferenceValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.SingleReferenceValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSingleReferenceValueAdapter() {
		if (singleReferenceValueItemProvider == null) {
			singleReferenceValueItemProvider = new SingleReferenceValueItemProvider(this);
		}

		return singleReferenceValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.ManyReferenceValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ManyReferenceValueItemProvider manyReferenceValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.ManyReferenceValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createManyReferenceValueAdapter() {
		if (manyReferenceValueItemProvider == null) {
			manyReferenceValueItemProvider = new ManyReferenceValueItemProvider(this);
		}

		return manyReferenceValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.IntegerObjectAttributeValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntegerObjectAttributeValueItemProvider integerObjectAttributeValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.IntegerObjectAttributeValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIntegerObjectAttributeValueAdapter() {
		if (integerObjectAttributeValueItemProvider == null) {
			integerObjectAttributeValueItemProvider = new IntegerObjectAttributeValueItemProvider(this);
		}

		return integerObjectAttributeValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.DoubleAttributeValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DoubleAttributeValueItemProvider doubleAttributeValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.DoubleAttributeValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDoubleAttributeValueAdapter() {
		if (doubleAttributeValueItemProvider == null) {
			doubleAttributeValueItemProvider = new DoubleAttributeValueItemProvider(this);
		}

		return doubleAttributeValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.ManyDoubleAttributeValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ManyDoubleAttributeValueItemProvider manyDoubleAttributeValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.ManyDoubleAttributeValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createManyDoubleAttributeValueAdapter() {
		if (manyDoubleAttributeValueItemProvider == null) {
			manyDoubleAttributeValueItemProvider = new ManyDoubleAttributeValueItemProvider(this);
		}

		return manyDoubleAttributeValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.DoubleObjectAttributeValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DoubleObjectAttributeValueItemProvider doubleObjectAttributeValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.DoubleObjectAttributeValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDoubleObjectAttributeValueAdapter() {
		if (doubleObjectAttributeValueItemProvider == null) {
			doubleObjectAttributeValueItemProvider = new DoubleObjectAttributeValueItemProvider(this);
		}

		return doubleObjectAttributeValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.LongAttributeValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LongAttributeValueItemProvider longAttributeValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.LongAttributeValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLongAttributeValueAdapter() {
		if (longAttributeValueItemProvider == null) {
			longAttributeValueItemProvider = new LongAttributeValueItemProvider(this);
		}

		return longAttributeValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.ManyLongAttributeValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ManyLongAttributeValueItemProvider manyLongAttributeValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.ManyLongAttributeValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createManyLongAttributeValueAdapter() {
		if (manyLongAttributeValueItemProvider == null) {
			manyLongAttributeValueItemProvider = new ManyLongAttributeValueItemProvider(this);
		}

		return manyLongAttributeValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gemoc.trace.commons.model.generictrace.LongObjectAttributeValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LongObjectAttributeValueItemProvider longObjectAttributeValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gemoc.trace.commons.model.generictrace.LongObjectAttributeValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLongObjectAttributeValueAdapter() {
		if (longObjectAttributeValueItemProvider == null) {
			longObjectAttributeValueItemProvider = new LongObjectAttributeValueItemProvider(this);
		}

		return longObjectAttributeValueItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (genericSequentialStepItemProvider != null) genericSequentialStepItemProvider.dispose();
		if (genericParallelStepItemProvider != null) genericParallelStepItemProvider.dispose();
		if (genericSmallStepItemProvider != null) genericSmallStepItemProvider.dispose();
		if (genericDimensionItemProvider != null) genericDimensionItemProvider.dispose();
		if (genericTracedObjectItemProvider != null) genericTracedObjectItemProvider.dispose();
		if (genericStateItemProvider != null) genericStateItemProvider.dispose();
		if (genericTraceItemProvider != null) genericTraceItemProvider.dispose();
		if (booleanAttributeValueItemProvider != null) booleanAttributeValueItemProvider.dispose();
		if (integerAttributeValueItemProvider != null) integerAttributeValueItemProvider.dispose();
		if (stringAttributeValueItemProvider != null) stringAttributeValueItemProvider.dispose();
		if (manyBooleanAttributeValueItemProvider != null) manyBooleanAttributeValueItemProvider.dispose();
		if (manyIntegerAttributeValueItemProvider != null) manyIntegerAttributeValueItemProvider.dispose();
		if (manyStringAttributeValueItemProvider != null) manyStringAttributeValueItemProvider.dispose();
		if (singleReferenceValueItemProvider != null) singleReferenceValueItemProvider.dispose();
		if (manyReferenceValueItemProvider != null) manyReferenceValueItemProvider.dispose();
		if (integerObjectAttributeValueItemProvider != null) integerObjectAttributeValueItemProvider.dispose();
		if (doubleAttributeValueItemProvider != null) doubleAttributeValueItemProvider.dispose();
		if (manyDoubleAttributeValueItemProvider != null) manyDoubleAttributeValueItemProvider.dispose();
		if (doubleObjectAttributeValueItemProvider != null) doubleObjectAttributeValueItemProvider.dispose();
		if (longAttributeValueItemProvider != null) longAttributeValueItemProvider.dispose();
		if (manyLongAttributeValueItemProvider != null) manyLongAttributeValueItemProvider.dispose();
		if (longObjectAttributeValueItemProvider != null) longObjectAttributeValueItemProvider.dispose();
	}

}
