/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime.simulation;

import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.NoBooleanSolution;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.relations.AbstractRuntimeRelation;
import fr.inria.aoste.timesquare.ccslkernel.runtime.simulation.AbstractCCSLSimulationEngine;
import fr.inria.aoste.timesquare.ccslkernel.runtime.simulation.ClockDeathSolver;
import fr.inria.aoste.timesquare.simulationpolicy.SimulationPolicyBase;
import fr.inria.aoste.timesquare.simulationpolicy.bitset.ClockTraceState;
import fr.inria.aoste.timesquare.simulationpolicy.bitset.ClockTraceStateSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.javabdd.BuDDyFactory;

public abstract class AbstractStepExecutionEngine {
    protected AbstractCCSLSimulationEngine simulationEngine;
    protected AbstractSemanticHelper semanticHelper;
    protected AbstractUpdateHelper updateHelper;
    public BuDDyFactory.BuDDyBDD semanticBdd;
    public BuDDyFactory.BuDDyBDD semanticBdd_beforeClockForcing;
    protected Set<RuntimeClock> usedClocks;
    protected ClockDeathSolver deathSolver;
    protected Set<RuntimeClock> enabledClocks;
    protected Set<RuntimeClock> firedClocks;
    protected Set<RuntimeClock> newDeadClocks;
    protected Set<RuntimeClock> resurrectedClocks;
    protected Set<RuntimeClock> startQueue;
    protected Set<Integer> assertionVariableNumbers;
    public ArrayList<ClockTraceStateSet> allClockTraceStateSet = new ArrayList();
    protected ClockTraceStateSet enabled;
    protected ClockTraceStateSet fired;

    public AbstractStepExecutionEngine() {
        this.init();
    }

    public AbstractStepExecutionEngine(AbstractCCSLSimulationEngine solverEngine) {
        this.simulationEngine = solverEngine;
        this.init();
    }

    private void init() {
        this.usedClocks = new HashSet<RuntimeClock>();
        this.deathSolver = new ClockDeathSolver();
        this.enabledClocks = new HashSet<RuntimeClock>();
        this.firedClocks = new HashSet<RuntimeClock>();
        this.newDeadClocks = new HashSet<RuntimeClock>();
        this.resurrectedClocks = new HashSet<RuntimeClock>();
        this.startQueue = new HashSet<RuntimeClock>();
        this.assertionVariableNumbers = new HashSet<Integer>();
    }

    protected void initHelpers() {
        this.semanticHelper = this.createSemanticHelper();
        this.updateHelper = this.createUpdateHelper();
    }

    protected abstract AbstractSemanticHelper createSemanticHelper();

    protected abstract AbstractUpdateHelper createUpdateHelper();

    public void executeStep() throws SimulationException {
        this.clearStepData();
        this.stepPreHook();
        this.computePossibleClockStates();
        this.allClockTraceStateSet = this.getAllBDDSolutions();
        if (this.allClockTraceStateSet.size() > 0) {
            int chosenLogicalStep = this.proposeLogicalStepByIndex();
            this.applyLogicalStepByIndex(chosenLogicalStep);
        } else {
            this.fired = new ClockTraceStateSet(0);
            this.enabled = new ClockTraceStateSet(0);
        }
        this.stepPostHook();
    }

    public void clearFiredClock() {
        this.firedClocks.clear();
    }

    public void clearStepData() {
        this.usedClocks.clear();
        this.enabledClocks.clear();
        this.firedClocks.clear();
        this.newDeadClocks.clear();
        this.resurrectedClocks.clear();
        this.startQueue.clear();
        this.deathSolver.clear();
        this.assertionVariableNumbers.clear();
        if (this.semanticBdd != null) {
            this.semanticBdd.free();
        }
    }

    protected abstract void stepPreHook();

    protected abstract void stepPostHook();

    public void computePossibleClockStates() throws SimulationException {
        this.constructCurrentStepBDD();
        this.inhibitUnusedClocks();
    }

    protected abstract void constructCurrentStepBDD() throws SimulationException;

    protected void inhibitUnusedClocks() {
        List<RuntimeClock> allClocks = this.getAllDiscreteClocks();
        for (RuntimeClock clock : allClocks) {
            if (this.getUsedClocks().contains(clock)) continue;
            this.semanticHelper.inhibitClock(clock);
        }
    }

    public abstract List<RuntimeClock> getAllDiscreteClocks();

    public abstract ArrayList<ClockTraceStateSet> getAllBDDSolutions() throws NoBooleanSolution;

    public int proposeLogicalStepByIndex() {
        SimulationPolicyBase policy = this.getSimulationPolicy();
        if (policy == null) {
            ArrayList<ClockTraceStateSet> satSol = this.satOneSolution(this.getBddVarToIndexInSolution());
            this.allClockTraceStateSet = new ArrayList();
            this.allClockTraceStateSet.add(satSol.get(0));
            return 0;
        }
        return this.chooseBooleanSolution(this.allClockTraceStateSet);
    }

    public abstract Map<Integer, Integer> getBddVarToIndexInSolution();

    public int getIndexInSolution(int bddVar) {
        return this.getBddVarToIndexInSolution().get(bddVar);
    }

    protected abstract BuDDyFactory getBuddyFactory();

    protected ArrayList<ClockTraceStateSet> satOneSolution(Map<Integer, Integer> bddVarToIndexInSolution) {
        BuDDyFactory.BuDDyBDD varSet = this.getBuddyFactory().one();
        for (Integer current : bddVarToIndexInSolution.keySet()) {
            varSet.andWith(this.getBuddyFactory().ithVar(current.intValue()));
        }
        BuDDyFactory.BuDDyBDD resBDD = this.semanticBdd.satOne();
        BuDDyFactory.BuDDyBDD.BDDIterator it = resBDD.iterator(varSet);
        int allClockSize = bddVarToIndexInSolution.size();
        ClockTraceStateSet tempF = new ClockTraceStateSet(allClockSize);
        ClockTraceStateSet tempE = new ClockTraceStateSet(allClockSize);
        if (it.hasNext()) {
            BuDDyFactory.BuDDyBDD v = (BuDDyFactory.BuDDyBDD)it.next();
            for (int bddVarNumber : bddVarToIndexInSolution.keySet()) {
                int index = this.getIndexInSolution(bddVarNumber);
                if (!v.and(this.getBuddyFactory().ithVar(bddVarNumber)).isZero()) {
                    tempF.set(index, ClockTraceState.T);
                    tempE.set(index, ClockTraceState.T);
                    continue;
                }
                tempF.set(index, ClockTraceState.F);
                tempE.set(index, ClockTraceState.F);
            }
        }
        varSet.free();
        resBDD.free();
        ArrayList<ClockTraceStateSet> res = new ArrayList<ClockTraceStateSet>();
        res.add(tempE);
        res.add(tempF);
        return res;
    }

    protected int chooseBooleanSolution(ArrayList<ClockTraceStateSet> allSolutionsF) {
        SimulationPolicyBase policy = this.getSimulationPolicy();
        int res = policy.getPolicySpecificSolution(allSolutionsF);
        return res;
    }

    public void applyLogicalStepByIndex(int indexOfStepToApply) throws SimulationException {
        this.fired = this.allClockTraceStateSet.get(indexOfStepToApply);
        this.enabled = this.allClockTraceStateSet.get(indexOfStepToApply);
        this.rewriteSemanticsAndPropagateDeath();
    }

    public abstract void dealWithBlockTransition();

    public abstract Set<RuntimeClock> getDeadClocks();

    public abstract void addDeadClock(RuntimeClock var1);

    public void addDeadClocks(Collection<RuntimeClock> clocks) {
        for (RuntimeClock clock : clocks) {
            this.addDeadClock(clock);
        }
    }

    public void registerNewDeadClock(RuntimeClock clock) {
        this.newDeadClocks.add(clock);
    }

    protected void rewriteSemanticsAndPropagateDeath() throws SimulationException {
        HashSet<RuntimeClock> deadClocks = new HashSet<RuntimeClock>(this.getDeadClocks());
        boolean deadClocksChanged = false;
        do {
            deadClocksChanged = false;
            this.rewriteExpressions();
            deadClocksChanged = this.propagateClockTermination();
            for (RuntimeClock clock : this.startQueue) {
                if (!(clock instanceof ICCSLConstraint)) continue;
                ((ICCSLConstraint)((Object)clock)).start(this.semanticHelper);
            }
            this.startQueue.clear();
            for (RuntimeClock clock : deadClocks) {
                if (clock.isDead()) continue;
                this.resurrectedClocks.add(clock);
            }
            for (RuntimeClock clock : this.newDeadClocks) {
                if (clock.isDead()) continue;
                this.resurrectedClocks.add(clock);
                for (RuntimeClock other : this.deathSolver.getEqualClocks(clock)) {
                    this.resurrectedClocks.add(other);
                }
            }
            this.newDeadClocks.removeAll(this.resurrectedClocks);
            deadClocksChanged = deadClocks.removeAll(this.resurrectedClocks) || deadClocksChanged;
            deadClocksChanged = deadClocks.addAll(this.newDeadClocks) || deadClocksChanged;
            this.deathSolver.clear();
            this.newDeadClocks.clear();
            this.resurrectedClocks.clear();
        } while (deadClocksChanged);
        this.addDeadClocks(deadClocks);
    }

    protected abstract void rewriteExpressions() throws SimulationException;

    protected boolean propagateClockTermination() throws SimulationException {
        boolean newDeadClocksFound = false;
        for (RuntimeClock clock : this.getDeadClocks()) {
            if (clock.isDead()) {
                this.semanticHelper.forceDeath(clock);
                continue;
            }
            this.resurrectedClocks.add(clock);
        }
        for (RuntimeClock clock : this.getDeadClocks()) {
            if (clock.isDead()) {
                this.semanticHelper.forceDeath(clock);
                continue;
            }
            this.resurrectedClocks.add(clock);
        }
        this.buildDeathExpressions();
        newDeadClocksFound = this.registerDeadClocks(this.deathSolver.getDeadClocks());
        int i = 0;
        while (i < this.resurrectedClocks.size()) {
            RuntimeClock clock = (RuntimeClock)this.resurrectedClocks.toArray()[i];
            for (RuntimeClock other : this.deathSolver.getEqualClocks(clock)) {
                this.resurrectedClocks.add(other);
            }
            ++i;
        }
        this.newDeadClocks.removeAll(this.resurrectedClocks);
        this.terminateDeadExpressions();
        return newDeadClocksFound;
    }

    protected abstract void buildDeathExpressions() throws SimulationException;

    protected boolean registerDeadClocks(List<RuntimeClock> list) throws SimulationException {
        boolean added = false;
        boolean res = false;
        for (RuntimeClock clock : list) {
            added = this.newDeadClocks.add(clock);
            if (added && clock instanceof ICCSLConstraint) {
                clock.terminate(this.updateHelper);
            }
            clock.setDead(true);
            boolean bl = res = res || added;
        }
        return res;
    }

    private void terminateDeadExpressions() throws SimulationException {
        for (RuntimeClock clock : this.newDeadClocks) {
            if (clock.isDead()) continue;
            clock.terminate(this.updateHelper);
        }
    }

    public ClockTraceState getClockEnabledState(RuntimeClock clock) {
        if (this.getUsedClocks().contains(clock)) {
            return this.enabled.get(this.getIndexInSolution(clock.bddVariableNumber));
        }
        return ClockTraceState.X;
    }

    public ClockTraceState getClockFiredState(RuntimeClock clock) {
        if (this.getUsedClocks().contains(clock)) {
            return this.fired.get(this.getIndexInSolution(clock.bddVariableNumber));
        }
        return ClockTraceState.F;
    }

    protected void registerClockFiring(RuntimeClock clock) {
        if (this.firedClocks.add(clock)) {
            ++clock.tickCount;
        }
    }

    public boolean clockHasFired(RuntimeClock clock) {
        return this.firedClocks.contains(clock);
    }

    public Set<RuntimeClock> getEnabledClocks() {
        return new HashSet<RuntimeClock>(this.enabledClocks);
    }

    public Set<RuntimeClock> getFiredClocks() {
        return new HashSet<RuntimeClock>(this.firedClocks);
    }

    public Set<RuntimeClock> getUsedClocks() {
        return this.usedClocks;
    }

    public BuDDyFactory.BuDDyBDD getSemanticBdd() {
        return this.semanticBdd;
    }

    public void setSemanticBdd(BuDDyFactory.BuDDyBDD semanticBdd) {
        this.semanticBdd = semanticBdd;
    }

    public ClockDeathSolver getClockDeathSolver() {
        return this.getDeathSolver();
    }

    public ClockDeathSolver getDeathSolver() {
        return this.deathSolver;
    }

    public AbstractSemanticHelper getSemanticHelper() {
        return this.semanticHelper;
    }

    public AbstractUpdateHelper getUpdateHelper() {
        return this.updateHelper;
    }

    public Set<RuntimeClock> getStartQueue() {
        return this.startQueue;
    }

    public void registerClockToStart(RuntimeClock clock) {
        this.startQueue.add(clock);
    }

    public abstract SimulationPolicyBase getSimulationPolicy();

    public Set<Integer> getAssertionVariables() {
        return this.assertionVariableNumbers;
    }

    public void addAssertionVariable(int varNum) {
        this.getAssertionVariables().add(varNum);
    }

    public boolean isAssertionViolated(AbstractRuntimeRelation relation) {
        if (!relation.isAssertion()) {
            return false;
        }
        Integer index = this.simulationEngine.getIndexInSolution(relation);
        return index == null ? false : this.fired.get(index.intValue()) == ClockTraceState.F;
    }
}

