/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.opsemanticsview.gen.k3;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import opsemanticsview.OperationalSemanticsView;
import opsemanticsview.OpsemanticsviewFactory;
import opsemanticsview.Rule;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gemoc.commons.eclipse.jdt.CallHierarchyHelper;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class K3StepExtractor {
    private final Set<IType> allClasses;
    private final EPackage extendedMetamodel;
    private final OperationalSemanticsView ecoreExtension;
    private final Map<IType, EClass> stepAspectsClassToAspectedClasses = new HashMap<IType, EClass>();
    private final Set<IMethod> allMethods = new HashSet<IMethod>();
    private final Set<IMethod> allk3Methods = new HashSet<IMethod>();
    private final Set<IMethod> allSuperMethods = new HashSet<IMethod>();
    private final Set<IMethod> stepFunctions = new HashSet<IMethod>();
    private final Set<IMethod> eventFunctions = new HashSet<IMethod>();
    private final Map<IMethod, Rule> functionToRule = new HashMap<IMethod, Rule>();
    private final Set<IType> inspectedClasses = new HashSet<IType>();
    private final Map<IMethod, IMethod> methodToK3Method = new HashMap<IMethod, IMethod>();
    private final Map<IMethod, IMethod> k3MethodToMethod = new HashMap<IMethod, IMethod>();
    private final Map<IMethod, IMethod> superMethodTok3Method = new HashMap<IMethod, IMethod>();
    private final Map<IMethod, Set<IMethod>> k3MethodToCalledMethods = new HashMap<IMethod, Set<IMethod>>();
    private final Map<IMethod, Set<IMethod>> methodToOverridingMethods = new HashMap<IMethod, Set<IMethod>>();
    private final Map<IMethod, Set<IMethod>> callGraph = new HashMap<IMethod, Set<IMethod>>();
    private final Map<IType, Set<IType>> classToSubClasses = new HashMap<IType, Set<IType>>();
    private final Map<IType, Set<IType>> classToSuperClasses = new HashMap<IType, Set<IType>>();

    public K3StepExtractor(Set<IType> aspects, String languageName, EPackage extendedMetamodel, OperationalSemanticsView inConstructionOperationalSemanticsView) {
        this.allClasses = aspects;
        this.extendedMetamodel = extendedMetamodel;
        this.ecoreExtension = inConstructionOperationalSemanticsView;
    }

    public void generate() {
        this.generateStepFromXtend(this.allClasses);
    }

    private Rule getRuleOfFunction(IMethod function) {
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _containsKey = this.functionToRule.containsKey(function);
        if (_containsKey) {
            return this.functionToRule.get(function);
        }
        Rule rule = OpsemanticsviewFactory.eINSTANCE.createRule();
        this.ecoreExtension.getRules().add((Object)rule);
        IType containingClass = function.getDeclaringType();
        rule.setContainingClass(this.stepAspectsClassToAspectedClasses.get(containingClass));
        EOperation candidate = null;
        EClass _containingClass = rule.getContainingClass();
        boolean bl = _notEquals = !Objects.equal((Object)_containingClass, null);
        if (_notEquals) {
            Functions.Function1 _function = o -> o.getName().equals(function.getElementName());
            candidate = (EOperation)IterableExtensions.findFirst((Iterable)rule.getContainingClass().getEAllOperations(), (Functions.Function1)_function);
        }
        boolean bl2 = _notEquals_1 = !Objects.equal(candidate, null);
        if (_notEquals_1) {
            rule.setOperation(candidate);
        } else {
            rule.setOperation(this.xtendFunctionToEOperation(function));
        }
        rule.setStepRule(this.stepFunctions.contains(function));
        rule.setMain(this.isMain(function));
        this.functionToRule.put(function, rule);
        return rule;
    }

    private void inspectForBigStep(IMethod function) {
        try {
            Set<IType> subtypes;
            boolean _notEquals_1;
            boolean _notEquals;
            Rule rule = this.getRuleOfFunction(function);
            Set<IMethod> calledFunctions = this.callGraph.get(function);
            boolean bl = _notEquals = !Objects.equal(calledFunctions, null);
            if (_notEquals) {
                for (IMethod calledFunction : calledFunctions) {
                    if (calledFunction == null) continue;
                    Rule calledRule = this.getRuleOfFunction(calledFunction);
                    rule.getCalledRules().add((Object)calledRule);
                }
            }
            boolean bl2 = _notEquals_1 = !Objects.equal(subtypes = this.classToSubClasses.get(function.getDeclaringType()), null);
            if (_notEquals_1) {
                for (IType t : subtypes) {
                    IMethod[] _methods;
                    IMethod[] iMethodArray = _methods = t.getMethods();
                    int n = _methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod f = iMethodArray[n2];
                        boolean _equals = f.getElementName().equals(function.getElementName());
                        if (_equals) {
                            Rule overridingRule = this.getRuleOfFunction(f);
                            rule.getOverridenBy().add((Object)overridingRule);
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private EOperation xtendFunctionToEOperation(IMethod function) {
        EOperation result = EcoreFactory.eINSTANCE.createEOperation();
        result.setName(function.getElementName());
        return result;
    }

    private void inspectClass(IType type) {
        try {
            boolean _not;
            boolean _contains = this.inspectedClasses.contains(type);
            boolean bl = _not = !_contains;
            if (_not) {
                Functions.Function1 _function = it -> it.getElementName().startsWith("_privk3_");
                Iterable typeK3Methods = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)type.getMethods())), (Functions.Function1)_function);
                Iterables.addAll(this.allk3Methods, (Iterable)typeK3Methods);
                Functions.Function1 _function_1 = m -> {
                    Functions.Function1 _function_2 = c -> c.getElementName().substring(8).equals(m.getElementName());
                    return IterableExtensions.exists((Iterable)typeK3Methods, (Functions.Function1)_function_2);
                };
                Iterable typeMethods = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)type.getMethods())), (Functions.Function1)_function_1);
                Iterables.addAll(this.allMethods, (Iterable)typeMethods);
                Consumer<IMethod> _function_2 = m -> {
                    Functions.Function1 _function_3 = c -> c.getElementName().substring(8).equals(m.getElementName());
                    IMethod k3m = (IMethod)IterableExtensions.findFirst((Iterable)typeK3Methods, (Functions.Function1)_function_3);
                    this.k3MethodToMethod.put(k3m, (IMethod)m);
                    this.methodToK3Method.put((IMethod)m, k3m);
                };
                typeMethods.forEach(_function_2);
                HashSet candidateSupers = new HashSet();
                Functions.Function1 _function_3 = it -> it.getElementName().startsWith("super_");
                Iterables.addAll(candidateSupers, (Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)type.getMethods())), (Functions.Function1)_function_3));
                Functions.Function1 _function_4 = c -> {
                    try {
                        Functions.Function1 _function_5 = m -> c.getElementName().substring(6).equals(m.getElementName());
                        return IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)type.getMethods())), (Functions.Function1)_function_5);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                Iterables.addAll(this.allSuperMethods, (Iterable)IterableExtensions.filter(candidateSupers, (Functions.Function1)_function_4));
                List<IAnnotation> _aspectAnnotations = this.getAspectAnnotations(type);
                for (IAnnotation a : _aspectAnnotations) {
                    EClass aspectedEClass = this.getAspectized(a);
                    this.stepAspectsClassToAspectedClasses.put(type, aspectedEClass);
                    Functions.Function1 _function_5 = it -> this.isStep((IMethod)it);
                    Iterables.addAll(this.stepFunctions, (Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)type.getMethods())), (Functions.Function1)_function_5));
                    Functions.Function1 _function_6 = it -> this.isEvent((IMethod)it);
                    Iterables.addAll(this.eventFunctions, (Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)type.getMethods())), (Functions.Function1)_function_6));
                }
                this.inspectedClasses.add(type);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void gatherCallsFromK3(IMethod function) {
        HashSet callingSites = CallHierarchyHelper.getCallLocationsOf((IMethod)function);
        Consumer<CallLocation> _function = cl -> {
            IMethod f = function;
            IMember member = cl.getMember();
            IMethod method = this.getContainingAspectMethod((IMethod)member);
            Functions.Function1 _function_1 = m -> Objects.equal((Object)m, (Object)method);
            Consumer<IMethod> _function_2 = m -> {
                Set<IMethod> calledMethods = this.k3MethodToCalledMethods.get(m);
                boolean _equals = Objects.equal(calledMethods, null);
                if (_equals) {
                    HashSet<IMethod> _hashSet = new HashSet<IMethod>();
                    calledMethods = _hashSet;
                    this.k3MethodToCalledMethods.put((IMethod)m, calledMethods);
                }
                calledMethods.add(f);
            };
            IterableExtensions.filter(this.allk3Methods, (Functions.Function1)_function_1).forEach(_function_2);
        };
        callingSites.forEach(_function);
    }

    private void gatherCallsFromSuper(IMethod function) {
        HashSet callingSites = CallHierarchyHelper.getCallLocationsOf((IMethod)function);
        Consumer<CallLocation> _function = cl -> {
            Functions.Function1 _function_1 = m -> {
                IMember _member = cl.getMember();
                return Objects.equal((Object)m, (Object)_member);
            };
            Consumer<IMethod> _function_2 = m -> this.superMethodTok3Method.put((IMethod)m, function);
            IterableExtensions.filter(this.allSuperMethods, (Functions.Function1)_function_1).forEach(_function_2);
        };
        callingSites.forEach(_function);
    }

    private void gatherOverridenMethods(IMethod method) {
        boolean _isOverride = this.isOverride(method);
        if (_isOverride) {
            boolean _notEquals;
            String methodName = method.getElementName();
            IType declaringType = method.getDeclaringType();
            Set<IType> superClasses = this.classToSuperClasses.get(declaringType);
            boolean bl = _notEquals = !Objects.equal(superClasses, null);
            if (_notEquals) {
                Consumer<IType> _function = c -> {
                    try {
                        boolean _notEquals_1;
                        Functions.Function1 _function_1 = m -> m.getElementName().equals(methodName);
                        IMethod overridenMethod = (IMethod)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)c.getMethods())), (Functions.Function1)_function_1);
                        boolean bl = _notEquals_1 = !Objects.equal((Object)overridenMethod, null);
                        if (_notEquals_1) {
                            Set<IMethod> overridingMethods = this.methodToOverridingMethods.get(overridenMethod);
                            boolean _equals = Objects.equal(overridingMethods, null);
                            if (_equals) {
                                HashSet<IMethod> _hashSet = new HashSet<IMethod>();
                                overridingMethods = _hashSet;
                                this.methodToOverridingMethods.put(overridenMethod, overridingMethods);
                            }
                            overridingMethods.add(method);
                        }
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                superClasses.forEach(_function);
            }
        }
    }

    private void generateStepFromXtend(Set<IType> files) {
        Consumer<IMethod> _function_7;
        Functions.Function0 _function_6;
        Consumer<IType> _function = c -> {
            Functions.Function1 _function_1 = t -> this.allClasses.contains(t);
            Set allSuperClasses = IterableExtensions.toSet((Iterable)IterableExtensions.filter(this.getAllSuperClasses((IType)c), (Functions.Function1)_function_1));
            this.classToSuperClasses.put((IType)c, allSuperClasses);
            Functions.Function1 _function_2 = t -> this.allClasses.contains(t);
            Set allSubClasses = IterableExtensions.toSet((Iterable)IterableExtensions.filter(this.getAllSubClasses((IType)c), (Functions.Function1)_function_2));
            this.classToSubClasses.put((IType)c, allSubClasses);
        };
        this.allClasses.forEach(_function);
        for (IType c2 : this.allClasses) {
            this.inspectClass(c2);
        }
        Consumer<IMethod> _function_1 = it -> this.gatherCallsFromSuper((IMethod)it);
        this.allk3Methods.forEach(_function_1);
        Consumer<IMethod> _function_2 = it -> this.gatherOverridenMethods((IMethod)it);
        this.allMethods.forEach(_function_2);
        Consumer<IMethod> _function_3 = it -> this.gatherCallsFromK3((IMethod)it);
        this.allMethods.forEach(_function_3);
        Consumer<IMethod> _function_4 = it -> this.gatherCallsFromK3((IMethod)it);
        this.allSuperMethods.forEach(_function_4);
        Consumer<IMethod> _function_5 = m -> {
            boolean _notEquals;
            IMethod k3m = this.methodToK3Method.get(m);
            boolean bl = _notEquals = !Objects.equal((Object)k3m, null);
            if (_notEquals) {
                boolean _notEquals_1;
                Set<IMethod> calledMethods = this.k3MethodToCalledMethods.get(k3m);
                boolean bl2 = _notEquals_1 = !Objects.equal(calledMethods, null);
                if (_notEquals_1) {
                    Consumer<IMethod> _function_6 = c_1 -> {
                        boolean _contains = this.allMethods.contains(c_1);
                        if (_contains) {
                            Set<IMethod> tmp = this.callGraph.get(m);
                            boolean _equals = Objects.equal(tmp, null);
                            if (_equals) {
                                HashSet<IMethod> _hashSet = new HashSet<IMethod>();
                                tmp = _hashSet;
                                this.callGraph.put((IMethod)m, tmp);
                            }
                            tmp.add((IMethod)c_1);
                        }
                    };
                    calledMethods.forEach(_function_6);
                }
            }
        };
        this.allMethods.forEach(_function_5);
        Functions.Function0 callGraphTotalLengthComputer = _function_6 = () -> {
            Functions.Function1 _function_7 = s -> s.size();
            Functions.Function2 _function_8 = (i1, i2) -> i1 + i2;
            return (Integer)IterableExtensions.reduce((Iterable)IterableExtensions.map(this.callGraph.values(), (Functions.Function1)_function_7), (Functions.Function2)_function_8);
        };
        Integer totalLength = (Integer)callGraphTotalLengthComputer.apply();
        int previousTotalLength = -1;
        while (totalLength > previousTotalLength) {
            _function_7 = m -> {
                boolean _notEquals;
                Set<IMethod> _xifexpression = null;
                Set<IMethod> _get = this.callGraph.get(m);
                boolean _equals = Objects.equal(_get, null);
                if (_equals) {
                    HashSet<IMethod> _xblockexpression = null;
                    HashSet<IMethod> tmp = new HashSet<IMethod>();
                    this.callGraph.put((IMethod)m, (Set<IMethod>)tmp);
                    _xblockexpression = tmp;
                    _xifexpression = _xblockexpression;
                } else {
                    _xifexpression = this.callGraph.get(m);
                }
                Set<IMethod> calledMethods = _xifexpression;
                Set<IMethod> overridingMethods = this.methodToOverridingMethods.get(m);
                boolean bl = _notEquals = !Objects.equal(overridingMethods, null);
                if (_notEquals) {
                    Consumer<IMethod> _function_8 = n -> {
                        boolean _notEquals_1;
                        Set<IMethod> calledByOverride = this.callGraph.get(n);
                        boolean bl = _notEquals_1 = !Objects.equal(calledByOverride, null);
                        if (_notEquals_1) {
                            calledMethods.addAll(calledByOverride);
                        }
                    };
                    overridingMethods.forEach(_function_8);
                }
            };
            this.allMethods.forEach(_function_7);
            previousTotalLength = totalLength;
            totalLength = (Integer)callGraphTotalLengthComputer.apply();
        }
        totalLength = (Integer)callGraphTotalLengthComputer.apply();
        previousTotalLength = -1;
        while (totalLength > previousTotalLength) {
            _function_7 = m -> {
                boolean _notEquals;
                Set<IMethod> calledMethods = this.callGraph.get(m);
                boolean bl = _notEquals = !Objects.equal(calledMethods, null);
                if (_notEquals) {
                    HashSet tmp = new HashSet();
                    Consumer<IMethod> _function_8 = n -> {
                        boolean _notEquals_1;
                        Set<IMethod> overridingMethods = this.methodToOverridingMethods.get(n);
                        boolean bl = _notEquals_1 = !Objects.equal(overridingMethods, null);
                        if (_notEquals_1) {
                            tmp.addAll(overridingMethods);
                        }
                    };
                    calledMethods.forEach(_function_8);
                    calledMethods.addAll(tmp);
                }
            };
            this.allMethods.forEach(_function_7);
            previousTotalLength = totalLength;
            totalLength = (Integer)callGraphTotalLengthComputer.apply();
        }
        _function_7 = m -> {
            Set<IMethod> calledMethods = this.callGraph.get(m);
            boolean _equals = Objects.equal(calledMethods, null);
            if (_equals) {
                HashSet<IMethod> _hashSet = new HashSet<IMethod>();
                calledMethods = _hashSet;
                this.callGraph.put((IMethod)m, calledMethods);
            }
            calledMethods.addAll(this.eventFunctions);
        };
        this.allMethods.forEach(_function_7);
        Consumer<IMethod> _function_8 = m -> {
            boolean _notEquals;
            IMethod k3m = this.methodToK3Method.get(m);
            boolean bl = _notEquals = !Objects.equal((Object)k3m, null);
            if (_notEquals) {
                boolean _notEquals_1;
                Set<IMethod> calledMethods = this.k3MethodToCalledMethods.get(k3m);
                boolean bl2 = _notEquals_1 = !Objects.equal(calledMethods, null);
                if (_notEquals_1) {
                    Consumer<IMethod> _function_9 = c_1 -> {
                        boolean _contains = this.allSuperMethods.contains(c_1);
                        if (_contains) {
                            IMethod actualMethod;
                            boolean _notEquals_2;
                            IMethod actualk3Method = this.superMethodTok3Method.get(c_1);
                            boolean bl = _notEquals_2 = !Objects.equal((Object)actualk3Method, null);
                            if (_notEquals_2 && !Objects.equal((Object)(actualMethod = this.k3MethodToMethod.get(actualk3Method)), null) && this.allMethods.contains(actualMethod)) {
                                Set<IMethod> tmp = this.callGraph.get(m);
                                boolean _equals = Objects.equal(tmp, null);
                                if (_equals) {
                                    HashSet<IMethod> _hashSet = new HashSet<IMethod>();
                                    tmp = _hashSet;
                                    this.callGraph.put((IMethod)m, tmp);
                                }
                                tmp.add(actualMethod);
                            }
                        }
                    };
                    calledMethods.forEach(_function_9);
                }
            }
        };
        this.allMethods.forEach(_function_8);
        InputOutput.println((Object)"Callgraph : \n\n");
        BiConsumer<IMethod, Set> _function_9 = (m, s) -> {
            String _elementName = m.getDeclaringType().getElementName();
            String _plus = String.valueOf(_elementName) + ".";
            String _elementName_1 = m.getElementName();
            String _plus_1 = String.valueOf(_plus) + _elementName_1;
            String _plus_2 = String.valueOf(_plus_1) + " : \n";
            Functions.Function1 _function_10 = n -> {
                String _elementName_2 = n.getDeclaringType().getElementName();
                String _plus_3 = String.valueOf(_elementName_2) + ".";
                String _elementName_3 = n.getElementName();
                return String.valueOf(_plus_3) + _elementName_3;
            };
            Functions.Function2 _function_11 = (s1, s2) -> String.valueOf(s1) + ", " + s2;
            String _reduce = (String)IterableExtensions.reduce((Iterable)IterableExtensions.map((Iterable)s, (Functions.Function1)_function_10), (Functions.Function2)_function_11);
            String _plus_3 = String.valueOf(_plus_2) + _reduce;
            String _plus_4 = String.valueOf(_plus_3) + "\n";
            InputOutput.println((Object)_plus_4);
        };
        this.callGraph.forEach(_function_9);
        for (IMethod function : this.allMethods) {
            this.inspectForBigStep(function);
        }
    }

    private List<IAnnotation> getAspectAnnotations(IType type) {
        try {
            boolean _isClass = type.isClass();
            if (_isClass) {
                Functions.Function1 _function = annot -> {
                    boolean _xblockexpression = false;
                    String name = annot.getElementName();
                    int lastDotIndex = name.lastIndexOf(".");
                    String simpleName = name;
                    if (lastDotIndex != -1) {
                        simpleName = name.substring(lastDotIndex + 1);
                    }
                    _xblockexpression = simpleName.equals("Aspect");
                    return _xblockexpression;
                };
                return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)type.getAnnotations())), (Functions.Function1)_function));
            }
            return new ArrayList<IAnnotation>();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private boolean testAnnotation(IMethod method, String annotationSimpleName) {
        try {
            Functions.Function1 _function = annot -> {
                String name = annot.getElementName();
                int lastDotIndex = name.lastIndexOf(".");
                String simpleName = name;
                if (lastDotIndex != -1) {
                    simpleName = name.substring(lastDotIndex + 1);
                }
                return simpleName.equals(annotationSimpleName);
            };
            return IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)method.getAnnotations())), (Functions.Function1)_function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private boolean isStep(IMethod method) {
        return this.testAnnotation(method, "Step");
    }

    private boolean isEvent(IMethod method) {
        try {
            boolean _xblockexpression = false;
            Functions.Function1 _function = a -> {
                String name = a.getElementName();
                int lastDotIndex = name.lastIndexOf(".");
                String simpleName = name;
                if (lastDotIndex != -1) {
                    simpleName = name.substring(lastDotIndex + 1);
                }
                return Objects.equal((Object)simpleName, (Object)"Step");
            };
            IAnnotation annotation = (IAnnotation)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)method.getAnnotations())), (Functions.Function1)_function);
            _xblockexpression = !Objects.equal((Object)annotation, null) && IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)annotation.getMemberValuePairs())), p -> Objects.equal((Object)p.getMemberName(), (Object)"eventHandler") && p.getValue() instanceof Boolean && (Boolean)p.getValue() != false);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private boolean isOverride(IMethod method) {
        return this.testAnnotation(method, "OverrideAspectMethod");
    }

    private boolean isMain(IMethod method) {
        return this.testAnnotation(method, "Main");
    }

    private Set<IType> getAllSubClasses(IType type) {
        try {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            ITypeHierarchy hierarchy = type.newTypeHierarchy((IProgressMonitor)_nullProgressMonitor);
            return IterableExtensions.toSet((Iterable)((Iterable)Conversions.doWrapArray((Object)hierarchy.getAllSubtypes(type))));
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Set<IType> getAllSuperClasses(IType type) {
        try {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            ITypeHierarchy hierarchy = type.newTypeHierarchy((IProgressMonitor)_nullProgressMonitor);
            return IterableExtensions.toSet((Iterable)((Iterable)Conversions.doWrapArray((Object)hierarchy.getAllSuperclasses(type))));
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private EClass getAspectized(IAnnotation annot) {
        try {
            Functions.Function1 _function = p -> {
                String _memberName = p.getMemberName();
                return Objects.equal((Object)_memberName, (Object)"className");
            };
            Object _value = ((IMemberValuePair)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)annot.getMemberValuePairs())), (Functions.Function1)_function)).getValue();
            String aspectedClassName = (String)_value;
            Functions.Function1 _function_1 = c1 -> aspectedClassName.equals(c1.getName());
            return (EClass)IteratorExtensions.findFirst((Iterator)Iterators.filter((Iterator)this.extendedMetamodel.eAllContents(), EClass.class), (Functions.Function1)_function_1);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private IMethod getContainingAspectMethod(IMethod function) {
        IType container = function.getDeclaringType();
        boolean _contains = this.allClasses.contains(container);
        if (_contains) {
            return function;
        }
        IJavaElement parent = function.getParent();
        while (parent != null) {
            if (parent instanceof IMethod) {
                return this.getContainingAspectMethod((IMethod)parent);
            }
            parent = parent.getParent();
        }
        return null;
    }
}

