/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.compiler.codemodel;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class MemberVariable {
    private String name;
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private List<String> modifiers = new ArrayList<String>();
    private String typeName;
    private String initializer;

    public MemberVariable(String name, String typeName) {
        this.name = name;
        this.typeName = typeName;
    }

    public String getName() {
        return this.name;
    }

    public void addModifier(String modifier) {
        this.modifiers.add(modifier);
    }

    public void setInitializer(String init) {
        this.initializer = init;
    }

    public void generate(StringBuilder fileContent, int indentation) {
        for (Annotation annotation : this.annotations) {
            this.addIndentation(indentation, fileContent);
            fileContent.append(String.valueOf(annotation.toString()) + "\n");
        }
        this.addIndentation(indentation, fileContent);
        for (String modifier : this.modifiers) {
            fileContent.append(String.valueOf(modifier) + " ");
        }
        fileContent.append(String.valueOf(this.typeName) + " " + this.name);
        if (this.initializer != null && !this.initializer.isEmpty()) {
            fileContent.append(" = " + this.initializer);
        }
        fileContent.append(";\n");
    }

    private void addIndentation(int indent, StringBuilder content) {
        int i = 0;
        while (i < indent) {
            content.append(' ');
            ++i;
        }
    }
}

