/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.k3.ui.wizards;

import fr.inria.diverse.k3.ui.Activator;
import fr.inria.diverse.k3.ui.wizards.Messages;
import fr.inria.diverse.k3.ui.wizards.XtendK3CreatorUtil;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.CompletionContextRequestor;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.internal.ui.wizards.SuperInterfaceSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.xtend.ide.wizards.AbstractNewXtendElementWizardPage;
import org.eclipse.xtend.ide.wizards.XtendTypeCreatorUtil;

public class NewXtendClassK3AspectWizardPage
extends AbstractNewXtendElementWizardPage {
    private StringButtonDialogField fAspectClassDialogField;
    private StubTypeContext fAspectClassStubTypeContext;
    protected Button btnCheckBoxLimitToEMF;

    public NewXtendClassK3AspectWizardPage() {
        super(1, "K3 Aspect - Xtend Class");
        this.setTitle("K3 Aspect - Xtend Class");
        this.setDescription(Messages.XTEND_CLASS_K3_ASPECT_WIZARD_DESCRIPTION);
        AspectFieldsAdapter adapter = new AspectFieldsAdapter();
        this.fAspectClassDialogField = new StringButtonDialogField((IStringButtonAdapter)adapter);
        this.fAspectClassDialogField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fAspectClassDialogField.setLabelText(Messages.ASPECT_DIALOG_LABEL);
        this.fAspectClassDialogField.setButtonLabel(Messages.ASPECT_DIALOG_BUTTON_LABEL);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createCommonControls(parent);
        this.createOptionControls(composite, 4);
        this.createAspectClassControls(composite, 4);
        this.createSuperClassControls(composite, 4);
        this.createSuperInterfacesControls(composite, 4);
        this.setControl((Control)composite);
    }

    protected void createAspectClassControls(Composite composite, int nColumns) {
        this.fAspectClassDialogField.doFillIntoGrid(composite, nColumns);
        Text text = this.fAspectClassDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
        BidiUtils.applyBidiProcessing((Text)text, (String)"java");
        JavaTypeCompletionProcessor aspectClassCompletionProcessor = new JavaTypeCompletionProcessor(false, false, true);
        aspectClassCompletionProcessor.setCompletionContextRequestor(new CompletionContextRequestor(){

            public StubTypeContext getStubTypeContext() {
                return NewXtendClassK3AspectWizardPage.this.getAspectClassStubTypeContext();
            }
        });
        ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)aspectClassCompletionProcessor);
        TextFieldNavigationHandler.install((Text)text);
    }

    protected void createOptionControls(Composite composite, int nColumns) {
        this.btnCheckBoxLimitToEMF = new Button(composite, 32);
        this.btnCheckBoxLimitToEMF.setText("Limit Aspectized classes to EMF Interfaces");
        this.btnCheckBoxLimitToEMF.setSelection(true);
        GridData gd = new GridData(256);
        gd.horizontalSpan = nColumns;
        this.btnCheckBoxLimitToEMF.setLayoutData((Object)gd);
    }

    protected void init(IStructuredSelection selection) {
        super.init(selection);
        if (this.getTypeName() == null || this.getTypeName().isEmpty()) {
            this.setTypeName("MyAspect", true);
        }
    }

    private StubTypeContext getAspectClassStubTypeContext() {
        if (this.fAspectClassStubTypeContext == null) {
            this.fAspectClassStubTypeContext = new StubTypeContext(null, null, null);
        }
        return this.fAspectClassStubTypeContext;
    }

    protected void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(status);
    }

    protected String getPackageDeclaration(String lineSperator) {
        return XtendTypeCreatorUtil.createPackageDeclaration((String)this.getTypeName(), (IPackageFragment)this.getPackageFragment(), (String)this.getSuperClass(), (List)this.getSuperInterfaces(), (String)lineSperator);
    }

    protected String getTypeContent(String indentation, String lineSperator) {
        return XtendK3CreatorUtil.createAspectClassContent(this.getTypeName(), this.getAspectizedClassName(), this.getSuperClass(), this.getSuperInterfaces(), indentation, lineSperator);
    }

    protected String getElementCreationErrorMessage() {
        return Messages.ERROR_CREATING_CLASS;
    }

    public String getAspectizedClassName() {
        return this.fAspectClassDialogField.getText();
    }

    protected IType chooseAspectClass() {
        IJavaProject project = this.getJavaProject();
        if (project == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{project};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        TypeSelectionExtension selectionExtention = new TypeSelectionExtension(){

            public ISelectionStatusValidator getSelectionValidator() {
                return new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        if ((this).NewXtendClassK3AspectWizardPage.this.btnCheckBoxLimitToEMF.getSelection() && selection[0] instanceof IType) {
                            IType iType = (IType)selection[0];
                            try {
                                ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy(null);
                                IType[] iTypeArray = iTypeHierarchy.getAllInterfaces();
                                int n = iTypeArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IType interfac = iTypeArray[n2];
                                    if (interfac.getFullyQualifiedName().equals("org.eclipse.emf.ecore.EObject")) {
                                        return Status.OK_STATUS;
                                    }
                                    ++n2;
                                }
                                return new Status(4, JavaPlugin.getPluginId(), 0, "Not an EMF EObject", null);
                            }
                            catch (JavaModelException e) {
                                Activator.logErrorMessage(e.getMessage(), e);
                                return Status.OK_STATUS;
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
            }
        };
        FilteredTypesSelectionDialog dialog = this.btnCheckBoxLimitToEMF.getSelection() ? new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), scope, 6, selectionExtention) : new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), scope, 10, selectionExtention);
        dialog.setTitle(Messages.NewTypeWizardPage_AspectClassDialog_title);
        dialog.setMessage(Messages.NewTypeWizardPage_AspectClassDialog_message);
        dialog.setInitialPattern(this.getAspectizedClassName());
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    private class AspectFieldsAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private AspectFieldsAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            IType type;
            if (field == NewXtendClassK3AspectWizardPage.this.fAspectClassDialogField && (type = NewXtendClassK3AspectWizardPage.this.chooseAspectClass()) != null) {
                NewXtendClassK3AspectWizardPage.this.fAspectClassDialogField.setText(SuperInterfaceSelectionDialog.getNameWithTypeParameters((IType)type));
            }
        }

        public void dialogFieldChanged(DialogField field) {
        }
    }
}

