/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.explorer;

import fr.inria.aoste.timesquare.ccslkernel.explorer.CCSLConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.explorer.StateSpace;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.solver.CCSLKernelSolver;
import fr.inria.aoste.timesquare.ccslkernel.solver.StepExecutor;
import fr.inria.aoste.timesquare.ccslkernel.solver.statistics.SolverRuntimeStats;
import fr.inria.aoste.timesquare.simulationpolicy.bitset.ClockTraceStateSet;
import grph.GrphWebNotifications;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import toools.io.file.RegularFile;

public class CCSLKernelExplorer
extends CCSLKernelSolver {
    protected IProgressMonitor monitor = null;

    public CCSLKernelExplorer(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public StateSpace explore(boolean writeTempsDotFile) throws SimulationException {
        CCSLConstraintState initialState;
        if (CCSLKernelSolver.runtimeStatsCollection) {
            SolverRuntimeStats.enterMethod(String.valueOf(this.getClass().getName()) + ".explore");
        }
        GrphWebNotifications.enabled = false;
        StateSpace stateSpace = new StateSpace();
        StepExecutor stepExecutor = new StepExecutor(this);
        stepExecutor.inSimulationMode = false;
        ArrayList<CCSLConstraintState> statesToExplore = new ArrayList<CCSLConstraintState>();
        stateSpace.initialState = initialState = this.getCurrentState();
        stateSpace.addVertex(initialState);
        statesToExplore.add(initialState);
        System.out.println("Exploration of the state space started\n");
        System.out.flush();
        int j = 0;
        while (j < statesToExplore.size()) {
            if (this.monitor.isCanceled()) {
                stepExecutor.clearStepData();
                stepExecutor.freeAll();
                stepExecutor.clearFiredClock();
                stepExecutor = null;
                return null;
            }
            this.monitor.worked(j / statesToExplore.size());
            if (writeTempsDotFile) {
                RegularFile dotRegFile = new RegularFile("tempStateSpace.dot");
                dotRegFile.setContentAsASCII(stateSpace.getGrph().toDot());
            }
            int stateToExploreSize = statesToExplore.size();
            System.out.println(String.valueOf(stateToExploreSize - j) + " states to explore");
            CCSLConstraintState previousState = new CCSLConstraintState();
            previousState = (CCSLConstraintState)statesToExplore.get(j);
            this.setCurrentState(previousState);
            stepExecutor.clearStepData();
            stepExecutor.stepPreHook();
            stepExecutor.computePossibleClockStates();
            ArrayList<ClockTraceStateSet> allTransitionsFromCurrentState = stepExecutor.getAllBDDSolutions();
            int sizeSoluces = allTransitionsFromCurrentState.size();
            int i = sizeSoluces - 1;
            while (i >= 0) {
                block8: {
                    stepExecutor.clearFiredClock();
                    stepExecutor.computePossibleClockStates();
                    ArrayList<String> currentTransition = stepExecutor.lightApplyLogicalStepByIndex(i);
                    CCSLConstraintState currentState = this.getCurrentState();
                    boolean stateExists = false;
                    for (CCSLConstraintState existingState : stateSpace.getVertices()) {
                        if (!currentState.equals(existingState)) continue;
                        stateExists = true;
                        stateSpace.addDirectedSimpleEdge(previousState, new StringBuffer(currentTransition.toString()), existingState);
                        this.setCurrentState(previousState);
                        break block8;
                    }
                    if (!stateExists) {
                        statesToExplore.add(currentState);
                        stateSpace.addVertex(currentState);
                        stateSpace.addDirectedSimpleEdge(previousState, new StringBuffer(currentTransition.toString()), currentState);
                        this.setCurrentState(previousState);
                    }
                }
                --i;
            }
            stepExecutor.clearStepData();
            stepExecutor.freeAll();
            ++j;
        }
        stepExecutor.clearFiredClock();
        stepExecutor = null;
        if (CCSLKernelSolver.runtimeStatsCollection) {
            SolverRuntimeStats.leaveMethod(String.valueOf(this.getClass().getName()) + ".explore");
        }
        System.out.println("******************************************************************************\n state space completed: " + stateSpace.getGrph().getVertices().size() + " states and " + stateSpace.getGrph().getEdges().size() + " transitions \n******************************************************************************\n");
        return stateSpace;
    }
}

