/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver;

import fr.inria.aoste.timesquare.ccslkernel.explorer.CCSLConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.Element;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.PrimitiveElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.SequenceElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.Block;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.BlockTransition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.BooleanExpression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockConstraintSystem;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.AbstractEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Expression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExpressionDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExternalExpressionDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExternalRelationDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.Coincidence;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.KernelRelationDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelationDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.Clock;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.NamedElement;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.AbstractConcreteMapping;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiatedElement;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiationPath;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiationTree;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.UnfoldModel;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.UnfoldingException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.IRuntimeContainer;
import fr.inria.aoste.timesquare.ccslkernel.runtime.SerializedConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.BDDHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.relations.AbstractRuntimeRelation;
import fr.inria.aoste.timesquare.ccslkernel.solver.ConditionalCase;
import fr.inria.aoste.timesquare.ccslkernel.solver.EqualitySolver;
import fr.inria.aoste.timesquare.ccslkernel.solver.ISolverConcrete;
import fr.inria.aoste.timesquare.ccslkernel.solver.ISolverElement;
import fr.inria.aoste.timesquare.ccslkernel.solver.ImplicitClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.SolverElement;
import fr.inria.aoste.timesquare.ccslkernel.solver.SolverKernelExpressionBuilder;
import fr.inria.aoste.timesquare.ccslkernel.solver.SolverPrimitiveElement;
import fr.inria.aoste.timesquare.ccslkernel.solver.StepExecutor;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.BasicType.SolverSequenceElement;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.CCSLModel.SolverBlock;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.CCSLModel.SolverBlockTransition;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.SolverClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.exception.SolverException;
import fr.inria.aoste.timesquare.ccslkernel.solver.exception.SolverWrappedException;
import fr.inria.aoste.timesquare.ccslkernel.solver.exception.UnboundAbstract;
import fr.inria.aoste.timesquare.ccslkernel.solver.expression.AbstractWrappedExpression;
import fr.inria.aoste.timesquare.ccslkernel.solver.expression.ConditionalExpression;
import fr.inria.aoste.timesquare.ccslkernel.solver.expression.RecursiveTailCallJump;
import fr.inria.aoste.timesquare.ccslkernel.solver.expression.SolverExpression;
import fr.inria.aoste.timesquare.ccslkernel.solver.expression.SolverExpressionWrapper;
import fr.inria.aoste.timesquare.ccslkernel.solver.expression.UserDefinedExpression;
import fr.inria.aoste.timesquare.ccslkernel.solver.extension.FactoryManager;
import fr.inria.aoste.timesquare.ccslkernel.solver.extension.ISolverExpressionFactory;
import fr.inria.aoste.timesquare.ccslkernel.solver.extension.ISolverRelationFactory;
import fr.inria.aoste.timesquare.ccslkernel.solver.helpers.SemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.solver.priorities.PrioritySolver;
import fr.inria.aoste.timesquare.ccslkernel.solver.priorities.SolverPrioritySpecification;
import fr.inria.aoste.timesquare.ccslkernel.solver.priorities.model.ccslpriority.PrioritySpecification;
import fr.inria.aoste.timesquare.ccslkernel.solver.relation.AbstractWrappedRelation;
import fr.inria.aoste.timesquare.ccslkernel.solver.relation.ConditionalRelation;
import fr.inria.aoste.timesquare.ccslkernel.solver.relation.SolverRelation;
import fr.inria.aoste.timesquare.ccslkernel.solver.relation.SolverRelationWrapper;
import fr.inria.aoste.timesquare.ccslkernel.solver.relation.kernel.SolverKernelRelationDelegate;
import fr.inria.aoste.timesquare.ccslkernel.solver.relation.kernel.SolverRuntimeRelationFactory;
import fr.inria.aoste.timesquare.ccslkernel.solver.statistics.SolverRuntimeStats;
import fr.inria.aoste.timesquare.simulationpolicy.SimulationPolicyBase;
import fr.inria.aoste.trace.LogicalStep;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.Reference;
import fr.inria.aoste.trace.TraceFactory;
import fr.inria.aoste.trace.TracePackage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.javabdd.BuDDyFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class CCSLKernelSolver {
    public static boolean runtimeStatsCollection = false;
    public static boolean clockEqualityOptimize = true;
    public BuDDyFactory BuDDyFactory;
    public Map<Integer, SolverClock> bddVarToClock;
    public Map<Integer, SolverRelation> bddAssertVarToRelation;
    public ArrayList<SolverRelation> assertions;
    public Map<SolverRelation, Integer> assertionsToIndexInSolution;
    protected Map<SolverClock, Integer> clockToIndexInSolution;
    protected Map<Integer, Integer> bddVarToIndexInSolution;
    public BDDHelper bddHelper;
    private EqualitySolver clockEqualityRegister;
    private List<SolverBlock> topBlocks = new ArrayList<SolverBlock>();
    private ResourceSet resourceSet;
    private SolverPrioritySpecification _priorities = null;
    private PrioritySolver _prioSolver = null;
    private List<RuntimeClock> allDiscreteClocks;
    private List<SolverClock> allDenseClocks;
    private List<ImplicitClock> allImplicitClocks;
    protected UnfoldModel unfoldModel = null;
    private HashMap<Block, SolverBlock> blocksMap = new HashMap();
    private ArrayList<SolverBlockTransition> allBlockTransitions = new ArrayList();
    private int solutionIndexCounter = 0;
    public boolean keepBDDSteps = false;
    private StepExecutor currentStepExecutor = null;
    protected InstantiationTree<ISolverConcrete> concreteInstantiationTree;
    protected InstantiationTree<SolverClock> clockInstantiationTree;
    protected InstantiationTree<SolverElement> elementInstantiationTree;
    private SimulationPolicyBase policy;
    private Set<RuntimeClock> deadClocks = new HashSet<RuntimeClock>();
    private List<Reference> traceReferences;
    private TraceFactory traceFactory;

    public EqualitySolver getClockEqualityRegister() {
        return this.clockEqualityRegister;
    }

    public void revertForceClockEffect() throws SimulationException {
        if (this.currentStepExecutor.semanticBdd_beforeClockForcing == null) {
            return;
        }
        this.currentStepExecutor.semanticBdd = this.currentStepExecutor.semanticBdd_beforeClockForcing;
        this.currentStepExecutor.semanticBdd_beforeClockForcing = null;
    }

    protected void saveBDDBeforeClockForcing() {
        this.BuDDyFactory.save("saveBDD.txt", this.currentStepExecutor.semanticBdd);
        this.currentStepExecutor.semanticBdd_beforeClockForcing = this.BuDDyFactory.load("saveBDD.txt");
    }

    public boolean forceClockPresence(SolverClock c) {
        if (this.currentStepExecutor.semanticBdd_beforeClockForcing == null) {
            this.saveBDDBeforeClockForcing();
        }
        this.currentStepExecutor.getSemanticBdd().andWith(this.BuDDyFactory.ithVar(c.bddVariableNumber));
        return true;
    }

    public boolean hasSolution() {
        return !this.currentStepExecutor.semanticBdd.isZero();
    }

    public boolean forceClockAbscence(SolverClock c) {
        if (this.currentStepExecutor == null) {
            this.currentStepExecutor = new StepExecutor(this);
        }
        if (this.currentStepExecutor.semanticBdd_beforeClockForcing == null) {
            this.saveBDDBeforeClockForcing();
        }
        this.currentStepExecutor.getSemanticBdd().andWith(this.BuDDyFactory.nithVar(c.bddVariableNumber));
        return true;
    }

    public boolean addClockCoincidence(SolverClock c1, SolverClock c2) {
        if (this.currentStepExecutor == null) {
            this.currentStepExecutor = new StepExecutor(this);
        }
        if (this.currentStepExecutor.semanticBdd_beforeClockForcing == null) {
            this.saveBDDBeforeClockForcing();
        }
        BuDDyFactory.BuDDyBDD semantic = this.currentStepExecutor.getSemanticHelper().createEqual((RuntimeClock)c1, (RuntimeClock)c2);
        this.currentStepExecutor.getSemanticHelper().semanticBDDAnd(semantic);
        return true;
    }

    public CCSLKernelSolver() {
        this.clockInstantiationTree = new InstantiationTree();
        this.concreteInstantiationTree = new InstantiationTree();
        this.elementInstantiationTree = new InstantiationTree();
        this.bddVarToClock = new HashMap<Integer, SolverClock>();
        this.bddAssertVarToRelation = new HashMap<Integer, SolverRelation>();
        this.assertions = new ArrayList();
        this.assertionsToIndexInSolution = new HashMap<SolverRelation, Integer>();
        this.clockToIndexInSolution = new HashMap<SolverClock, Integer>();
        this.bddVarToIndexInSolution = new HashMap<Integer, Integer>();
        this.BuDDyFactory = BDDHelper.createFactory();
        this.bddHelper = new BDDHelper(this.BuDDyFactory);
        if (clockEqualityOptimize) {
            this.clockEqualityRegister = new EqualitySolver();
        }
        this.initTrace();
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public SolverPrioritySpecification getPrioritySpecification() {
        return this._priorities;
    }

    public void loadPriorityModel(Resource resource) throws IOException, UnfoldingException, SolverException {
        try {
            this._priorities = new SolverPrioritySpecification(resource, this);
        }
        catch (RuntimeException e) {
            this._priorities = null;
        }
    }

    public void loadPriorityModel(PrioritySpecification model) throws IOException, UnfoldingException, SolverException {
        this._priorities = new SolverPrioritySpecification(model, this);
    }

    public UnfoldModel getUnfoldModel() {
        return this.unfoldModel;
    }

    public ClockConstraintSystem getModel() {
        if (this.unfoldModel == null) {
            return null;
        }
        return this.unfoldModel.getModel();
    }

    public void loadModel(Resource resource) throws IOException, UnfoldingException, SolverException {
        this.resourceSet = resource.getResourceSet();
        this.unfoldModel = UnfoldModel.unfoldModels((ResourceSet)this.resourceSet);
        this.buildBlockHierarchies(this.unfoldModel);
        this.postLoadModel();
    }

    public void loadCoordinationModel(Resource resource) throws IOException, UnfoldingException, SolverException {
        this.resourceSet = resource.getResourceSet();
        UnfoldModel.isCoordinationLoad = true;
        this.unfoldModel = UnfoldModel.unfoldModels((ResourceSet)this.resourceSet);
        this.buildBlockHierarchies(this.unfoldModel);
        this.postLoadModel();
    }

    private void buildBlockHierarchies(UnfoldModel unfoldModel) {
        for (UnfoldModel imported : unfoldModel.getImportedModels()) {
            this.buildBlockHierarchies(imported);
        }
        SolverBlock entryBlock = this.buildBlockHierarchy(unfoldModel.getModel().getSuperBlock());
        this.topBlocks.add(entryBlock);
    }

    private void postLoadModel() throws SolverException {
        this.initializeConcreteElements(this.unfoldModel);
        this.createImplicitClocks(this.unfoldModel);
        this.buildSolverRelationsAndExpressions(this.unfoldModel);
        this.allDiscreteClocks = this.collectDiscreteClocks();
        this.allDenseClocks = this.collectDenseClocks();
        this.allImplicitClocks = this.collectImplicitClocks();
        this.allocateBDDVariablesToClocks();
        this.allocateBDDVariablesToAssertions();
    }

    public ArrayList<SolverBlockTransition> getAllBlockTransitions() {
        return this.allBlockTransitions;
    }

    private SolverBlock buildBlockHierarchy(Block block) {
        SolverBlock sBlock = new SolverBlock();
        sBlock.setModelBlock(block);
        this.blocksMap.put(block, sBlock);
        for (Block subBlock : block.getSubBlock()) {
            sBlock.getSubBlocks().add(this.buildBlockHierarchy(subBlock));
        }
        return sBlock;
    }

    public SolverBlock getSolverBlock(Block block) {
        return this.blocksMap.get(block);
    }

    public SolverBlock findSolverBlock(List<NamedElement> blockStack) {
        return this.blocksMap.get(blockStack.get(blockStack.size() - 1));
    }

    public void initSimulation() throws SimulationException {
        if (runtimeStatsCollection) {
            SolverRuntimeStats.clearStats();
        }
        for (SolverBlock entryBlock : this.topBlocks) {
            this.initBlock(entryBlock);
        }
        if (this._priorities != null && this._priorities.getPriorityRelations().size() > 0) {
            this._prioSolver = new PrioritySolver(this.BuDDyFactory, this._priorities, this);
            this._prioSolver.propagatePriority();
        }
    }

    public void endSimulation() {
        BDDHelper.terminateBDDUsage();
        if (runtimeStatsCollection) {
            SolverRuntimeStats.print();
        }
    }

    private void initBlock(SolverBlock block) throws SimulationException {
        block.start(new SemanticHelper(this, null));
        if (block.getModelBlock().getInitialBlock() != null) {
            this.initBlock(this.getSolverBlock(block.getModelBlock().getInitialBlock()));
        } else {
            for (SolverBlock sub : block.getSubBlocks()) {
                this.initBlock(sub);
            }
        }
        for (BlockTransition t : block.getModelBlock().getBlockTransitions()) {
            SolverBlockTransition st = new SolverBlockTransition(t, this);
            this.allBlockTransitions.add(st);
        }
    }

    public SolverClock findClock(String clockName) {
        for (SolverBlock entryBlock : this.topBlocks) {
            SolverClock res = this.findClockInBlock(clockName, entryBlock);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public SolverClock findClockByPath(String qualifiedPath) {
        return this.findClockByPath(qualifiedPath, "::");
    }

    public SolverClock findClockByPath(String qualifiedPath, String separator) {
        return (SolverClock)this.getClockInstantiationTree().lookupInstance(qualifiedPath, separator);
    }

    private SolverClock findClockInBlock(String clockName, SolverBlock block) {
        for (SolverClock solverClock : block.getConcreteClocks()) {
            if (!solverClock.getModelClock().getName().equals(clockName)) continue;
            return solverClock;
        }
        for (ImplicitClock implicitClock : block.getImplicitClocks()) {
            if (!implicitClock.getName().equals(clockName)) continue;
            return implicitClock;
        }
        for (SolverBlock solverBlock : block.getSubBlocks()) {
            SolverClock res = this.findClockInBlock(clockName, solverBlock);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public Element findElementByPath(String qualifiedPath) {
        return this.findElementByPath(qualifiedPath, "::");
    }

    public Element findElementByPath(String qualifiedPath, String separator) {
        SolverElement solverElement = (SolverElement)this.getElementInstantiationTree().lookupInstance(qualifiedPath, separator);
        if (solverElement == null) {
            return null;
        }
        return solverElement.getModelElement();
    }

    private void initializeConcreteElements(UnfoldModel unfoldModel) {
        if (unfoldModel != null) {
            for (InstantiatedElement element : unfoldModel.getInstantiationTree().lookupInstances(null)) {
                Element last;
                SolverElement newElement;
                if (element.isClock()) {
                    SolverClock newClock = this.createSolverClock(element);
                    if (element.isTopLevel()) {
                        EObject container = element.getInstantiationPath().getLast().eContainer();
                        if (element.getUseCount() == 0L) {
                            System.out.println("Clock " + element.getQualifiedName() + " is not used.");
                        }
                        if (!(container instanceof Block)) continue;
                        SolverBlock sBlock = this.getSolverBlock((Block)container);
                        if (newClock.isDense()) {
                            sBlock.getDenseClocks().add(newClock);
                            continue;
                        }
                        sBlock.getConcreteClocks().add(newClock);
                        continue;
                    }
                    InstantiationPath blocks = element.getBlockStack();
                    Block last2 = (Block)blocks.get(blocks.size() - 1);
                    if (last2 == null) continue;
                    SolverBlock sBlock = this.getSolverBlock(last2);
                    if (newClock.isDense()) {
                        sBlock.getDenseClocks().add(newClock);
                        continue;
                    }
                    sBlock.getConcreteClocks().add(newClock);
                    continue;
                }
                if (element.isPrimitiveElement()) {
                    InstantiationPath path = element.getInstantiationPath();
                    newElement = new SolverPrimitiveElement(element);
                    this.elementInstantiationTree.storeInstance(path, (Object)newElement);
                    continue;
                }
                if (!element.isElement() || !((last = (Element)element.getInstantiationPath().getLast()) instanceof SequenceElement)) continue;
                newElement = new SolverSequenceElement((SequenceElement)last, element);
                this.elementInstantiationTree.storeInstance(element.getInstantiationPath(), (Object)newElement);
            }
        }
    }

    private void createImplicitClocks(UnfoldModel unfoldModel) {
        for (InstantiatedElement element : unfoldModel.getInstantiationTree().lookupInstances(null)) {
            if (!element.isExpression()) continue;
            ImplicitClock iClock = this.createImplicitClock(element);
            InstantiationPath blocks = element.getBlockStack();
            Block last = (Block)blocks.get(blocks.size() - 1);
            if (last == null) continue;
            SolverBlock sBlock = this.getSolverBlock(last);
            sBlock.getImplicitClocks().add(iClock);
        }
    }

    public ArrayList<EObject> getDiscreteClockList() {
        ArrayList<EObject> clockList = new ArrayList<EObject>();
        for (RuntimeClock sclock : this.getAllDiscreteClocks()) {
            clockList.add((EObject)((SolverClock)sclock).getModelClock());
        }
        return clockList;
    }

    public List<RuntimeClock> getAllDiscreteClocks() {
        return this.allDiscreteClocks;
    }

    private List<RuntimeClock> collectDiscreteClocks() {
        ArrayList<RuntimeClock> res = new ArrayList<RuntimeClock>();
        for (SolverBlock entryBlock : this.topBlocks) {
            if (entryBlock == null) continue;
            res.addAll(this.getDiscreteClocksInBlock(entryBlock));
        }
        return res;
    }

    private List<RuntimeClock> getDiscreteClocksInBlock(SolverBlock block) {
        ArrayList<RuntimeClock> localClocks = new ArrayList<RuntimeClock>(block.getConcreteClocks());
        localClocks.addAll(block.getImplicitClocks());
        for (SolverBlock sub : block.getSubBlocks()) {
            List<RuntimeClock> subs = this.getDiscreteClocksInBlock(sub);
            localClocks.addAll(subs);
        }
        return localClocks;
    }

    public List<ImplicitClock> getAllImplicitClocks() {
        return this.allImplicitClocks;
    }

    private List<ImplicitClock> collectImplicitClocks() {
        ArrayList<ImplicitClock> res = new ArrayList<ImplicitClock>();
        for (SolverBlock topBlock : this.topBlocks) {
            res.addAll(this.getImplicitClocksInBlock(topBlock));
        }
        return res;
    }

    private List<ImplicitClock> getImplicitClocksInBlock(SolverBlock block) {
        ArrayList<ImplicitClock> localClocks = new ArrayList<ImplicitClock>(block.getImplicitClocks());
        for (SolverBlock sub : block.getSubBlocks()) {
            localClocks.addAll(this.getImplicitClocksInBlock(sub));
        }
        return localClocks;
    }

    public List<SolverClock> getAllDenseClocks() {
        return this.allDenseClocks;
    }

    private List<SolverClock> collectDenseClocks() {
        ArrayList<SolverClock> res = new ArrayList<SolverClock>();
        for (SolverBlock entryBlock : this.topBlocks) {
            if (entryBlock == null) continue;
            res.addAll(this.getDenseClocksInBlock(entryBlock));
        }
        return res;
    }

    private List<SolverClock> getDenseClocksInBlock(SolverBlock block) {
        ArrayList<SolverClock> localClocks = new ArrayList<SolverClock>(block.getDenseClocks());
        for (SolverBlock sub : block.getSubBlocks()) {
            List<SolverClock> subs = this.getDenseClocksInBlock(sub);
            localClocks.addAll(subs);
        }
        return localClocks;
    }

    private int newBDDVariableNumber(BuDDyFactory factory) {
        int res = factory.varNum();
        factory.setVarNum(res + 1);
        return res;
    }

    private ModelElementReference createModelElementReference(InstantiationPath path) {
        ModelElementReference ref = TracePackage.eINSTANCE.getTraceFactory().createModelElementReference();
        ref.getElementRef().addAll((Collection)path);
        return ref;
    }

    private void initSolverClock(SolverClock newClock, InstantiationPath path) {
        newClock.traceReference = this.createModelElementReference(path);
        newClock.setInstantiationPath(path);
        newClock.setModelElement(path.getLast());
        this.clockInstantiationTree.storeInstance(newClock.getInstantiationPath(), (Object)newClock);
    }

    public ImplicitClock createImplicitClock(InstantiatedElement element) {
        InstantiationPath instantiationPath = element.getInstantiationPath();
        ImplicitClock newClock = new ImplicitClock(element);
        this.initSolverClock(newClock, instantiationPath);
        return newClock;
    }

    private SolverClock createSolverClock(InstantiatedElement element) {
        InstantiationPath path = element.getInstantiationPath();
        Clock modelClock = (Clock)path.getLast();
        SolverClock newClock = new SolverClock(element);
        newClock.setName(modelClock.getName());
        newClock.setDense(element.isDenseClock());
        this.initSolverClock(newClock, path);
        return newClock;
    }

    private int newSolutionIndexNumber() {
        int res = this.solutionIndexCounter++;
        return res;
    }

    private void allocateBDDVariablesToClocks() {
        for (RuntimeClock clock : this.getAllDiscreteClocks()) {
            Set<SolverClock> equalClocks;
            int bddVar = SolverClock.UNALLOCATEDBDDVARIABLE;
            int index = -1;
            if (clockEqualityOptimize && (equalClocks = this.clockEqualityRegister.getEqualityClass((SolverClock)clock)) != null) {
                for (SolverClock otherclock : equalClocks) {
                    if (otherclock.bddVariableNumber == SolverClock.UNALLOCATEDBDDVARIABLE) continue;
                    bddVar = otherclock.bddVariableNumber;
                    index = this.clockToIndexInSolution.get(otherclock);
                    break;
                }
            }
            if (bddVar == SolverClock.UNALLOCATEDBDDVARIABLE) {
                bddVar = this.newBDDVariableNumber(this.BuDDyFactory);
                index = this.newSolutionIndexNumber();
            }
            clock.bddVariableNumber = bddVar;
            this.bddVarToClock.put(clock.bddVariableNumber, (SolverClock)clock);
            this.clockToIndexInSolution.put((SolverClock)clock, index);
            this.bddVarToIndexInSolution.put(clock.bddVariableNumber, index);
        }
    }

    private void allocateBDDVariablesToAssertions() {
        for (SolverRelation relation : this.assertions) {
            relation.setAssertionVariable(this.newBDDVariableNumber(this.BuDDyFactory));
            this.bddAssertVarToRelation.put(relation.getAssertionVariable(), relation);
            int index = this.newSolutionIndexNumber();
            this.assertionsToIndexInSolution.put(relation, index);
            this.bddVarToIndexInSolution.put(relation.getAssertionVariable(), index);
        }
    }

    public void doSimulation(int nSteps) throws SimulationException {
        int stepCount = 0;
        while (stepCount < nSteps) {
            StepExecutor stepExecutor = new StepExecutor(this);
            stepExecutor.executeStep();
            ++stepCount;
        }
    }

    public LogicalStep doOneSimulationStep() throws SimulationException {
        StepExecutor stepExecutor = new StepExecutor(this);
        stepExecutor.executeStep();
        return stepExecutor.getTraceStep();
    }

    public StepExecutor getCurrentStepExecutor() {
        return this.currentStepExecutor;
    }

    public void setCurrentStepExecutor(StepExecutor se) {
        this.currentStepExecutor = se;
    }

    public void clearStepData() {
        if (this.currentStepExecutor != null) {
            this.currentStepExecutor.clearStepData();
        }
    }

    public void constructBDD() throws SimulationException {
        if (this.currentStepExecutor == null) {
            this.currentStepExecutor = new StepExecutor(this);
        }
        this.currentStepExecutor.computePossibleClockStates();
    }

    public List<LogicalStep> getAllPossibleSteps() throws SimulationException {
        return this.currentStepExecutor.getAllSolutions();
    }

    public void clearBDD() throws SimulationException {
        if (this.currentStepExecutor != null) {
            this.currentStepExecutor.freeAll();
        }
        this.currentStepExecutor = null;
    }

    public List<LogicalStep> computeAndGetPossibleLogicalSteps() throws SimulationException {
        if (this.currentStepExecutor == null) {
            this.currentStepExecutor = new StepExecutor(this);
        }
        return this.currentStepExecutor.computeAndGetPossibleLogicalSteps();
    }

    public List<LogicalStep> updatePossibleLogicalSteps() throws SimulationException {
        return this.currentStepExecutor.getAllSolutions();
    }

    public int proposeLogicalStepByIndex() {
        return this.currentStepExecutor.proposeLogicalStepByIndex();
    }

    public LogicalStep applyLogicalStepByIndex(int chosenLogicalStep) throws SimulationException {
        this.currentStepExecutor.applyLogicalStepByIndex(chosenLogicalStep);
        LogicalStep res = this.currentStepExecutor.getTraceStep();
        this.currentStepExecutor = null;
        return res;
    }

    private void buildSolverRelationsAndExpressions(UnfoldModel unfoldModel) throws SolverException {
        InstantiationPath blockStack = new InstantiationPath();
        blockStack.push((NamedElement)unfoldModel.getModel());
        try {
            this.buildSolverRelationsAndExpressionsInBlock(unfoldModel, blockStack, unfoldModel.getModel().getSuperBlock());
        }
        catch (SolverWrappedException e) {
            throw (SolverException)((Object)e.getCause());
        }
        for (UnfoldModel imported : unfoldModel.getImportedModels()) {
            this.buildSolverRelationsAndExpressions(imported);
        }
    }

    private void buildSolverRelationsAndExpressionsInBlock(UnfoldModel unfoldModel, InstantiationPath blockStack, Block block) throws SolverException, UnboundAbstract {
        blockStack.push((NamedElement)block);
        SolverBlock solverBlock = this.findSolverBlock((List<NamedElement>)blockStack);
        List rawList = unfoldModel.getInstantiationTree().lookupInstances(blockStack, 1);
        for (InstantiatedElement element : rawList) {
            ISolverConcrete iSolverConcrete = this.buildConcrete(element, unfoldModel, solverBlock, solverBlock, true);
        }
        for (Block subBlock : block.getSubBlock()) {
            this.buildSolverRelationsAndExpressionsInBlock(unfoldModel, blockStack, subBlock);
        }
        blockStack.pop();
    }

    private ISolverConcrete buildConcrete(InstantiatedElement element, UnfoldModel unfoldModel, IRuntimeContainer parent, SolverBlock solverBlock, boolean storeInBlock) throws SolverException {
        InstantiationPath instPath = element.getInstantiationPath();
        if (element.isElement()) {
            ISolverElement existing = (ISolverElement)this.elementInstantiationTree.lookupInstance(instPath);
            if (existing != null) {
                return (ISolverConcrete)((Object)existing);
            }
            return (ISolverConcrete)((Object)this.buildElement(element, parent, solverBlock, storeInBlock));
        }
        ISolverConcrete existing = (ISolverConcrete)this.concreteInstantiationTree.lookupInstance(instPath);
        if (existing != null) {
            return existing;
        }
        if (element.isExpression()) {
            return this.buildExpression(element, unfoldModel, parent, solverBlock, storeInBlock);
        }
        if (element.isRelation()) {
            return this.buildRelation(element, unfoldModel, parent, solverBlock, storeInBlock);
        }
        return null;
    }

    private ISolverElement buildElement(InstantiatedElement element, IRuntimeContainer parent, SolverBlock sBlock, boolean storeInBlock) {
        Element last;
        InstantiationPath path = element.getInstantiationPath();
        ISolverElement existing = element.isClock() ? (ISolverElement)this.clockInstantiationTree.lookupInstance(path) : (ISolverElement)this.elementInstantiationTree.lookupInstance(path);
        if (existing != null) {
            return existing;
        }
        if (element.isClock()) {
            if (element.getUseCount() == 0L) {
                System.out.println("Clock " + element.getQualifiedName() + " is not used.");
            }
            SolverClock newClock = this.createSolverClock(element);
            newClock.setParent(parent);
            if (storeInBlock && sBlock != null) {
                if (newClock.isDense()) {
                    sBlock.getDenseClocks().add(newClock);
                } else {
                    sBlock.getConcreteClocks().add(newClock);
                }
            }
            return newClock;
        }
        if (element.isPrimitiveElement()) {
            PrimitiveElement primElt = (PrimitiveElement)path.getLast();
            SolverPrimitiveElement newElement = new SolverPrimitiveElement(element, primElt);
            this.elementInstantiationTree.storeInstance(path, (Object)newElement);
            return newElement;
        }
        if (element.isElement() && (last = (Element)element.getInstantiationPath().getLast()) instanceof SequenceElement) {
            SolverSequenceElement newElement = new SolverSequenceElement(element, (SequenceElement)last);
            this.elementInstantiationTree.storeInstance(element.getInstantiationPath(), (Object)newElement);
            return newElement;
        }
        return null;
    }

    public ISolverElement buildElement(InstantiatedElement element, IRuntimeContainer parent) {
        return this.buildElement(element, parent, null, false);
    }

    private SolverExpression buildExpression(InstantiatedElement element, UnfoldModel unfoldModel, IRuntimeContainer parent, SolverBlock solverBlock, boolean storeInBlock) throws SolverException {
        InstantiationPath instPath = element.getInstantiationPath();
        SolverExpression existing = (SolverExpression)this.concreteInstantiationTree.lookupInstance(instPath);
        if (existing != null) {
            return existing;
        }
        ImplicitClock implicitClock = (ImplicitClock)this.getClockInstantiationTree().lookupInstance(instPath);
        if (element.isKernelExpression()) {
            Object parentEnv = parent instanceof SolverExpression ? ((SolverExpression)parent).getAbstractMapping() : (parent instanceof SolverRelation ? ((SolverRelation)parent).getAbstractMapping() : new AbstractConcreteMapping());
            SolverKernelExpressionBuilder builder = new SolverKernelExpressionBuilder(this, implicitClock, (AbstractConcreteMapping<ISolverElement>)parentEnv);
            SolverExpression newExpr = builder.buildExpression(element);
            AbstractConcreteMapping<ISolverElement> env = this.buildAbstractMapping(element, unfoldModel, newExpr, solverBlock, storeInBlock);
            newExpr.setImplicitClock(implicitClock);
            newExpr.setInstantiatedElement(element);
            newExpr.setAbstractMapping(env);
            implicitClock.setExpression(newExpr);
            if (storeInBlock) {
                solverBlock.getImplicitClocks().add(implicitClock);
                solverBlock.getConcretes().add(newExpr);
            }
            implicitClock.setParent(parent);
            newExpr.setParent(parent);
            this.getConcreteInstantiationTree().storeInstance(instPath, (Object)newExpr);
            if (element.getUseCount() == 0L) {
                newExpr.setOrphan(true);
            }
            return newExpr;
        }
        if (element.getDefinition() instanceof ExternalExpressionDefinition) {
            return this.buildExternallyDefinedExpression(element, unfoldModel, parent, solverBlock, storeInBlock);
        }
        if (element.isTailRecursiveCall()) {
            return this.buildTailRecursiveCallExpression(element, unfoldModel, parent, solverBlock, storeInBlock);
        }
        if (element.isConditional()) {
            return this.buildConditionalExpression(element, unfoldModel, parent, solverBlock, storeInBlock);
        }
        return this.buildUserDefinedExpression(element, unfoldModel, parent, solverBlock, storeInBlock);
    }

    private SolverExpression buildExternallyDefinedExpression(InstantiatedElement element, UnfoldModel unfoldModel, IRuntimeContainer parent, SolverBlock solverBlock, boolean storeInBlock) throws SolverException {
        ExpressionDeclaration declaration = (ExpressionDeclaration)element.getDeclaration();
        ExternalExpressionDefinition definition = (ExternalExpressionDefinition)element.getDefinition();
        ISolverExpressionFactory factory = FactoryManager.getInstance().getExpressionFactory(declaration, definition);
        InstantiationPath instPath = element.getInstantiationPath();
        ImplicitClock implicitClock = (ImplicitClock)this.getClockInstantiationTree().lookupInstance(instPath);
        AbstractConcreteMapping<ISolverElement> context = this.buildAbstractMapping(element, unfoldModel, parent, solverBlock, storeInBlock);
        AbstractWrappedExpression newExpression = factory.createExpression(declaration, definition, implicitClock, context);
        SolverExpressionWrapper wrapper = new SolverExpressionWrapper(newExpression, implicitClock);
        newExpression.setWrapper(wrapper);
        wrapper.setImplicitClock(implicitClock);
        implicitClock.setExpression(wrapper);
        wrapper.setInstantiationPath(instPath);
        implicitClock.incRefCount();
        wrapper.setAbstractMapping(context);
        wrapper.setInstantiatedElement(element);
        if (element.getUseCount() == 0L) {
            wrapper.setOrphan(true);
        }
        implicitClock.setParent(parent);
        wrapper.setParent(parent);
        if (storeInBlock) {
            solverBlock.getImplicitClocks().add(implicitClock);
            solverBlock.getConcretes().add(wrapper);
        }
        this.concreteInstantiationTree.storeInstance(instPath, (Object)wrapper);
        return wrapper;
    }

    private UserDefinedExpression buildUserDefinedExpression(InstantiatedElement element, UnfoldModel unfoldModel, IRuntimeContainer parent, SolverBlock solverBlock, boolean storeInBlock) throws SolverException {
        InstantiationPath instPath = element.getInstantiationPath();
        ImplicitClock implicitClock = (ImplicitClock)this.getClockInstantiationTree().lookupInstance(instPath);
        ExpressionDeclaration declaration = (ExpressionDeclaration)element.getDeclaration();
        UserDefinedExpression topExpression = new UserDefinedExpression(element.getDefinition().getName());
        topExpression.setImplicitClock(implicitClock);
        implicitClock.setExpression(topExpression);
        topExpression.setInstantiationPath(instPath);
        topExpression.setAbstractMapping(this.buildAbstractMapping(element, unfoldModel, topExpression, solverBlock, storeInBlock));
        InstantiatedElement root = element.getRootExpression();
        InstantiationPath lookupPath = root.getInstantiationPath();
        ImplicitClock rootClock = (ImplicitClock)this.getClockInstantiationTree().lookupInstance(lookupPath);
        if (rootClock == null) {
            throw new SolverWrappedException(new SolverException("No clock for path: " + lookupPath.toString()));
        }
        topExpression.setRootClock(rootClock);
        rootClock.incRefCount();
        if (clockEqualityOptimize) {
            this.clockEqualityRegister.registerEquality(implicitClock, rootClock);
        }
        topExpression.setInstantiatedElement(element);
        for (AbstractEntity parameter : declaration.getParameters()) {
            InstantiatedElement value = element.resolveAbstractEntity(parameter);
            ISolverElement solverElement = this.buildElement(value, topExpression, solverBlock, false);
            topExpression.setParameterValue(parameter, solverElement);
        }
        if (element.getUseCount() == 0L) {
            topExpression.setOrphan(true);
        }
        topExpression.setParent(parent);
        implicitClock.setParent(parent);
        if (storeInBlock) {
            solverBlock.getImplicitClocks().add(implicitClock);
            solverBlock.getConcretes().add(topExpression);
        }
        this.concreteInstantiationTree.storeInstance(instPath, (Object)topExpression);
        for (InstantiatedElement son : element.getSons()) {
            ISolverConcrete iSolverConcrete = this.buildConcrete(son, unfoldModel, topExpression, solverBlock, false);
        }
        return topExpression;
    }

    private ConditionalExpression buildConditionalExpression(InstantiatedElement element, UnfoldModel unfoldModel, IRuntimeContainer parent, SolverBlock solverBlock, boolean storeInBlock) throws SolverException {
        InstantiationPath instPath = element.getInstantiationPath();
        ImplicitClock implicitClock = (ImplicitClock)this.getClockInstantiationTree().lookupInstance(instPath);
        ConditionalExpression newExpression = new ConditionalExpression();
        newExpression.setAbstractMapping(this.buildAbstractMapping(element, unfoldModel, newExpression, solverBlock, storeInBlock));
        newExpression.setInstantiatedElement(element);
        newExpression.setInstantiationPath(new InstantiationPath((Collection)instPath));
        newExpression.setImplicitClock(implicitClock);
        implicitClock.setExpression(newExpression);
        this.concreteInstantiationTree.storeInstance(newExpression.getInstantiationPath(), (Object)newExpression);
        if (element.getUseCount() == 0L) {
            newExpression.setOrphan(true);
        }
        if (storeInBlock) {
            solverBlock.getConcretes().add(newExpression);
            solverBlock.getImplicitClocks().add(implicitClock);
        }
        newExpression.setParent(parent);
        implicitClock.setParent(parent);
        for (InstantiatedElement son : element.getSons()) {
            if (son.isConditionCase()) {
                this.buildConcrete(son, unfoldModel, newExpression, solverBlock, false);
                ConditionalCase newExpCase = new ConditionalCase();
                SolverExpression caseExpr = (SolverExpression)this.concreteInstantiationTree.lookupInstance(son.getInstantiationPath());
                ImplicitClock iClock = (ImplicitClock)this.clockInstantiationTree.lookupInstance(son.getInstantiationPath());
                newExpCase.setRootClock(iClock);
                newExpCase.getConcretes().add(caseExpr);
                newExpCase.getImplicitClocks().add(iClock);
                iClock.incRefCount();
                InstantiatedElement test = son.getConditionTest();
                if (test != null) {
                    SolverElement testElement = (SolverElement)this.elementInstantiationTree.lookupInstance(test.getInstantiationPath());
                    if (testElement == null) {
                        testElement = (SolverElement)this.buildElement(test, newExpression, solverBlock, false);
                    }
                    newExpCase.setCondition((BooleanExpression)testElement.getModelElement());
                    newExpression.getCases().add(newExpCase);
                    continue;
                }
                newExpression.getDefaultCase().add(caseExpr);
                continue;
            }
            ISolverConcrete sub = this.buildConcrete(son, unfoldModel, newExpression, solverBlock, false);
            newExpression.getConcretes().add(sub);
        }
        return newExpression;
    }

    private RecursiveTailCallJump buildTailRecursiveCallExpression(InstantiatedElement element, UnfoldModel unfoldModel, IRuntimeContainer parent, SolverBlock solverBlock, boolean storeInBlock) throws SolverException {
        InstantiationPath instPath = element.getInstantiationPath();
        ImplicitClock implicitClock = (ImplicitClock)this.getClockInstantiationTree().lookupInstance(instPath);
        InstantiationPath lookupPath = new InstantiationPath((Collection)instPath);
        lookupPath.pop();
        lookupPath.pop();
        InstantiatedElement targetElement = (InstantiatedElement)unfoldModel.getInstantiationTree().lookupInstance(lookupPath);
        SolverExpression targetExpr = (SolverExpression)this.concreteInstantiationTree.lookupInstance(lookupPath);
        if (targetExpr == null) {
            this.buildExpression(targetElement, unfoldModel, parent, solverBlock, storeInBlock);
            targetExpr = (SolverExpression)this.concreteInstantiationTree.lookupInstance(lookupPath);
        }
        RecursiveTailCallJump newExpression = new RecursiveTailCallJump((Expression)instPath.getLast(), targetExpr);
        newExpression.setInstantiatedElement(element);
        newExpression.setImplicitClock(implicitClock);
        implicitClock.setExpression(newExpression);
        newExpression.setInstantiationPath(instPath);
        newExpression.setAbstractMapping(targetExpr.getAbstractMapping());
        ExpressionDeclaration declaration = (ExpressionDeclaration)element.getDeclaration();
        for (AbstractEntity parameter : declaration.getParameters()) {
            InstantiatedElement value = element.resolveAbstractEntity(parameter);
            ISolverElement solverElement = this.buildElement(value, newExpression, null, false);
            newExpression.setParameterValue(parameter, solverElement);
        }
        if (storeInBlock) {
            solverBlock.getConcretes().add(newExpression);
            solverBlock.getImplicitClocks().add(implicitClock);
        }
        newExpression.setParent(parent);
        this.concreteInstantiationTree.storeInstance(instPath, (Object)newExpression);
        return newExpression;
    }

    private ISolverConcrete buildRelation(InstantiatedElement relation, UnfoldModel unfoldModel, IRuntimeContainer parent, SolverBlock block, boolean storeInBlock) throws SolverException {
        InstantiationPath instPath = relation.getInstantiationPath();
        SolverRelation existing = (SolverRelation)this.concreteInstantiationTree.lookupInstance(instPath);
        if (existing != null) {
            return existing;
        }
        if (relation.isKernelRelation()) {
            KernelRelationDeclaration decl = (KernelRelationDeclaration)relation.getDeclaration();
            SolverKernelRelationDelegate newRelation = new SolverKernelRelationDelegate();
            InstantiatedElement left = relation.resolveAbstractEntity(decl.getLeftEntity());
            InstantiatedElement right = relation.resolveAbstractEntity(decl.getRightEntity());
            SolverClock leftClock = (SolverClock)this.clockInstantiationTree.lookupInstance(left.getInstantiationPath());
            SolverClock rightClock = (SolverClock)this.clockInstantiationTree.lookupInstance(right.getInstantiationPath());
            newRelation.setAbstractMapping(this.buildAbstractMapping(relation, unfoldModel, (IRuntimeContainer)newRelation, block, storeInBlock));
            newRelation.setInstantiationPath(new InstantiationPath((Collection)instPath));
            newRelation.setInstantiatedElement(relation);
            newRelation.setLeftClock(leftClock);
            newRelation.setRightClock(rightClock);
            leftClock.incRefCount();
            rightClock.incRefCount();
            AbstractRuntimeRelation delegate = SolverRuntimeRelationFactory.INSTANCE.createRuntimeKernelRelation(decl, leftClock, rightClock);
            newRelation.setDelegate(delegate);
            newRelation.setParent(parent);
            if (storeInBlock) {
                block.getConcretes().add(newRelation);
            }
            newRelation.setTraceReference(this.createModelElementReference(instPath));
            if (relation.isAssertion()) {
                newRelation.setAssertion(true);
                this.assertions.add(newRelation);
            } else if (decl instanceof Coincidence && !relation.inConditionalBranch() && clockEqualityOptimize) {
                this.clockEqualityRegister.registerEquality(leftClock, rightClock);
            }
            this.concreteInstantiationTree.storeInstance(instPath, (Object)newRelation);
            return newRelation;
        }
        if (relation.getDefinition() instanceof ExternalRelationDefinition) {
            return this.buildExternallyDefinedRelation(relation, unfoldModel, parent, block, storeInBlock);
        }
        if (relation.isConditional()) {
            return this.buildConditionalRelation(relation, unfoldModel, parent, block, storeInBlock);
        }
        return this.buildUserDefinedRelation(relation, unfoldModel, parent, block, storeInBlock);
    }

    private ISolverConcrete buildExternallyDefinedRelation(InstantiatedElement relation, UnfoldModel unfoldModel, IRuntimeContainer parent, SolverBlock block, boolean storeInBlock) throws SolverException {
        ExternalRelationDefinition definition = (ExternalRelationDefinition)relation.getDefinition();
        RelationDeclaration declaration = (RelationDeclaration)relation.getDeclaration();
        ISolverRelationFactory factory = FactoryManager.getInstance().getRelationFactory(declaration, definition);
        SolverRelationWrapper wrapper = new SolverRelationWrapper(null);
        AbstractConcreteMapping<ISolverElement> context = this.buildAbstractMapping(relation, unfoldModel, wrapper, block, storeInBlock);
        AbstractWrappedRelation newRelation = factory.createRelation(declaration, definition, context);
        wrapper.setWrappedRelation(newRelation);
        wrapper.setAbstractMapping(context);
        wrapper.setInstantiatedElement(relation);
        wrapper.setInstantiationPath(relation.getInstantiationPath());
        if (storeInBlock) {
            block.getConcretes().add(wrapper);
        }
        wrapper.setParent(parent);
        wrapper.setTraceReference(this.createModelElementReference(relation.getInstantiationPath()));
        this.concreteInstantiationTree.storeInstance(relation.getInstantiationPath(), (Object)wrapper);
        return wrapper;
    }

    private ConditionalRelation buildConditionalRelation(InstantiatedElement relation, UnfoldModel unfoldModel, IRuntimeContainer parent, SolverBlock block, boolean storeInBlock) throws SolverException {
        InstantiationPath instPath = relation.getInstantiationPath();
        ConditionalRelation newRelation = new ConditionalRelation();
        newRelation.setInstantiationPath(new InstantiationPath((Collection)instPath));
        newRelation.setInstantiatedElement(relation);
        newRelation.setAbstractMapping(this.buildAbstractMapping(relation, unfoldModel, (IRuntimeContainer)newRelation, block, storeInBlock));
        if (storeInBlock) {
            block.getConcretes().add(newRelation);
        }
        this.concreteInstantiationTree.storeInstance(newRelation.getInstantiationPath(), (Object)newRelation);
        HashMap<InstantiatedElement, ConditionalCase> subCases = new HashMap<InstantiatedElement, ConditionalCase>();
        for (InstantiatedElement son : relation.getSons()) {
            if (son.isConditionCase()) {
                InstantiatedElement test = son.getConditionTest();
                if (test == null) {
                    newRelation.getDefaultCase().add(this.buildConcrete(son, unfoldModel, (IRuntimeContainer)newRelation, block, false));
                    continue;
                }
                ConditionalCase caseObject = null;
                if (subCases.containsKey(test)) {
                    caseObject = (ConditionalCase)subCases.get(test);
                } else {
                    caseObject = new ConditionalCase();
                    ISolverElement testElement = this.buildElement(test, (IRuntimeContainer)newRelation, block, storeInBlock);
                    caseObject.setCondition((BooleanExpression)testElement.getModelElement());
                    newRelation.getCases().add(caseObject);
                    subCases.put(test, caseObject);
                }
                caseObject.getConcretes().add(this.buildConcrete(son, unfoldModel, (IRuntimeContainer)newRelation, block, false));
                continue;
            }
            ISolverConcrete concrete = this.buildConcrete(son, unfoldModel, block, block, storeInBlock);
            newRelation.getSubConcretes().add(concrete);
        }
        return newRelation;
    }

    private SolverRelation buildUserDefinedRelation(InstantiatedElement relation, UnfoldModel unfoldModel, IRuntimeContainer parent, SolverBlock block, boolean storeInBlock) throws SolverException {
        InstantiationPath instPath = relation.getInstantiationPath();
        SolverRelation newRelation = new SolverRelation();
        newRelation.setInstantiationPath(new InstantiationPath((Collection)instPath));
        newRelation.setInstantiatedElement(relation);
        newRelation.setAbstractMapping(this.buildAbstractMapping(relation, unfoldModel, (IRuntimeContainer)newRelation, block, storeInBlock));
        this.concreteInstantiationTree.storeInstance(newRelation.getInstantiationPath(), (Object)newRelation);
        if (storeInBlock) {
            block.getConcretes().add(newRelation);
        }
        newRelation.setParent(parent);
        if (relation.isAssertion()) {
            newRelation.setAssertion(true);
            this.assertions.add(newRelation);
            newRelation.setTraceReference(this.createModelElementReference(instPath));
        }
        for (InstantiatedElement son : relation.getSons()) {
            ISolverConcrete concrete = this.buildConcrete(son, unfoldModel, (IRuntimeContainer)newRelation, block, storeInBlock);
            newRelation.getSubConcretes().add(concrete);
        }
        return newRelation;
    }

    private AbstractConcreteMapping<ISolverElement> buildAbstractMapping(InstantiatedElement element, UnfoldModel unfoldModel, IRuntimeContainer container, SolverBlock block, boolean storeInBlock) throws SolverException {
        AbstractConcreteMapping acm;
        InstantiatedElement parent = element.getParent();
        if (parent == null) {
            acm = new AbstractConcreteMapping();
        } else {
            AbstractConcreteMapping<ISolverElement> parentAcm = null;
            ISolverConcrete parentConcrete = this.buildConcrete(parent, unfoldModel, container, block, storeInBlock);
            if (parentConcrete instanceof SolverRelation) {
                parentAcm = ((SolverRelation)parentConcrete).getAbstractMapping();
            } else if (parentConcrete instanceof SolverExpression) {
                parentAcm = ((SolverExpression)parentConcrete).getAbstractMapping();
            }
            if (parentAcm == null) {
                System.out.println();
            }
            acm = new AbstractConcreteMapping(parentAcm);
        }
        AbstractConcreteMapping orig = element.getAbstractMapping();
        for (AbstractEntity abs : orig.keySet()) {
            InstantiatedElement value = (InstantiatedElement)orig.resolveAbstractEntity(abs);
            if (value.isElement()) {
                ISolverElement solverElement = this.buildElement(value, container, block, storeInBlock);
                if (solverElement == null) {
                    throw new UnboundAbstract(String.valueOf(abs.toString()) + " in " + element.toString());
                }
                acm.setLocalValue(abs, (Object)solverElement);
                continue;
            }
            if (!value.isExpression()) continue;
            ImplicitClock iClock = (ImplicitClock)this.clockInstantiationTree.lookupInstance(value.getInstantiationPath());
            acm.setLocalValue(abs, (Object)iClock);
            iClock.incRefCount();
        }
        return acm;
    }

    public InstantiationTree<ISolverConcrete> getConcreteInstantiationTree() {
        return this.concreteInstantiationTree;
    }

    public InstantiationTree<SolverClock> getClockInstantiationTree() {
        return this.clockInstantiationTree;
    }

    public InstantiationTree<SolverElement> getElementInstantiationTree() {
        return this.elementInstantiationTree;
    }

    public ImplicitClock lookupImplicitClockFromPath(InstantiationPath path) {
        return (ImplicitClock)this.clockInstantiationTree.lookupInstance(path);
    }

    public List<SolverClock> lookupImplicitClocks(InstantiationPath path) {
        return this.clockInstantiationTree.lookupInstances(path);
    }

    public SimulationPolicyBase getPolicy() {
        return this.policy;
    }

    public void setPolicy(SimulationPolicyBase policy) {
        this.policy = policy;
    }

    public Set<RuntimeClock> getDeadClocks() {
        return this.deadClocks;
    }

    public boolean isDeadClock(SolverClock clock) {
        return this.deadClocks.contains(clock);
    }

    public boolean addDeadClock(RuntimeClock clock) {
        return this.deadClocks.add(clock);
    }

    public boolean removeDeadClock(RuntimeClock clock) {
        return this.deadClocks.remove(clock);
    }

    public List<Reference> getTraceReferences() {
        return this.traceReferences;
    }

    public void setTraceReferences(List<Reference> traceReferences) {
        this.traceReferences = traceReferences;
    }

    public ModelElementReference findReference(InstantiatedElement element) {
        return this.findReference(element.getInstantiationPath());
    }

    public ModelElementReference findReference(InstantiationPath path) {
        ModelElementReference found = null;
        if (this.traceReferences == null) {
            return null;
        }
        for (Reference ref : this.traceReferences) {
            EList references;
            if (!(ref instanceof ModelElementReference) || (references = ((ModelElementReference)ref).getElementRef()).size() != path.size()) continue;
            boolean allEqual = true;
            Iterator refIterator = references.iterator();
            Iterator pathIterator = path.iterator();
            while (refIterator.hasNext() && pathIterator.hasNext()) {
                NamedElement pathElement;
                EObject reference = (EObject)refIterator.next();
                if (reference == (pathElement = (NamedElement)pathIterator.next())) continue;
                allEqual = false;
                break;
            }
            if (!allEqual) continue;
            found = (ModelElementReference)ref;
            break;
        }
        return found;
    }

    public TraceFactory getTraceFactory() {
        return this.traceFactory;
    }

    private void initTrace() {
        this.traceFactory = TracePackage.eINSTANCE.getTraceFactory();
    }

    public BuDDyFactory getBuddyFactory() {
        return this.BuDDyFactory;
    }

    public BDDHelper getBddHelper() {
        return this.bddHelper;
    }

    public PrioritySolver getPrioSolver() {
        return this._prioSolver;
    }

    public void setPrioSolver(PrioritySolver _prioSolver) {
        this._prioSolver = _prioSolver;
    }

    public List<SolverBlock> getTopBlocks() {
        return this.topBlocks;
    }

    public CCSLConstraintState getCurrentState() {
        CCSLConstraintState currentState = new CCSLConstraintState();
        for (ISolverConcrete concrete : this.clockInstantiationTree.lookupInstances(null)) {
            if (!(concrete instanceof SolverClock)) continue;
            SolverClock clock = (SolverClock)concrete;
            currentState.put(clock.getInstantiatedElement().getQualifiedName(), clock.dumpState());
        }
        for (ISolverConcrete concrete : this.elementInstantiationTree.lookupInstances(null)) {
            if (!(concrete instanceof SolverSequenceElement)) continue;
            SolverSequenceElement seq = (SolverSequenceElement)concrete;
            currentState.put(seq.getInstantiatedElement().getQualifiedName(), seq.dumpState());
        }
        List allConcreteElements = this.concreteInstantiationTree.lookupInstances(null);
        for (ISolverConcrete concrete : allConcreteElements) {
            ISolverConcrete rel;
            if (concrete instanceof SolverExpression) {
                SolverExpression expr = (SolverExpression)concrete;
                currentState.put(expr.getInstantiatedElement().getQualifiedName(), expr.dumpState());
            }
            if (concrete instanceof SolverRelation) {
                rel = (SolverRelation)concrete;
                currentState.put(((SolverRelation)rel).getInstantiatedElement().getQualifiedName(), ((SolverRelation)rel).dumpState());
            }
            if (!(concrete instanceof SolverRelationWrapper)) continue;
            rel = (SolverRelationWrapper)concrete;
            currentState.put(((SolverRelationWrapper)rel).getInstantiatedElement().getQualifiedName(), ((SolverRelationWrapper)rel).dumpState());
        }
        return currentState;
    }

    public void setCurrentState(CCSLConstraintState newState) {
        for (String concreteQN : newState.keySet()) {
            ISolverConcrete concrete = (ISolverConcrete)this.concreteInstantiationTree.lookupInstance(concreteQN);
            if (concrete == null) {
                concrete = (ISolverConcrete)this.elementInstantiationTree.lookupInstance(concreteQN);
            }
            if (concrete == null) {
                concrete = (ISolverConcrete)this.clockInstantiationTree.lookupInstance(concreteQN);
            }
            SerializedConstraintState concreteNewState = (SerializedConstraintState)newState.get(concreteQN);
            concrete.restoreState(concreteNewState);
        }
    }
}

