/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.melange.resource;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import fr.inria.diverse.melange.adapters.EObjectAdapter;
import fr.inria.diverse.melange.adapters.ResourceAdapter;
import fr.inria.diverse.melange.metamodel.melange.Language;
import fr.inria.diverse.melange.metamodel.melange.ModelTypingSpace;
import fr.inria.diverse.melange.resource.MelangeRegistry;
import fr.inria.diverse.melange.resource.MelangeResource;
import fr.inria.diverse.melange.resource.MelangeResourceException;
import fr.inria.diverse.melange.resource.MelangeResourceUtils;
import fr.inria.diverse.melange.resource.loader.ModelCopier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.osgi.framework.Bundle;

public class MelangeResourceImpl
implements MelangeResource {
    @Delegate
    private Resource.Internal wrappedResource;
    private String expectedMt;
    private String expectedLang;
    private URI melangeUri;
    private Resource contentResource;
    private Map<EObject, EObject> wrappedToContentMapping;
    private ModelCopier copier;
    private ResourceSet rs;

    public MelangeResourceImpl(URI uri) {
        this((ResourceSet)new ResourceSetImpl(), uri);
    }

    public MelangeResourceImpl(ResourceSet set, URI uri, ModelCopier copier) {
        this(set, uri);
        this.copier = copier;
    }

    public MelangeResourceImpl(ResourceSet rs, URI uri) {
        String query = uri.query();
        String[] _split = null;
        if (query != null) {
            _split = query.split("&|;");
        }
        String[] pairs = _split;
        String _findFirst = null;
        if ((Iterable)Conversions.doWrapArray((Object)pairs) != null) {
            Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String it) {
                    return it.startsWith("mt=");
                }
            };
            _findFirst = (String)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)pairs)), (Functions.Function1)_function);
        }
        String _substring = null;
        if (_findFirst != null) {
            _substring = _findFirst.substring(3);
        }
        this.expectedMt = _substring;
        String _findFirst_1 = null;
        if ((Iterable)Conversions.doWrapArray((Object)pairs) != null) {
            Functions.Function1<String, Boolean> _function_1 = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String it) {
                    return it.startsWith("lang=");
                }
            };
            _findFirst_1 = (String)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)pairs)), (Functions.Function1)_function_1);
        }
        String _substring_1 = null;
        if (_findFirst_1 != null) {
            _substring_1 = _findFirst_1.substring(5);
        }
        this.expectedLang = _substring_1;
        this.melangeUri = uri;
        Resource _resource = rs.getResource(MelangeResourceUtils.melangeToFallbackURI(uri), true);
        this.wrappedResource = (Resource.Internal)_resource;
        rs.getResources().add((Object)this);
    }

    public ResourceSet getResourceSet() {
        return this.rs;
    }

    public NotificationChain basicSetResourceSet(ResourceSet resourceSet, NotificationChain notifications) {
        if (resourceSet == null) {
            CollectionExtensions.removeAll((Collection)this.rs.getResources(), (Object[])new Resource[]{this, this.wrappedResource, this.contentResource});
            this.rs = null;
        } else {
            if (this.wrappedResource != null) {
                resourceSet.getResources().add((Object)this.wrappedResource);
            }
            if (this.contentResource != null) {
                resourceSet.getResources().add((Object)this.contentResource);
            }
            this.rs = resourceSet;
        }
        return notifications;
    }

    @Override
    public Resource getWrappedResource() {
        return this.wrappedResource;
    }

    public EList<EObject> getContents() throws RuntimeException {
        if (this.contentResource == null) {
            this.doAdapt();
        }
        return this.contentResource.getContents();
    }

    public TreeIterator<EObject> getAllContents() {
        return new AbstractTreeIterator<EObject>((Object)this, false){

            public Iterator<? extends EObject> getChildren(Object object) {
                Iterator _xifexpression = null;
                if (object instanceof Resource) {
                    _xifexpression = ((Resource)object).getContents().iterator();
                } else {
                    Iterator _xifexpression_1 = null;
                    if (object instanceof EObject) {
                        _xifexpression_1 = ((EObject)object).eContents().iterator();
                    }
                    _xifexpression = _xifexpression_1;
                }
                return _xifexpression;
            }
        };
    }

    public EObject getEObject(String uriFragment) {
        if (this.contentResource == null) {
            this.doAdapt();
        }
        return this.contentResource.getEObject(uriFragment);
    }

    public String getURIFragment(EObject o) {
        String _xifexpression = null;
        _xifexpression = o instanceof EObjectAdapter ? this.wrappedResource.getURIFragment(((EObjectAdapter)o).getAdaptee()) : null;
        return _xifexpression;
    }

    public URI getURI() {
        return this.melangeUri;
    }

    private Resource adaptResourceToMT(final Resource adaptedResource, final String modelType) {
        MelangeRegistry.LanguageDescriptor actualLanguage = this.getLanguage(adaptedResource);
        Class<? extends ResourceAdapter> adapterCls = actualLanguage.getAdapterFor(modelType);
        if (adapterCls != null) {
            try {
                ResourceAdapter _newInstance = adapterCls.newInstance();
                Procedures.Procedure1<ResourceAdapter> _function = new Procedures.Procedure1<ResourceAdapter>(){

                    public void apply(ResourceAdapter it) {
                        it.setAdaptee(adaptedResource);
                        it.setParent((Resource)MelangeResourceImpl.this);
                        URI _uRI = adaptedResource.getURI();
                        String _plus = _uRI + "_adaptedTo_";
                        String _plus_1 = String.valueOf(_plus) + modelType;
                        it.setURI(URI.createURI((String)_plus_1));
                        abstract class __MelangeResourceImpl_2
                        extends AdapterImpl {
                            Resource notifiedRes;

                            __MelangeResourceImpl_2() {
                            }
                        }
                        __MelangeResourceImpl_2 proxyAdapter = new __MelangeResourceImpl_2(MelangeResourceImpl.this){
                            {
                            }

                            public void notifyChanged(final Notification msg) {
                                EList _eAdapters = null;
                                if (this.notifiedRes != null) {
                                    _eAdapters = this.notifiedRes.eAdapters();
                                }
                                if (_eAdapters != null) {
                                    Consumer<Adapter> _function = new Consumer<Adapter>(){

                                        @Override
                                        public void accept(Adapter it) {
                                            it.notifyChanged(msg);
                                        }
                                    };
                                    _eAdapters.forEach((Consumer)_function);
                                }
                            }
                        };
                        proxyAdapter.notifiedRes = MelangeResourceImpl.this;
                        it.getAdaptee().eAdapters().add((Object)proxyAdapter);
                    }
                };
                return (Resource)ObjectExtensions.operator_doubleArrow((Object)_newInstance, (Procedures.Procedure1)_function);
            }
            catch (Throwable _t) {
                if (_t instanceof InstantiationException) {
                    InstantiationException e = (InstantiationException)_t;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Cannot instantiate adapter type ");
                    _builder.append(adapterCls);
                    throw new MelangeResourceException(_builder.toString(), e);
                }
                if (_t instanceof IllegalAccessException) {
                    IllegalAccessException e_1 = (IllegalAccessException)_t;
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Cannot access adapter type ");
                    _builder_1.append(adapterCls);
                    throw new MelangeResourceException(_builder_1.toString(), e_1);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("No adapter class registered for <");
        String _identifier = actualLanguage.getIdentifier();
        _builder.append(_identifier);
        _builder.append(", ");
        _builder.append(modelType);
        _builder.append(">");
        throw new MelangeResourceException(_builder.toString());
    }

    private Resource adaptResourceToLang(Resource adaptedResource, String language) {
        String _identifier_1;
        MelangeRegistry.LanguageDescriptor actualLanguage = this.getLanguage(adaptedResource);
        MelangeRegistry.LanguageDescriptor expectedLanguage = MelangeRegistry.INSTANCE.getLanguageByIdentifier(language);
        if (expectedLanguage == null) {
            throw new MelangeResourceException("Cannot find a registered language with URI " + language);
        }
        MelangeRegistry.ModelTypeDescriptor actualMt = MelangeRegistry.INSTANCE.getModelTypeByIdentifier(actualLanguage.getExactType());
        MelangeRegistry.ModelTypeDescriptor expectedMt = MelangeRegistry.INSTANCE.getModelTypeByIdentifier(expectedLanguage.getExactType());
        String _identifier = actualMt.getIdentifier();
        boolean _equals = Objects.equal((Object)_identifier, (Object)(_identifier_1 = expectedMt.getIdentifier()));
        if (_equals) {
            String xmofURI = this.getXmofURI(language);
            if (xmofURI != null) {
                EPackage actualPkg = EPackage.Registry.INSTANCE.getEPackage(actualLanguage.getUri());
                Set<EPackage> expectedPkg = this.loadXmofMM(xmofURI);
                if (this.copier == null) {
                    ModelCopier _modelCopier;
                    Set _set = IterableExtensions.toSet(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EPackage[]{actualPkg})));
                    this.copier = _modelCopier = new ModelCopier(_set, expectedPkg, true);
                }
                return this.recursiveClone(this.copier, adaptedResource);
            }
            return adaptedResource;
        }
        boolean _contains = actualMt.getSuperTypes().contains(expectedMt.getIdentifier());
        if (_contains) {
            return adaptedResource;
        }
        boolean _contains_1 = expectedMt.getSuperTypes().contains(actualMt.getIdentifier());
        if (_contains_1) {
            String xmofURI_1 = this.getXmofURI(language);
            EPackage actualPkg_1 = EPackage.Registry.INSTANCE.getEPackage(actualLanguage.getUri());
            Set _xifexpression = null;
            if (xmofURI_1 != null) {
                _xifexpression = this.loadXmofMM(xmofURI_1);
            } else {
                EPackage _ePackage = EPackage.Registry.INSTANCE.getEPackage(expectedLanguage.getUri());
                _xifexpression = IterableExtensions.toSet(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EPackage[]{_ePackage})));
            }
            Set expectedPkg_1 = _xifexpression;
            if (this.copier == null) {
                ModelCopier _modelCopier_1;
                Set _set_1 = IterableExtensions.toSet(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EPackage[]{actualPkg_1})));
                this.copier = _modelCopier_1 = new ModelCopier(_set_1, expectedPkg_1, xmofURI_1 != null);
            }
            return this.recursiveClone(this.copier, adaptedResource);
        }
        StringConcatenation _builder = new StringConcatenation();
        String _identifier_2 = actualMt.getIdentifier();
        _builder.append(_identifier_2);
        _builder.append(" cannot be transtyped to ");
        String _identifier_3 = expectedMt.getIdentifier();
        _builder.append(_identifier_3);
        throw new MelangeResourceException(_builder.toString());
    }

    private Resource recursiveClone(ModelCopier copier, Resource res) {
        HashSet<Resource> allRes = new HashSet<Resource>();
        this.collectRelatedResources(res, allRes);
        allRes.remove(res);
        for (Resource r : allRes) {
            boolean _tripleEquals;
            boolean _isNullOrEmpty_1;
            boolean _not_1;
            boolean _not;
            String newMelangeURIString = r.getURI().toString().replaceFirst("platform:/", "melange:/");
            LinkedList separators = CollectionLiterals.newLinkedList((Object[])new String[]{"?", "&"});
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.expectedLang);
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                String _plus_2;
                String _head = (String)IterableExtensions.head((Iterable)separators);
                String _plus = String.valueOf(newMelangeURIString) + _head;
                String _plus_1 = String.valueOf(_plus) + "lang=";
                newMelangeURIString = _plus_2 = String.valueOf(_plus_1) + this.expectedLang;
                separators.remove(0);
            }
            boolean bl2 = _not_1 = !(_isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)this.expectedMt));
            if (_not_1) {
                String _plus_5;
                String _head_1 = (String)IterableExtensions.head((Iterable)separators);
                String _plus_3 = String.valueOf(newMelangeURIString) + _head_1;
                String _plus_4 = String.valueOf(_plus_3) + "mt=";
                newMelangeURIString = _plus_5 = String.valueOf(_plus_4) + this.expectedMt;
            }
            final URI newMelangeURI = URI.createURI((String)newMelangeURIString);
            Functions.Function1<Resource, Boolean> _function = new Functions.Function1<Resource, Boolean>(){

                public Boolean apply(Resource it) {
                    return it.getURI().equals(newMelangeURI);
                }
            };
            Resource _findFirst = (Resource)IterableExtensions.findFirst((Iterable)this.getResourceSet().getResources(), (Functions.Function1)_function);
            boolean bl3 = _tripleEquals = _findFirst == null;
            if (!_tripleEquals) continue;
            ResourceSet _resourceSet = this.getResourceSet();
            MelangeResourceImpl newMelangeResource = new MelangeResourceImpl(_resourceSet, newMelangeURI, copier);
            this.addToResourceSet((Resource)newMelangeResource);
            newMelangeResource.doAdapt();
        }
        Resource result = copier.clone(res);
        this.wrappedToContentMapping = ImmutableMap.copyOf(copier.getModelsMapping());
        return result;
    }

    protected void collectRelatedResources(Resource res, Set<Resource> result) {
        boolean _not;
        boolean _contains = result.contains(res);
        boolean bl = _not = !_contains;
        if (_not) {
            result.add(res);
            Map crossRefs = EcoreUtil.ExternalCrossReferencer.find((Resource)res);
            Set _entrySet = crossRefs.entrySet();
            for (Map.Entry entry : _entrySet) {
                EObject proxyEObject = (EObject)entry.getKey();
                this.collectRelatedResources(proxyEObject.eResource(), result);
            }
        }
    }

    private Set<EPackage> loadXmofMM(String targetXmofURI) {
        final HashSet<EPackage> expectedPkg = new HashSet<EPackage>();
        URI uri = URI.createURI((String)targetXmofURI.replaceFirst("platform:/resource", "platform:/plugin"), (boolean)true);
        Resource xmofRes = new ResourceSetImpl().getResource(uri, true);
        Set expectedPkgCandidate = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)xmofRes.getContents(), EPackage.class));
        Consumer<EPackage> _function = new Consumer<EPackage>(){

            @Override
            public void accept(EPackage pkg) {
                EPackage p = EPackage.Registry.INSTANCE.getEPackage(pkg.getNsURI());
                if (p == null) {
                    EPackage.Registry.INSTANCE.put((Object)pkg.getNsURI(), (Object)pkg);
                    expectedPkg.add(pkg);
                } else {
                    expectedPkg.add(p);
                }
            }
        };
        expectedPkgCandidate.forEach(_function);
        return expectedPkg;
    }

    private MelangeRegistry.LanguageDescriptor getLanguage(Resource resource) {
        EList objs = resource.getContents();
        String actualPkgUri = ((EObject)IterableExtensions.head((Iterable)objs)).eClass().getEPackage().getNsURI();
        MelangeRegistry.LanguageDescriptor actualLanguage = MelangeRegistry.INSTANCE.getLanguageByUri(actualPkgUri);
        if (actualLanguage == null) {
            throw new MelangeResourceException("Cannot find a registered language with URI " + actualPkgUri);
        }
        return actualLanguage;
    }

    private String getXmofURI(final String languageID) {
        Bundle melangeBundle;
        Enumeration urls;
        boolean _hasMoreElements;
        IConfigurationElement language;
        IExtensionRegistry _extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] _configurationElementsFor = null;
        if (_extensionRegistry != null) {
            _configurationElementsFor = _extensionRegistry.getConfigurationElementsFor("fr.inria.diverse.melange.language");
        }
        IConfigurationElement _findFirst = null;
        if ((Iterable)Conversions.doWrapArray((Object)_configurationElementsFor) != null) {
            Functions.Function1<IConfigurationElement, Boolean> _function = new Functions.Function1<IConfigurationElement, Boolean>(){

                public Boolean apply(IConfigurationElement c) {
                    String _attribute = c.getAttribute("id");
                    return Objects.equal((Object)_attribute, (Object)languageID);
                }
            };
            _findFirst = (IConfigurationElement)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_configurationElementsFor)), (Functions.Function1)_function);
        }
        if ((language = _findFirst) != null && (_hasMoreElements = (urls = (melangeBundle = Platform.getBundle((String)language.getContributor().getName())).findEntries("/", "*.melange", true)).hasMoreElements())) {
            String melangeFilePath = ((URL)urls.nextElement()).getFile();
            ((URL)urls.nextElement()).getFile();
            ResourceSetImpl rs = new ResourceSetImpl();
            String _name = language.getContributor().getName();
            String _plus = "platform:/plugin/" + _name;
            String _plus_1 = String.valueOf(_plus) + "/";
            String _plus_2 = String.valueOf(_plus_1) + melangeFilePath;
            URI uri = URI.createURI((String)_plus_2);
            Resource _resource = rs.getResource(uri, true);
            Resource.Internal res = (Resource.Internal)_resource;
            EObject _head = (EObject)IterableExtensions.head((Iterable)res.getContents());
            ModelTypingSpace root = (ModelTypingSpace)_head;
            Functions.Function1<Language, Boolean> _function_1 = new Functions.Function1<Language, Boolean>(){

                public Boolean apply(Language it) {
                    String _name = it.getName();
                    String _plus = "." + _name;
                    return languageID.endsWith(_plus);
                }
            };
            Language lang = (Language)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)root.getElements(), Language.class), (Functions.Function1)_function_1);
            if (lang != null) {
                return lang.getXmof();
            }
        }
        return null;
    }

    private void doAdapt() {
        this.contentResource = this.wrappedResource;
        this.addToResourceSet(this.contentResource);
        if (!(this.wrappedResource.getContents().isEmpty() || this.expectedMt == null && this.expectedLang == null)) {
            if (this.expectedLang != null) {
                this.contentResource = this.adaptResourceToLang(this.contentResource, this.expectedLang);
                this.addToResourceSet(this.contentResource);
            }
            if (this.expectedMt != null) {
                this.contentResource = this.adaptResourceToMT(this.contentResource, this.expectedMt);
                this.addToResourceSet(this.contentResource);
            }
        }
    }

    private void addToResourceSet(final Resource res) {
        try {
            if (this.getResourceSet() != null && res != null) {
                boolean _not;
                boolean _contains = this.getResourceSet().getResources().contains((Object)res);
                boolean bl = _not = !_contains;
                if (_not) {
                    boolean _not_1;
                    Functions.Function1<Resource, Boolean> _function = new Functions.Function1<Resource, Boolean>(){

                        public Boolean apply(Resource it) {
                            return it.getURI().equals(res.getURI());
                        }
                    };
                    boolean _exists = IterableExtensions.exists((Iterable)this.getResourceSet().getResources(), (Functions.Function1)_function);
                    if (_exists) {
                        throw new Exception("INTERNAL ERROR: resource already loaded?!");
                    }
                    this.getResourceSet().getResources().add((Object)res);
                    boolean _contains_1 = this.getResourceSet().getResources().contains((Object)res);
                    boolean bl2 = _not_1 = !_contains_1;
                    if (_not_1) {
                        throw new Exception("INTERNAL ERROR: resource was not loaded?!");
                    }
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void upcast(String modelTypeID) {
        this.expectedMt = modelTypeID;
        this.doAdapt();
    }

    @Override
    public void extendAs(String languageID) {
        this.expectedLang = languageID;
        this.doAdapt();
    }

    @Override
    public String getModelType() {
        return this.expectedMt;
    }

    @Override
    public String getLanguage() {
        return this.expectedLang;
    }

    public EList<Adapter> eAdapters() {
        if (this.contentResource == null) {
            this.doAdapt();
        }
        return this.contentResource.eAdapters();
    }

    public void eNotify(Notification notification) {
        if (this.contentResource == null) {
            this.doAdapt();
        }
        this.contentResource.eNotify(notification);
    }

    @Override
    public Map<EObject, EObject> getModelsMapping() {
        return this.wrappedToContentMapping;
    }

    public void attached(EObject arg0) {
        this.wrappedResource.attached(arg0);
    }

    public void delete(Map<?, ?> arg0) throws IOException {
        this.wrappedResource.delete(arg0);
    }

    public void detached(EObject arg0) {
        this.wrappedResource.detached(arg0);
    }

    public boolean eDeliver() {
        return this.wrappedResource.eDeliver();
    }

    public void eSetDeliver(boolean arg0) {
        this.wrappedResource.eSetDeliver(arg0);
    }

    public EList<Resource.Diagnostic> getErrors() {
        return this.wrappedResource.getErrors();
    }

    public long getTimeStamp() {
        return this.wrappedResource.getTimeStamp();
    }

    public EList<Resource.Diagnostic> getWarnings() {
        return this.wrappedResource.getWarnings();
    }

    public boolean isLoaded() {
        return this.wrappedResource.isLoaded();
    }

    public boolean isLoading() {
        return this.wrappedResource.isLoading();
    }

    public boolean isModified() {
        return this.wrappedResource.isModified();
    }

    public boolean isTrackingModification() {
        return this.wrappedResource.isTrackingModification();
    }

    public void load(InputStream arg0, Map<?, ?> arg1) throws IOException {
        this.wrappedResource.load(arg0, arg1);
    }

    public void load(Map<?, ?> arg0) throws IOException {
        this.wrappedResource.load(arg0);
    }

    public void save(Map<?, ?> arg0) throws IOException {
        this.wrappedResource.save(arg0);
    }

    public void save(OutputStream arg0, Map<?, ?> arg1) throws IOException {
        this.wrappedResource.save(arg0, arg1);
    }

    public void setModified(boolean arg0) {
        this.wrappedResource.setModified(arg0);
    }

    public void setTimeStamp(long arg0) {
        this.wrappedResource.setTimeStamp(arg0);
    }

    public void setTrackingModification(boolean arg0) {
        this.wrappedResource.setTrackingModification(arg0);
    }

    public void setURI(URI arg0) {
        this.wrappedResource.setURI(arg0);
    }

    public void unload() {
        this.wrappedResource.unload();
    }
}

