/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.model;

public final class IdentifierCode {
    private static byte BEGIN = (byte)33;
    private static byte END = (byte)126;
    private static IdentifierCode[] identifiers;
    private static int current;
    private int value;

    static {
        current = BEGIN;
        identifiers = new IdentifierCode[END - BEGIN + 1];
        int i = BEGIN;
        while (i <= END) {
            IdentifierCode.identifiers[i - IdentifierCode.BEGIN] = new IdentifierCode(i);
            ++i;
        }
    }

    private IdentifierCode(int value) {
        this.value = value;
    }

    public String toString() {
        return "" + (char)this.value;
    }

    public static IdentifierCode fromString(String v) {
        if (v.length() != 1) {
            throw new IllegalArgumentException("Not an IdentifierCode:" + v);
        }
        char c = v.charAt(0);
        if (c < BEGIN || c > END) {
            throw new IllegalArgumentException("IdentifierCode:" + v + " not in RANGE[" + BEGIN + ".." + END + "]");
        }
        return identifiers[c - BEGIN];
    }

    public static IdentifierCode getNext() {
        assert (current > END) : "Invalid identifier";
        return identifiers[current++ - BEGIN];
    }
}

