/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.instantrelation.generator.metier;

import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.CCSLConstraintRef;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.CCSLRelationModelFactory;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.Packet;
import fr.inria.aoste.timesquare.instantrelation.exceptions.ResolveClockConstraintException;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.AbstractCreator;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.Description;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.ModelElementReference;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;

public class CreatorPacketGlissant
extends AbstractCreator {
    final ModelElementReference clock;
    final ModelElementReference trigger;
    final int size;
    boolean flag;
    protected Queue<Packet> queue = new LinkedBlockingDeque<Packet>();

    public CreatorPacketGlissant(CCSLConstraintRef cref, ModelElementReference clock, int size, ModelElementReference trigger) {
        super(cref);
        this.clock = clock;
        this.size = size;
        this.trigger = trigger;
    }

    public final synchronized ModelElementReference getClock() {
        return this.clock;
    }

    public final synchronized int getSize() {
        return this.size;
    }

    @Override
    public void resolve() throws ResolveClockConstraintException {
        EventOccurrence l = this.getEventOccurrenceOnStepTrace(this.clock);
        EventOccurrence t = this.getEventOccurrenceOnStepTrace(this.trigger);
        boolean bt = this.clockTick(t);
        boolean b1 = this.clockTick(l);
        if (b1) {
            this.create();
            this.add(l);
            this.remove();
        }
        if (bt) {
            this.flag = true;
        }
    }

    protected void remove() {
        if (this.queue.size() != 0 && this.queue.element().getOccurrences().size() == this.size) {
            this.addRelation(this.queue.remove());
        }
    }

    protected void add(EventOccurrence l) {
        for (Packet relationPacket : this.queue) {
            relationPacket.getOccurrences().add((Object)l);
        }
    }

    protected void create() {
        if (this.flag) {
            Packet relationPacket = CCSLRelationModelFactory.eINSTANCE.createPacket();
            this.queue.add(relationPacket);
            this.flag = false;
        }
    }

    @Override
    public Description createDescription() {
        return Description.createDescriptionPacket(this.clock, this.getCcslConstraintRef());
    }

    @Override
    public void finish() {
        if (this.queue != null) {
            for (Packet p : this.queue) {
                if (p.getOccurrences().size() == 0) continue;
                this.addRelation(p);
            }
            this.queue.clear();
        }
    }

    @Override
    protected void init() {
    }
}

