/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.pages;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gemoc.commons.eclipse.core.resources.IFileUtils;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ErrorMessage;
import org.eclipse.gemoc.commons.eclipse.ui.dialogs.SelectAnyIFileDialog;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.pages.NewGemocSiriusProjectWizardFields;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditorPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewGemocSiriusProjectMainWizardPage
extends WizardPage {
    protected NewGemocSiriusProjectWizardFields context;
    protected static final List<String> FILE_EXTENSIONS = Arrays.asList("ecore");
    protected ErrorMessage[] errorMessage;
    protected boolean enableNext = true;
    protected Composite container;
    protected Label lblProjectName;
    protected Text txtProjectName;
    protected Text txtProjectLocation;
    protected Button btnBrowseLocation;
    protected Button btnCheckLocation;
    protected Text txtBaseGemocProject;
    protected Button btnBrowseGemocProject;
    protected Text txtDSLFile;
    protected Button btnBrowseDSLFile;
    protected Group grpGeneral;
    protected Group grpBaseGemocProject;
    protected Group grpTemplateOptions;

    public NewGemocSiriusProjectMainWizardPage(NewGemocSiriusProjectWizardFields context) {
        super("wizardPage");
        this.context = context;
        this.setTitle(String.valueOf(SiriusEditorPlugin.getPlugin().getString("_UI_ViewpointSpecificationProjectWizard_label")) + " for GEMOC");
        this.setDescription("This wizard creates a new Sirius specification project for GEMOC");
        this.errorMessage = new ErrorMessage[4];
        this.errorMessage[0] = new ErrorMessage("A project with this name already exists.", false);
        this.errorMessage[1] = new ErrorMessage("Please select an ecore file.", false);
        this.errorMessage[2] = new ErrorMessage("dsl file doesn't exist", false);
        this.errorMessage[3] = new ErrorMessage("base dsl file not set", false);
    }

    public NewGemocSiriusProjectMainWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(String.valueOf(SiriusEditorPlugin.getPlugin().getString("_UI_ViewpointSpecificationProjectWizard_label")) + " for GEMOC");
        this.setDescription("This wizard creates a new Sirius specification project for GEMOC");
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.grpGeneral = new Group(this.container, 0);
        this.grpGeneral.setText("General");
        this.grpGeneral.setLayout((Layout)new GridLayout(4, false));
        this.lblProjectName = new Label((Composite)this.grpGeneral, 0);
        this.lblProjectName.setText("project name ");
        new Label((Composite)this.grpGeneral, 0);
        new Label((Composite)this.grpGeneral, 0);
        new Label((Composite)this.grpGeneral, 0);
        this.txtProjectName = new Text((Composite)this.grpGeneral, 2048);
        this.txtProjectName.setText(this.context.projectName);
        GridData projectNameGrid = new GridData(4, 0x1000000, true, false, 3, 1);
        projectNameGrid.widthHint = 500;
        this.txtProjectName.setLayoutData((Object)projectNameGrid);
        new Label((Composite)this.grpGeneral, 0);
        this.txtProjectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NewGemocSiriusProjectMainWizardPage.this.validatePage();
                NewGemocSiriusProjectMainWizardPage.this.updateNameProject(NewGemocSiriusProjectMainWizardPage.this.txtProjectName.getText());
            }
        });
        this.btnCheckLocation = new Button((Composite)this.grpGeneral, 32);
        this.btnCheckLocation.setText("use default location");
        this.btnCheckLocation.setSelection(true);
        new Label((Composite)this.grpGeneral, 0);
        new Label((Composite)this.grpGeneral, 0);
        new Label((Composite)this.grpGeneral, 0);
        this.btnCheckLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewGemocSiriusProjectMainWizardPage.this.btnCheckLocation.getSelection()) {
                    NewGemocSiriusProjectMainWizardPage.this.txtProjectLocation.setEnabled(false);
                    NewGemocSiriusProjectMainWizardPage.this.btnBrowseLocation.setEnabled(false);
                } else {
                    NewGemocSiriusProjectMainWizardPage.this.txtProjectLocation.setEnabled(true);
                    NewGemocSiriusProjectMainWizardPage.this.btnBrowseLocation.setEnabled(true);
                }
            }
        });
        this.txtProjectLocation = new Text((Composite)this.grpGeneral, 2048);
        this.txtProjectLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.txtProjectLocation.setText(this.context.projectLocation);
        this.txtProjectLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NewGemocSiriusProjectMainWizardPage.this.validatePage();
                NewGemocSiriusProjectMainWizardPage.this.updateProjectLocation(NewGemocSiriusProjectMainWizardPage.this.txtProjectLocation.getText());
            }
        });
        this.btnBrowseLocation = new Button((Composite)this.grpGeneral, 0);
        this.btnBrowseLocation.setText("Browse...");
        this.btnBrowseLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewGemocSiriusProjectMainWizardPage.this.txtProjectLocation.setText(NewGemocSiriusProjectMainWizardPage.this.locationDialog());
            }
        });
        this.grpBaseGemocProject = new Group(this.container, 0);
        this.grpBaseGemocProject.setText("Base XDSML");
        this.grpBaseGemocProject.setLayout((Layout)new GridLayout());
        this.grpBaseGemocProject.setLayoutData((Object)new GridData(768));
        this.createDslFileComposite((Composite)this.grpBaseGemocProject);
        this.txtProjectLocation.setEnabled(false);
        this.btnBrowseLocation.setEnabled(false);
        this.validatePage();
        this.setControl((Control)this.container);
        this.setPageComplete(true);
    }

    private Text createDslFileComposite(Composite composite) {
        Composite dslFileComposite = new Composite(composite, 0);
        dslFileComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        dslFileComposite.setLayout((Layout)layout);
        Label label = new Label(dslFileComposite, 0);
        label.setText("DSL file path:");
        this.txtDSLFile = new Text(dslFileComposite, 4);
        this.txtDSLFile.setText(this.context.dslFilePath);
        this.txtDSLFile.setLayoutData((Object)new GridData(768));
        this.txtDSLFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewGemocSiriusProjectMainWizardPage.this.validatePage();
                NewGemocSiriusProjectMainWizardPage.this.updateDslFilePath(NewGemocSiriusProjectMainWizardPage.this.txtDSLFile.getText());
                try {
                    IFile dslFile = IFileUtils.getIFileFromWorkspaceOrFileSystem((String)NewGemocSiriusProjectMainWizardPage.this.txtDSLFile.getText());
                    if (dslFile.exists()) {
                        NewGemocSiriusProjectMainWizardPage.this.updateBaseGemocProject(dslFile.getProject().getName());
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        });
        this.btnBrowseDSLFile = new Button(dslFileComposite, 0);
        this.btnBrowseDSLFile.setText("Browse...");
        this.btnBrowseDSLFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selections;
                SelectAnyIFileDialog dsldialog = new SelectAnyIFileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                dsldialog.setPattern("*.dsl");
                dsldialog.setTitle("Select base DSL file");
                if (dsldialog.open() == 0 && (selections = dsldialog.getResult()) != null && selections.length != 0 && selections[0] instanceof IFile) {
                    IFile dslFile = (IFile)selections[0];
                    NewGemocSiriusProjectMainWizardPage.this.txtDSLFile.setText(dslFile.getFullPath().toString());
                }
            }
        });
        return this.txtDSLFile;
    }

    protected String locationDialog() {
        DirectoryDialog dirDialog = new DirectoryDialog(new Shell());
        dirDialog.setText("Select location directory");
        this.context.projectLocation = dirDialog.open();
        return this.context.projectLocation;
    }

    protected void activErrorMessage(int index, boolean bActiv) {
        this.errorMessage[index].setActive(bActiv);
        this.setMessageError();
    }

    protected boolean existNameProject() {
        boolean bFinder = false;
        int i = 0;
        while (!bFinder && i < ResourcesPlugin.getWorkspace().getRoot().getProjects().length) {
            if (ResourcesPlugin.getWorkspace().getRoot().getProjects()[i].getName().contentEquals(this.txtProjectName.getText())) {
                bFinder = true;
            }
            ++i;
        }
        return bFinder;
    }

    private boolean isSet(Text text) {
        return text != null && !"".equals(text.getText());
    }

    protected boolean validatePage() {
        boolean validPage = true;
        if (this.existNameProject()) {
            this.activErrorMessage(0, true);
            validPage = false;
        } else {
            this.activErrorMessage(0, false);
        }
        if (this.isSet(this.txtDSLFile)) {
            this.activErrorMessage(3, false);
        } else {
            this.activErrorMessage(3, true);
            validPage = false;
        }
        if (this.isSet(this.txtDSLFile)) {
            try {
                IFile dslFile = IFileUtils.getIFileFromWorkspaceOrFileSystem((String)this.txtDSLFile.getText());
                if (dslFile.exists()) {
                    this.activErrorMessage(2, false);
                } else {
                    this.activErrorMessage(2, true);
                    validPage = false;
                }
            }
            catch (IllegalArgumentException | CoreException e) {
                this.activErrorMessage(2, true);
                validPage = false;
            }
        }
        if (validPage) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
        return validPage;
    }

    protected void setMessageError() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.errorMessage.length) {
            if (this.errorMessage[i].isActive()) {
                result.append(String.valueOf(this.errorMessage[i].getMessageError()) + "\n");
            }
            ++i;
        }
        if (result.length() > 0) {
            this.setErrorMessage(result.toString());
        } else {
            this.setErrorMessage(null);
        }
    }

    protected void updateNameProject(String nameProject) {
        this.context.projectName = nameProject;
        if (this.btnCheckLocation.getSelection()) {
            this.txtProjectLocation.setText(String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString()) + "/" + nameProject);
        }
    }

    protected void updateProjectLocation(String projectLocation) {
        this.context.projectLocation = projectLocation;
    }

    protected void updateBaseGemocProject(String text) {
        this.context.baseGemocProject = text;
    }

    protected void updateDslFilePath(String text) {
        this.context.dslFilePath = text;
    }

    public boolean canFlipToNextPage() {
        return this.enableNext;
    }

    public void setProjectName(String nameProject) {
        this.txtProjectName.setText(nameProject);
        this.context.projectName = nameProject;
    }
}

