/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.ale.interpreted.engine.trace;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import opsemanticsview.OperationalSemanticsView;
import opsemanticsview.OpsemanticsviewFactory;
import opsemanticsview.Rule;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.env.impl.PathsBasedAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.parser.ParsedFile;
import org.eclipse.emf.ecoretools.ale.core.validation.BaseValidator;
import org.eclipse.emf.ecoretools.ale.core.validation.IValidator;
import org.eclipse.emf.ecoretools.ale.ide.env.WithAbsoluteBehaviorPathsAleEnvironment;
import org.eclipse.emf.ecoretools.ale.implementation.BehavioredClass;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;
import org.eclipse.gemoc.ale.interpreted.engine.Helper;
import org.eclipse.gemoc.dsl.Dsl;
import org.eclipse.gemoc.opsemanticsview.gen.OperationalSemanticsViewGenerator;

public class ALEOperationalSemanticsViewGenerator
implements OperationalSemanticsViewGenerator {
    Map<Method, Rule> methodToRule = new HashMap<Method, Rule>();
    BaseValidator aleValidator;
    List<Method> allMethods;
    Map<Method, Set<Method>> callGraph = new HashMap<Method, Set<Method>>();

    public boolean canHandle(Dsl language, IProject melangeProject) {
        return !Helper.getAleUris(language).isEmpty();
    }

    public OperationalSemanticsView generate(Dsl language, IProject melangeProject) {
        OperationalSemanticsView result = OpsemanticsviewFactory.eINSTANCE.createOperationalSemanticsView();
        List<String> ecoreUris = Helper.getEcoreUris(language);
        List<String> aleUris = Helper.getAleUris(language);
        if (!ecoreUris.isEmpty()) {
            ResourceSetImpl rs = new ResourceSetImpl();
            Resource executionMetamodelResource = rs.getResource(URI.createURI((String)ecoreUris.get(0)), true);
            EPackage executionMetamodel = executionMetamodelResource.getContents().stream().filter(o -> o instanceof EPackage).map(o -> (EPackage)o).findFirst().get();
            result.setExecutionMetamodel(executionMetamodel);
            result.setAbstractSyntax(null);
            List<ModelUnit> units = this.loadModelUnits(ecoreUris, aleUris, (ResourceSet)rs);
            this.allMethods = this.getAllMethod(units);
            this.computeCallGraph();
            System.out.println("Callgraph : \n\n");
            this.callGraph.entrySet().forEach(entry -> {
                Method m = (Method)entry.getKey();
                Set s = (Set)entry.getValue();
                List called = s.stream().map(n -> String.valueOf(this.getContainingClass((Method)n).getName()) + "." + n.getOperationRef().getName()).collect(Collectors.toList());
                String.join((CharSequence)", ", called);
                System.out.println(String.valueOf(this.getContainingClass(m).getName()) + "." + m.getOperationRef().getName() + " : \n" + called + "\n");
            });
            this.findDynamicParts(units, result);
            this.allMethods.forEach(mtd -> this.inspectForBigStep((Method)mtd, result));
        }
        return result;
    }

    private List<ModelUnit> loadModelUnits(List<String> syntaxes, List<String> semantics, ResourceSet rs) {
        List parsedSemantics = new ArrayList();
        WithAbsoluteBehaviorPathsAleEnvironment environment = new WithAbsoluteBehaviorPathsAleEnvironment((IAleEnvironment)new PathsBasedAleEnvironment(syntaxes, semantics));
        parsedSemantics = environment.getBehaviors().getParsedFiles();
        List<ModelUnit> res = parsedSemantics.stream().filter(elem -> elem.getRoot() != null).map(elem -> (ModelUnit)elem.getRoot()).collect(Collectors.toList());
        this.aleValidator = new BaseValidator((IAleEnvironment)environment, Arrays.asList(new IValidator[0]));
        ArrayList<ParsedFile> validationInput = new ArrayList<ParsedFile>();
        ResourceImpl r = new ResourceImpl();
        for (ModelUnit unit : res) {
            if (unit.eResource() == null) {
                r.getContents().add((Object)unit);
            }
            ParsedFile mockParseRes = new ParsedFile();
            mockParseRes.setRoot((Object)unit);
            validationInput.add(mockParseRes);
        }
        this.aleValidator.validate(validationInput);
        return res;
    }

    private void findDynamicParts(List<ModelUnit> units, OperationalSemanticsView view) {
        for (ModelUnit unit : units) {
            EClass clsFragment;
            for (ExtendedClass xtdCls : unit.getClassExtensions()) {
                clsFragment = xtdCls.getFragment();
                if (clsFragment.eResource() == null) {
                    clsFragment = (EClass)EcoreUtil.copy((EObject)clsFragment);
                    xtdCls.eResource().getContents().add((Object)clsFragment);
                }
                ArrayList movedFeature = Lists.newArrayList((Iterable)clsFragment.getEStructuralFeatures());
                for (EStructuralFeature feature : movedFeature) {
                    xtdCls.getBaseClass().getEStructuralFeatures().add((Object)feature);
                    view.getDynamicProperties().add((Object)feature);
                }
            }
            for (RuntimeClass newCls : unit.getClassDefinitions()) {
                clsFragment = newCls.getFragment();
                if (clsFragment.eResource() == null) {
                    clsFragment = (EClass)EcoreUtil.copy((EObject)clsFragment);
                    newCls.eResource().getContents().add((Object)clsFragment);
                }
                view.getDynamicClasses().add((Object)clsFragment);
                for (EStructuralFeature feature : clsFragment.getEStructuralFeatures()) {
                    view.getDynamicProperties().add((Object)feature);
                }
            }
        }
    }

    private Rule getRuleOfMethod(Method method, OperationalSemanticsView view) {
        if (this.methodToRule.containsKey(method)) {
            return this.methodToRule.get(method);
        }
        Rule rule = OpsemanticsviewFactory.eINSTANCE.createRule();
        rule.setOperation(method.getOperationRef());
        view.getRules().add((Object)rule);
        if (method.eContainer() instanceof ExtendedClass) {
            EClass eClass = ((ExtendedClass)method.eContainer()).getBaseClass();
            rule.setContainingClass(eClass);
        } else {
            EClass eClass = ((BehavioredClass)method.eContainer()).getFragment();
            rule.setContainingClass(eClass);
        }
        rule.setStepRule(method.getTags().contains((Object)"step"));
        rule.setMain(method.getTags().contains((Object)"main"));
        this.methodToRule.put(method, rule);
        return rule;
    }

    private void inspectForBigStep(Method method, OperationalSemanticsView view) {
        Rule rule = this.getRuleOfMethod(method, view);
        Set<Method> calledMethods = this.callGraph.get(method);
        if (calledMethods == null) {
            calledMethods = new HashSet<Method>();
            this.callGraph.put(method, calledMethods);
        }
        for (Method calledMethod : calledMethods) {
            Rule calledRule = this.getRuleOfMethod(calledMethod, view);
            rule.getCalledRules().add((Object)calledRule);
        }
        List<Method> overridedMethods = this.findOverridingMethods(method);
        for (Method overridedMethod : overridedMethods) {
            Rule overidedRule = this.getRuleOfMethod(overridedMethod, view);
            overidedRule.getOverridenBy().add((Object)rule);
        }
    }

    private List<Method> findCalledMethods(Method method) {
        ArrayList<Method> calledMethods = new ArrayList<Method>();
        TreeIterator allBodyContent = EcoreUtil.getAllContents((EObject)method.getBody(), (boolean)true);
        allBodyContent.forEachRemaining(elem -> {
            if (elem instanceof Call) {
                Call call = (Call)elem;
                Expression caller = (Expression)call.getArguments().get(0);
                Set types = this.aleValidator.getPossibleTypes(caller);
                Method candidate = null;
                for (Method mtd : this.allMethods) {
                    boolean isMatching;
                    EClass cls = this.getContainingClass(mtd);
                    EClassifierType callerType = new EClassifierType((IReadOnlyQueryEnvironment)this.aleValidator.getQryEnv(), (EClassifier)cls);
                    boolean bl = isMatching = call.getServiceName().equals(mtd.getOperationRef().getName()) && mtd.getOperationRef().getEParameters().size() == call.getArguments().size() - 1 && types.stream().anyMatch(type -> callerType.isAssignableFrom(type));
                    if (candidate == null && isMatching) {
                        candidate = mtd;
                        continue;
                    }
                    if (!isMatching || !this.getContainingClass(candidate).isSuperTypeOf(this.getContainingClass(mtd))) continue;
                    candidate = mtd;
                }
                if (candidate != null) {
                    calledMethods.add(candidate);
                }
            }
        });
        return calledMethods;
    }

    private List<Method> findOverridingMethods(Method method) {
        ArrayList<Method> overridedMethods = new ArrayList<Method>();
        for (Method mtd : this.allMethods) {
            boolean isMatching;
            EClass methodClass = this.getContainingClass(method);
            EClass mtdClass = this.getContainingClass(mtd);
            boolean bl = isMatching = method != mtd && method.getOperationRef().getName().equals(mtd.getOperationRef().getName()) && method.getOperationRef().getEParameters().size() == mtd.getOperationRef().getEParameters().size() && methodClass.isSuperTypeOf(mtdClass);
            if (!isMatching) continue;
            overridedMethods.add(mtd);
        }
        return overridedMethods;
    }

    private List<Method> getAllMethod(List<ModelUnit> units) {
        List<Method> allMethods = units.stream().flatMap(unit -> unit.getClassExtensions().stream()).flatMap(cls -> cls.getMethods().stream()).collect(Collectors.toList());
        allMethods.addAll(units.stream().flatMap(unit -> unit.getClassDefinitions().stream()).flatMap(cls -> cls.getMethods().stream()).collect(Collectors.toList()));
        return allMethods;
    }

    private EClass getContainingClass(Method mtd) {
        if (mtd.eContainer() instanceof ExtendedClass) {
            return ((ExtendedClass)mtd.eContainer()).getBaseClass();
        }
        return mtd.getOperationRef().getEContainingClass();
    }

    private void computeCallGraph() {
        for (Method mtd : this.allMethods) {
            Set<Method> calledMethods = this.callGraph.get(mtd);
            if (calledMethods == null) {
                calledMethods = new HashSet<Method>();
                this.callGraph.put(mtd, calledMethods);
            }
            calledMethods.addAll(this.findCalledMethods(mtd));
            List<Method> overridingMethods = this.findOverridingMethods(mtd);
            for (Method overrdidedMtd : overridingMethods) {
                calledMethods.addAll(this.findCalledMethods(overrdidedMtd));
            }
            HashSet<Method> toAdd = new HashSet<Method>();
            for (Method overrdidedMtd : calledMethods) {
                List<Method> overridedCalls = this.findOverridingMethods(overrdidedMtd);
                for (Method overridedCall : overridedCalls) {
                    toAdd.addAll(this.findCalledMethods(overridedCall));
                }
            }
        }
    }
}

