/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.query.ResourceQuery;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class DAnalysisRefresher
extends ResourceSetListenerImpl {
    private static final NotificationFilter DANALYSIS_REFRESHER_EVENTS = NotificationFilter.createEventTypeFilter((int)3);
    private DAnalysisSessionImpl session;

    public DAnalysisRefresher(DAnalysisSessionImpl session) {
        this.session = (DAnalysisSessionImpl)Preconditions.checkNotNull((Object)session);
    }

    public void initialize() {
        this.session.getTransactionalEditingDomain().addResourceSetListener((ResourceSetListener)this);
    }

    public NotificationFilter getFilter() {
        return DANALYSIS_REFRESHER_EVENTS;
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        Multimap<DAnalysis, ResourceDescriptor> referencedSemanticModels = this.getRootSemanticResourceEltsPerRepresentationsResource(event.getNotifications());
        CompoundCommand result = new CompoundCommand();
        for (Map.Entry entry : referencedSemanticModels.asMap().entrySet()) {
            DAnalysis analysis = (DAnalysis)entry.getKey();
            Collection semanticResourceDescriptors = (Collection)entry.getValue();
            if (analysis.getSemanticResources().containsAll(semanticResourceDescriptors)) continue;
            semanticResourceDescriptors.removeAll((Collection<?>)analysis.getSemanticResources());
            result.append(AddCommand.create((EditingDomain)event.getEditingDomain(), (Object)analysis, (Object)ViewpointPackage.Literals.DANALYSIS__SEMANTIC_RESOURCES, (Collection)semanticResourceDescriptors));
        }
        return result;
    }

    public void dispose() {
        if (this.session != null) {
            this.session.getTransactionalEditingDomain().removeResourceSetListener((ResourceSetListener)this);
        }
        this.session = null;
    }

    private Multimap<DAnalysis, ResourceDescriptor> getRootSemanticResourceEltsPerRepresentationsResource(Collection<Notification> notifications) {
        HashMultimap semanticResourceDescriptors = HashMultimap.create();
        for (Notification notification : notifications) {
            if (3 != notification.getEventType() || !(notification.getNewValue() instanceof DSemanticDecorator)) continue;
            DSemanticDecorator decorator = (DSemanticDecorator)notification.getNewValue();
            DAnalysis analysis = new EObjectQuery(decorator).getDAnalysis();
            if (decorator.getTarget() == null || analysis == null || analysis.eResource() == null) continue;
            Resource targetResource = decorator.getTarget().eResource();
            this.registerNewReferencedResource((Multimap<DAnalysis, ResourceDescriptor>)semanticResourceDescriptors, analysis, targetResource);
        }
        return semanticResourceDescriptors;
    }

    private void registerNewReferencedResource(Multimap<DAnalysis, ResourceDescriptor> referencedSemanticModels, DAnalysis analysis, Resource semanticResource) {
        if (semanticResource != null && !new ResourceQuery(semanticResource).isAirdOrSrmResource()) {
            referencedSemanticModels.put((Object)analysis, (Object)new ResourceDescriptor(semanticResource.getURI()));
        }
    }
}

