/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.conflict;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.internal.conflict.AbstractConflictSearch;
import org.eclipse.emf.compare.internal.conflict.ComparisonIndex;
import org.eclipse.emf.compare.internal.conflict.DiffTreeIterator;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.utils.EMFCompareJavaPredicates;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ContainmentRefChangeConflictSearch {

    public static class Add
    extends AbstractConflictSearch<ReferenceChange> {
        public Add(ReferenceChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            EObject value = ((ReferenceChange)this.diff).getValue();
            EReference feature = ((ReferenceChange)this.diff).getReference();
            Collection<ReferenceChange> refChanges = this.index.getReferenceChangesByValue(value);
            Iterable candidates = refChanges.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff).and(EMFCompareJavaPredicates.ofKind(DifferenceKind.ADD, DifferenceKind.CHANGE)))::iterator;
            for (ReferenceChange candidate : candidates) {
                if (!candidate.getReference().isContainment()) continue;
                if (candidate.getReference() == feature && candidate.getMatch() == ((ReferenceChange)this.diff).getMatch()) {
                    FeatureFilter featureFilter = this.getFeatureFilter(this.comparison);
                    if (featureFilter == null || featureFilter.checkForOrderingChanges((EStructuralFeature)feature)) {
                        if (MatchUtil.matchingIndices(((ReferenceChange)this.diff).getMatch(), (EStructuralFeature)feature, value, candidate.getValue())) {
                            this.conflict(candidate, ConflictKind.PSEUDO);
                            continue;
                        }
                        this.conflict(candidate, ConflictKind.REAL);
                        continue;
                    }
                    this.conflict(candidate, ConflictKind.PSEUDO);
                    continue;
                }
                this.conflict(candidate, ConflictKind.REAL);
            }
            EList<Diff> diffsInSameMatch = ((ReferenceChange)this.diff).getMatch().getDifferences();
            if (!feature.isMany()) {
                Iterable additionalCandidates = diffsInSameMatch.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff).and(ReferenceChange.class::isInstance).and(EMFCompareJavaPredicates.onFeature((EStructuralFeature)feature)).and(EMFCompareJavaPredicates.ofKind(DifferenceKind.ADD, DifferenceKind.CHANGE)))::iterator;
                for (Diff candidate : additionalCandidates) {
                    if (this.comparison.getEqualityHelper().matchingValues(((ReferenceChange)candidate).getValue(), ((ReferenceChange)this.diff).getValue())) {
                        this.conflict(candidate, ConflictKind.PSEUDO);
                        continue;
                    }
                    this.conflict(candidate, ConflictKind.REAL);
                }
            }
        }
    }

    public static class Change
    extends AbstractConflictSearch<ReferenceChange> {
        public Change(ReferenceChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            block6: {
                Iterable additionalCandidates;
                EList<Diff> diffsInSameMatch;
                EReference feature;
                EObject value;
                block5: {
                    value = ((ReferenceChange)this.diff).getValue();
                    feature = ((ReferenceChange)this.diff).getReference();
                    Collection<ReferenceChange> refChanges = this.index.getReferenceChangesByValue(value);
                    Iterable candidates = refChanges.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff).and(EMFCompareJavaPredicates.ofKind(DifferenceKind.ADD, DifferenceKind.CHANGE)))::iterator;
                    for (ReferenceChange candidate : candidates) {
                        if (!candidate.getReference().isContainment()) continue;
                        if (candidate.getReference() == feature && candidate.getMatch() == ((ReferenceChange)this.diff).getMatch()) {
                            this.conflict(candidate, ConflictKind.PSEUDO);
                            continue;
                        }
                        this.conflict(candidate, ConflictKind.REAL);
                    }
                    diffsInSameMatch = ((ReferenceChange)this.diff).getMatch().getDifferences();
                    if (feature.isMany() || !ComparisonUtil.isAddOrSetDiff(this.diff)) break block5;
                    additionalCandidates = diffsInSameMatch.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff).and(ReferenceChange.class::isInstance).and(EMFCompareJavaPredicates.onFeature((EStructuralFeature)feature)))::iterator;
                    for (Diff candidate : additionalCandidates) {
                        if (this.comparison.getEqualityHelper().matchingValues(((ReferenceChange)candidate).getValue(), ((ReferenceChange)this.diff).getValue())) {
                            this.conflict(candidate, ConflictKind.PSEUDO);
                            continue;
                        }
                        this.conflict(candidate, ConflictKind.REAL);
                    }
                    break block6;
                }
                if (ComparisonUtil.isDeleteOrUnsetDiff(this.diff)) break block6;
                additionalCandidates = diffsInSameMatch.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff).and(ReferenceChange.class::isInstance).and(EMFCompareJavaPredicates.onFeature((EStructuralFeature)feature)))::iterator;
                for (Diff candidate : additionalCandidates) {
                    if (ComparisonUtil.isDeleteOrUnsetDiff(candidate) || ((ReferenceChange)this.diff).getReference() != ((ReferenceChange)candidate).getReference() || !MatchUtil.matchingIndices(((ReferenceChange)this.diff).getMatch(), (EStructuralFeature)((ReferenceChange)this.diff).getReference(), value, ((ReferenceChange)candidate).getValue())) continue;
                    this.conflict(candidate, ConflictKind.PSEUDO);
                }
            }
        }
    }

    public static class Delete
    extends AbstractConflictSearch<ReferenceChange> {
        public Delete(ReferenceChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            EObject value = ((ReferenceChange)this.diff).getValue();
            Collection<ReferenceChange> refChanges = this.index.getReferenceChangesByValue(value);
            refChanges.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff)).filter(d -> !ComparisonUtil.isDeleteOrUnsetDiff(d)).forEach(d -> this.conflict((Diff)d, ConflictKind.REAL));
            EList<Diff> diffsInSameMatch = ((ReferenceChange)this.diff).getMatch().getDifferences();
            diffsInSameMatch.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff).and(ReferenceChange.class::isInstance).and(EMFCompareJavaPredicates.valueMatches(this.comparison.getEqualityHelper(), value))).forEach(candidate -> {
                if (ComparisonUtil.isDeleteOrUnsetDiff(candidate)) {
                    this.conflict((Diff)candidate, ConflictKind.PSEUDO);
                } else {
                    this.conflict((Diff)candidate, ConflictKind.REAL);
                }
            });
            DiffTreeIterator diffIterator = new DiffTreeIterator(this.comparison.getMatch(value));
            diffIterator.setFilter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff));
            diffIterator.setPruningFilter(this.isContainmentDelete());
            while (diffIterator.hasNext()) {
                Diff extendedCandidate = diffIterator.next();
                if (ComparisonUtil.isDeleteOrUnsetDiff(extendedCandidate)) continue;
                this.conflict(extendedCandidate, ConflictKind.REAL);
            }
        }
    }

    public static class Move
    extends AbstractConflictSearch<ReferenceChange> {
        public Move(ReferenceChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            EObject value = ((ReferenceChange)this.diff).getValue();
            EReference feature = ((ReferenceChange)this.diff).getReference();
            Collection<ReferenceChange> refChanges = this.index.getReferenceChangesByValue(value);
            Iterable candidates = refChanges.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff).and(EMFCompareJavaPredicates.ofKind(DifferenceKind.MOVE))).filter(d -> d.getReference().isContainment())::iterator;
            for (ReferenceChange candidate2 : candidates) {
                if (candidate2.getReference() == feature && candidate2.getMatch() == ((ReferenceChange)this.diff).getMatch()) {
                    FeatureFilter featureFilter = this.getFeatureFilter(this.comparison);
                    if (featureFilter == null || featureFilter.checkForOrderingChanges((EStructuralFeature)feature)) {
                        if (MatchUtil.matchingIndices(((ReferenceChange)this.diff).getMatch(), (EStructuralFeature)feature, value, candidate2.getValue())) {
                            this.conflict(candidate2, ConflictKind.PSEUDO);
                            continue;
                        }
                        this.conflict(candidate2, ConflictKind.REAL);
                        continue;
                    }
                    this.conflict(candidate2, ConflictKind.PSEUDO);
                    continue;
                }
                this.conflict(candidate2, ConflictKind.REAL);
            }
            EList<Diff> diffsInSameMatch = ((ReferenceChange)this.diff).getMatch().getDifferences();
            diffsInSameMatch.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff).and(EMFCompareJavaPredicates.valueMatches(this.comparison.getEqualityHelper(), value)).and(ReferenceChange.class::isInstance).and(EMFCompareJavaPredicates.onFeature((EStructuralFeature)feature))).forEach(candidate -> {
                if (MatchUtil.matchingIndices(((ReferenceChange)this.diff).getMatch(), (EStructuralFeature)((ReferenceChange)this.diff).getReference(), value, ((ReferenceChange)candidate).getValue())) {
                    this.conflict((Diff)candidate, ConflictKind.PSEUDO);
                } else {
                    this.conflict((Diff)candidate, ConflictKind.REAL);
                }
            });
        }
    }
}

