/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.engine.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.EMFCommandTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.gemoc.executionframework.engine.Activator;
import org.eclipse.gemoc.executionframework.engine.core.EngineStoppedException;
import org.eclipse.gemoc.executionframework.engine.core.SequentialExecutionException;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.xdsmlframework.api.core.EngineStatus;
import org.eclipse.gemoc.xdsmlframework.api.core.IDisposable;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionContext;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.core.IRunConfiguration;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.EngineAddonSortingRule;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;

public abstract class AbstractExecutionEngine<C extends IExecutionContext<R, ?, ?>, R extends IRunConfiguration>
implements IExecutionEngine<C>,
IDisposable {
    private EngineStatus.RunStatus _runningStatus = EngineStatus.RunStatus.Initializing;
    protected EngineStatus engineStatus = new EngineStatus();
    protected C _executionContext;
    protected boolean _started = false;
    protected boolean _isStopped = false;
    protected String _name;
    public Thread thread;
    public boolean stopOnAddonError = false;
    public Throwable error = null;
    protected InternalTransactionalEditingDomain editingDomain;
    private EMFCommandTransaction currentTransaction;
    private Deque<Step<?>> currentSteps = new ArrayDeque();
    protected Map<EngineAddonSortingRule.EngineEvent, List<IEngineAddon>> sortedAddonMapCache = new HashMap<EngineAddonSortingRule.EngineEvent, List<IEngineAddon>>();

    protected abstract void performStart();

    protected abstract void performStop();

    protected abstract void performInitialize(C var1);

    protected abstract void beforeStart();

    protected abstract void finishDispose();

    public final void initialize(C executionContext) {
        if (executionContext == null) {
            throw new IllegalArgumentException("executionContext");
        }
        this._executionContext = executionContext;
        this.editingDomain = AbstractExecutionEngine.getEditingDomain(executionContext.getResourceModel().getResourceSet());
        this.setEngineStatus(EngineStatus.RunStatus.Initializing);
        this.performInitialize(executionContext);
    }

    public final C getExecutionContext() {
        return this._executionContext;
    }

    public final EngineStatus getEngineStatus() {
        return this.engineStatus;
    }

    public final void dispose() {
        try {
            this.stop();
            this.notifyEngineAboutToDispose();
            this.getExecutionContext().dispose();
            this.finishDispose();
        }
        finally {
            Activator.getDefault().gemocRunningEngineRegistry.unregisterEngine(this.getName());
        }
    }

    public String getName() {
        return this._name == null ? String.valueOf(this.engineKindName()) + " " + this._executionContext.getRunConfiguration().getExecutedModelURI() : this._name;
    }

    private void addonError(IEngineAddon addon, Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String exceptionAsString = sw.toString();
        Activator.getDefault().error("Exception in Addon (" + addon + "), " + exceptionAsString, e);
        if (this.stopOnAddonError) {
            throw new RuntimeException(e);
        }
    }

    protected void notifyEngineAboutToStart() {
        for (IEngineAddon addon : this.getExecutionContext().getExecutionPlatform().getSortedEngineAddons(EngineAddonSortingRule.EngineEvent.engineAboutToStart)) {
            try {
                addon.engineAboutToStart((IExecutionEngine)this);
            }
            catch (Exception e) {
                this.addonError(addon, e);
            }
        }
    }

    protected void notifyEngineStarted() {
        for (IEngineAddon addon : this.getExecutionContext().getExecutionPlatform().getSortedEngineAddons(EngineAddonSortingRule.EngineEvent.engineStarted)) {
            try {
                addon.engineStarted((IExecutionEngine)this);
            }
            catch (Exception e) {
                this.addonError(addon, e);
            }
        }
    }

    protected void notifyEngineInitialized() {
        for (IEngineAddon addon : this.getExecutionContext().getExecutionPlatform().getSortedEngineAddons(EngineAddonSortingRule.EngineEvent.engineInitialized)) {
            try {
                addon.engineInitialized((IExecutionEngine)this);
            }
            catch (Exception e) {
                this.addonError(addon, e);
            }
        }
    }

    protected final void notifyAboutToStop() {
        for (IEngineAddon addon : this.getExecutionContext().getExecutionPlatform().getSortedEngineAddons(EngineAddonSortingRule.EngineEvent.engineAboutToStop)) {
            try {
                addon.engineAboutToStop((IExecutionEngine)this);
            }
            catch (Exception e) {
                this.addonError(addon, e);
            }
        }
    }

    protected final void notifyEngineStopped() {
        for (IEngineAddon addon : this.getExecutionContext().getExecutionPlatform().getSortedEngineAddons(EngineAddonSortingRule.EngineEvent.engineStopped)) {
            try {
                addon.engineStopped((IExecutionEngine)this);
            }
            catch (Exception e) {
                this.addonError(addon, e);
            }
        }
    }

    protected final void notifyEngineAboutToDispose() {
        for (IEngineAddon addon : this.getExecutionContext().getExecutionPlatform().getSortedEngineAddons(EngineAddonSortingRule.EngineEvent.engineAboutToDispose)) {
            try {
                addon.engineAboutToDispose((IExecutionEngine)this);
            }
            catch (Exception e) {
                this.addonError(addon, e);
            }
        }
        this.sortedAddonMapCache.clear();
    }

    protected void notifyEngineStatusChanged(EngineStatus.RunStatus newStatus) {
        for (IEngineAddon addon : this.getCachedSortedEngineAddons(EngineAddonSortingRule.EngineEvent.engineStatusChanged)) {
            try {
                addon.engineStatusChanged((IExecutionEngine)this, newStatus);
            }
            catch (Exception e) {
                this.addonError(addon, e);
            }
        }
    }

    protected void notifyAboutToExecuteLogicalStep(Step<?> l) {
        for (IEngineAddon addon : this.getCachedSortedEngineAddons(EngineAddonSortingRule.EngineEvent.aboutToExecuteStep)) {
            try {
                addon.aboutToExecuteStep((IExecutionEngine)this, l);
            }
            catch (EngineStoppedException ese) {
                Activator.getDefault().debug("Addon (" + addon.getClass().getSimpleName() + "@" + addon.hashCode() + ") has received stop command  with message : " + ese.getMessage());
                this.stop();
                throw ese;
            }
            catch (Exception e) {
                this.addonError(addon, e);
            }
        }
    }

    protected void notifyLogicalStepExecuted(Step<?> l) {
        for (IEngineAddon addon : this.getCachedSortedEngineAddons(EngineAddonSortingRule.EngineEvent.stepExecuted)) {
            try {
                addon.stepExecuted((IExecutionEngine)this, l);
            }
            catch (EngineStoppedException ese) {
                Activator.getDefault().debug("Addon (" + addon.getClass().getSimpleName() + "@" + addon.hashCode() + ") has received stop command  with message : " + ese.getMessage());
                this.stop();
            }
            catch (Exception e) {
                this.addonError(addon, e);
            }
        }
    }

    protected List<IEngineAddon> getCachedSortedEngineAddons(EngineAddonSortingRule.EngineEvent engineEvent) {
        List<IEngineAddon> cachedList = this.sortedAddonMapCache.get(engineEvent);
        if (cachedList != null) {
            return cachedList;
        }
        List result = this.getExecutionContext().getExecutionPlatform().getSortedEngineAddons(engineEvent);
        this.sortedAddonMapCache.put(engineEvent, result);
        return result;
    }

    public final <T extends IEngineAddon> boolean hasAddon(Class<T> type) {
        for (IEngineAddon c : this.getExecutionContext().getExecutionPlatform().getEngineAddons()) {
            if (!c.getClass().equals(type)) continue;
            return true;
        }
        return false;
    }

    public final <T extends IEngineAddon> T getAddon(Class<T> type) {
        for (IEngineAddon c : this.getExecutionContext().getExecutionPlatform().getEngineAddons()) {
            if (!c.getClass().equals(type)) continue;
            return (T)c;
        }
        return null;
    }

    public final <T> Set<T> getAddonsTypedBy(Class<T> type) {
        HashSet<IEngineAddon> result = new HashSet<IEngineAddon>();
        for (IEngineAddon c : this.getExecutionContext().getExecutionPlatform().getEngineAddons()) {
            if (!type.isAssignableFrom(c.getClass())) continue;
            result.add(c);
        }
        return result;
    }

    public final void setEngineStatus(EngineStatus.RunStatus newStatus) {
        this._runningStatus = newStatus;
        this.notifyEngineStatusChanged(newStatus);
    }

    public final EngineStatus.RunStatus getRunningStatus() {
        return this._runningStatus;
    }

    public final void joinThread() {
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            Activator.getDefault().warn("InterruptedException received", e);
        }
    }

    public final void start() {
        if (!this._started) {
            this._started = true;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    AbstractExecutionEngine.this.startSynchronous();
                }
            };
            this.thread = new Thread(r, String.valueOf(this.engineKindName()) + " " + this._executionContext.getRunConfiguration().getExecutedModelURI());
            this.thread.start();
        }
    }

    public final void startSynchronous() {
        try {
            try {
                this.notifyEngineAboutToStart();
                this._name = Activator.getDefault().gemocRunningEngineRegistry.registerEngine(this.getName(), this);
                this.setEngineStatus(EngineStatus.RunStatus.Running);
                this.beforeStart();
                this.notifyEngineStarted();
                try {
                    this.performStart();
                }
                finally {
                    this.commitCurrentTransaction();
                }
            }
            catch (EngineStoppedException stopException) {
                Activator.getDefault().info("Engine stopped by the user : " + stopException.getMessage());
                this.stop();
                Activator.getDefault().info("*** " + this.getName() + " stopped ***");
            }
            catch (Throwable e) {
                this.error = e;
                e.printStackTrace();
                Activator.getDefault().error("Exception received " + e.getMessage() + ", stopping engine.", e);
                this.stop();
                Activator.getDefault().info("*** " + this.getName() + " stopped ***");
            }
        }
        finally {
            this.stop();
            Activator.getDefault().info("*** " + this.getName() + " stopped ***");
        }
    }

    public final void stop() {
        if (!this._isStopped) {
            this.notifyAboutToStop();
            this._isStopped = true;
            this.performStop();
            this.setEngineStatus(EngineStatus.RunStatus.Stopped);
            this.notifyEngineStopped();
        }
    }

    private void cleanCurrentTransactionCommand() {
        if (this.currentTransaction != null && this.currentTransaction.getCommand() != null) {
            this.currentTransaction.getCommand().dispose();
        }
    }

    private synchronized void commitCurrentTransaction() {
        if (this.currentTransaction != null) {
            try {
                this.currentTransaction.commit();
            }
            catch (RollbackException t) {
                this.cleanCurrentTransactionCommand();
                Throwable realT = t.getStatus().getException();
                SequentialExecutionException enclosingException = new SequentialExecutionException(this.getCurrentStep(), realT);
                enclosingException.initCause(realT);
                throw enclosingException;
            }
            this.currentTransaction = null;
        }
    }

    public final Deque<Step<?>> getCurrentStack() {
        return this.currentSteps;
    }

    private EMFCommandTransaction createTransaction(InternalTransactionalEditingDomain editingDomain, RecordingCommand command) {
        return new EMFCommandTransaction((Command)command, editingDomain, null);
    }

    public final Step<?> getCurrentStep() {
        if (this.currentSteps.size() > 0) {
            return this.currentSteps.getFirst();
        }
        return null;
    }

    private void startNewTransaction(InternalTransactionalEditingDomain editingDomain, RecordingCommand command) {
        this.currentTransaction = this.createTransaction(editingDomain, command);
        try {
            this.currentTransaction.start();
        }
        catch (InterruptedException e) {
            this.cleanCurrentTransactionCommand();
            command.dispose();
            SequentialExecutionException enclosingException = new SequentialExecutionException(this.getCurrentStep(), (Throwable)e);
            enclosingException.initCause(e);
            throw enclosingException;
        }
    }

    protected final void stopExecutionIfAsked() {
        if (this._isStopped) {
            this.notifyAboutToStop();
            throw new EngineStoppedException("Execution stopped.");
        }
    }

    protected final void beforeExecutionStep(Step<?> step) {
        RecordingCommand rc = new RecordingCommand((TransactionalEditingDomain)this.editingDomain){

            protected void doExecute() {
            }
        };
        this.beforeExecutionStep(step, rc);
        rc.execute();
    }

    protected final void beforeExecutionStep(Step<?> step, RecordingCommand rc) {
        this.engineStatus.incrementNbLogicalStepCalled();
        try {
            this.currentSteps.push(step);
            this.stopExecutionIfAsked();
            this.commitCurrentTransaction();
            this.notifyAboutToExecuteLogicalStep(step);
            this.startNewTransaction(this.editingDomain, rc);
        }
        catch (Throwable t) {
            this.cleanCurrentTransactionCommand();
            rc.dispose();
            throw t;
        }
    }

    private boolean isInStep() {
        boolean containsNotNull = false;
        for (Step<?> ls : this.currentSteps) {
            if (ls == null || ls.getMseoccurrence() == null) continue;
            containsNotNull = true;
            break;
        }
        return !this.currentSteps.isEmpty() && containsNotNull;
    }

    protected void afterExecutionStep() {
        RecordingCommand emptyrc = null;
        try {
            Step<?> step = this.currentSteps.pop();
            this.commitCurrentTransaction();
            this.notifyLogicalStepExecuted(step);
            if (this.isInStep()) {
                emptyrc = new RecordingCommand((TransactionalEditingDomain)this.editingDomain){

                    protected void doExecute() {
                    }
                };
                this.startNewTransaction(this.editingDomain, emptyrc);
                emptyrc.execute();
            }
            this.engineStatus.incrementNbLogicalStepRun();
            this.stopExecutionIfAsked();
        }
        catch (Throwable t) {
            this.cleanCurrentTransactionCommand();
            if (emptyrc != null) {
                emptyrc.dispose();
            }
            throw t;
        }
    }

    private static InternalTransactionalEditingDomain getEditingDomain(ResourceSet rs) {
        TransactionalEditingDomain edomain = TransactionalEditingDomain.Factory.INSTANCE.getEditingDomain(rs);
        if (edomain instanceof InternalTransactionalEditingDomain) {
            return (InternalTransactionalEditingDomain)edomain;
        }
        return null;
    }
}

