/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.AWTGlyphGeometryCache;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.text.ArabicTextHandler;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPaintInfo;

public class AWTGVTGlyphVector
implements GVTGlyphVector {
    public static final AttributedCharacterIterator.Attribute PAINT_INFO = GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO;
    private GlyphVector awtGlyphVector;
    private AWTGVTFont gvtFont;
    private CharacterIterator ci;
    private Point2D[] defaultGlyphPositions;
    private Point2D.Float[] glyphPositions;
    private AffineTransform[] glyphTransforms;
    private Shape[] glyphOutlines;
    private Shape[] glyphVisualBounds;
    private Shape[] glyphLogicalBounds;
    private boolean[] glyphVisible;
    private GVTGlyphMetrics[] glyphMetrics;
    private GeneralPath outline;
    private Rectangle2D visualBounds;
    private Rectangle2D logicalBounds;
    private Rectangle2D bounds2D;
    private float scaleFactor;
    private float ascent;
    private float descent;
    private TextPaintInfo cacheTPI;
    private static final boolean outlinesPositioned;
    private static final boolean drawGlyphVectorWorks;
    private static final boolean glyphVectorTransformWorks;

    public AWTGVTGlyphVector(GlyphVector glyphVector, AWTGVTFont aWTGVTFont, float f, CharacterIterator characterIterator) {
        this.awtGlyphVector = glyphVector;
        this.gvtFont = aWTGVTFont;
        this.scaleFactor = f;
        this.ci = characterIterator;
        GVTLineMetrics gVTLineMetrics = this.gvtFont.getLineMetrics("By", this.awtGlyphVector.getFontRenderContext());
        this.ascent = gVTLineMetrics.getAscent();
        this.descent = gVTLineMetrics.getDescent();
        this.outline = null;
        this.visualBounds = null;
        this.logicalBounds = null;
        this.bounds2D = null;
        int n = glyphVector.getNumGlyphs();
        this.glyphPositions = new Point2D.Float[n + 1];
        this.glyphTransforms = new AffineTransform[n];
        this.glyphOutlines = new Shape[n];
        this.glyphVisualBounds = new Shape[n];
        this.glyphLogicalBounds = new Shape[n];
        this.glyphVisible = new boolean[n];
        this.glyphMetrics = new GVTGlyphMetrics[n];
        int n2 = 0;
        while (n2 < n) {
            this.glyphVisible[n2] = true;
            ++n2;
        }
    }

    public GVTFont getFont() {
        return this.gvtFont;
    }

    public FontRenderContext getFontRenderContext() {
        return this.awtGlyphVector.getFontRenderContext();
    }

    public int getGlyphCode(int n) {
        return this.awtGlyphVector.getGlyphCode(n);
    }

    public int[] getGlyphCodes(int n, int n2, int[] nArray) {
        return this.awtGlyphVector.getGlyphCodes(n, n2, nArray);
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n) {
        return this.awtGlyphVector.getGlyphJustificationInfo(n);
    }

    public Rectangle2D getBounds2D(AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
        if (this.bounds2D != null && TextPaintInfo.equivilent(textPaintInfo, this.cacheTPI)) {
            return this.bounds2D;
        }
        if (textPaintInfo == null) {
            return null;
        }
        if (!textPaintInfo.visible) {
            return null;
        }
        this.cacheTPI = new TextPaintInfo(textPaintInfo);
        Shape shape = null;
        if (textPaintInfo.fillPaint != null) {
            shape = this.getOutline();
            this.bounds2D = shape.getBounds2D();
        }
        Stroke stroke = textPaintInfo.strokeStroke;
        Paint paint = textPaintInfo.strokePaint;
        if (stroke != null && paint != null) {
            if (shape == null) {
                shape = this.getOutline();
            }
            Rectangle2D rectangle2D = stroke.createStrokedShape(shape).getBounds2D();
            this.bounds2D = this.bounds2D == null ? rectangle2D : this.bounds2D.createUnion(rectangle2D);
        }
        if (this.bounds2D == null) {
            return null;
        }
        if (this.bounds2D.getWidth() == 0.0 || this.bounds2D.getHeight() == 0.0) {
            this.bounds2D = null;
        }
        return this.bounds2D;
    }

    public Rectangle2D getLogicalBounds() {
        if (this.logicalBounds == null) {
            this.computeGlyphLogicalBounds();
        }
        return this.logicalBounds;
    }

    public Shape getGlyphLogicalBounds(int n) {
        if (this.glyphLogicalBounds[n] == null && this.glyphVisible[n]) {
            this.computeGlyphLogicalBounds();
        }
        return this.glyphLogicalBounds[n];
    }

    private void computeGlyphLogicalBounds() {
        Cloneable cloneable;
        Cloneable cloneable2;
        Shape[] shapeArray = new Shape[this.getNumGlyphs()];
        boolean[] blArray = new boolean[this.getNumGlyphs()];
        double d = -1.0;
        double d2 = -1.0;
        int n = 0;
        while (n < this.getNumGlyphs()) {
            if (!this.glyphVisible[n]) {
                shapeArray[n] = null;
            } else {
                float f;
                cloneable2 = this.getGlyphTransform(n);
                float f2 = 0.0f;
                float f3 = -this.ascent / this.scaleFactor;
                GVTGlyphMetrics gVTGlyphMetrics = this.getGlyphMetrics(n);
                float f4 = gVTGlyphMetrics.getHorizontalAdvance() / this.scaleFactor;
                Rectangle2D.Double double_ = new Rectangle2D.Double(f2, f3, f4, f = gVTGlyphMetrics.getVerticalAdvance() / this.scaleFactor);
                if (((RectangularShape)double_).isEmpty()) {
                    blArray[n] = n > 0 ? blArray[n - 1] : true;
                } else {
                    Point2D.Double double_2 = new Point2D.Double(double_.getMinX(), double_.getMinY());
                    cloneable = new Point2D.Double(double_.getMaxX(), double_.getMinY());
                    Point2D.Double double_3 = new Point2D.Double(double_.getMinX(), double_.getMaxY());
                    Point2D point2D = this.getGlyphPosition(n);
                    AffineTransform affineTransform = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY());
                    if (cloneable2 != null) {
                        affineTransform.concatenate((AffineTransform)cloneable2);
                    }
                    affineTransform.scale(this.scaleFactor, this.scaleFactor);
                    shapeArray[n] = affineTransform.createTransformedShape(double_);
                    Point2D.Double double_4 = new Point2D.Double();
                    Point2D.Double double_5 = new Point2D.Double();
                    Point2D.Double double_6 = new Point2D.Double();
                    affineTransform.transform(double_2, double_4);
                    affineTransform.transform((Point2D)cloneable, double_5);
                    affineTransform.transform(double_3, double_6);
                    double d3 = ((Point2D)double_4).getX() - ((Point2D)double_5).getX();
                    double d4 = ((Point2D)double_4).getX() - ((Point2D)double_6).getX();
                    double d5 = ((Point2D)double_4).getY() - ((Point2D)double_5).getY();
                    double d6 = ((Point2D)double_4).getY() - ((Point2D)double_6).getY();
                    blArray[n] = !(Math.abs(d3) < 0.001 && Math.abs(d6) < 0.001 || Math.abs(d4) < 0.001 && Math.abs(d5) < 0.001);
                    Rectangle2D rectangle2D = shapeArray[n].getBounds2D();
                    if (rectangle2D.getWidth() > d) {
                        d = rectangle2D.getWidth();
                    }
                    if (rectangle2D.getHeight() > d2) {
                        d2 = rectangle2D.getHeight();
                    }
                }
            }
            ++n;
        }
        cloneable2 = new GeneralPath();
        int n2 = 0;
        while (n2 < this.getNumGlyphs()) {
            if (shapeArray[n2] != null) {
                ((Path2D)cloneable2).append(shapeArray[n2], false);
            }
            ++n2;
        }
        this.logicalBounds = ((Path2D.Float)cloneable2).getBounds2D();
        if (this.logicalBounds.getHeight() < d2 * 1.5) {
            int n3 = 0;
            while (n3 < this.getNumGlyphs()) {
                if (!blArray[n3] && shapeArray[n3] != null) {
                    double d7;
                    Rectangle2D rectangle2D = shapeArray[n3].getBounds2D();
                    double d8 = rectangle2D.getMinX();
                    double d9 = rectangle2D.getWidth();
                    if (n3 < this.getNumGlyphs() - 1 && shapeArray[n3 + 1] != null && ((RectangularShape)(cloneable = shapeArray[n3 + 1].getBounds2D())).getX() > d8 && (d7 = ((RectangularShape)cloneable).getX() - d8) < d9 * 1.15 && d7 > d9 * 0.85) {
                        double d10 = (d7 - d9) * 0.5;
                        d9 += d10;
                        ((Rectangle2D)cloneable).setRect(((RectangularShape)cloneable).getX() - d10, ((RectangularShape)cloneable).getY(), ((RectangularShape)cloneable).getWidth() + d10, ((RectangularShape)cloneable).getHeight());
                    }
                    shapeArray[n3] = new Rectangle2D.Double(d8, this.logicalBounds.getMinY(), d9, this.logicalBounds.getHeight());
                }
                ++n3;
            }
        } else if (this.logicalBounds.getWidth() < d * 1.5) {
            int n4 = 0;
            while (n4 < this.getNumGlyphs()) {
                if (!blArray[n4] && shapeArray[n4] != null) {
                    double d11;
                    Rectangle2D rectangle2D = shapeArray[n4].getBounds2D();
                    double d12 = rectangle2D.getMinY();
                    double d13 = rectangle2D.getHeight();
                    if (n4 < this.getNumGlyphs() - 1 && shapeArray[n4 + 1] != null && ((RectangularShape)(cloneable = shapeArray[n4 + 1].getBounds2D())).getY() > d12 && (d11 = ((RectangularShape)cloneable).getY() - d12) < d13 * 1.15 && d11 > d13 * 0.85) {
                        double d14 = (d11 - d13) * 0.5;
                        d13 += d14;
                        ((Rectangle2D)cloneable).setRect(((RectangularShape)cloneable).getX(), ((RectangularShape)cloneable).getY() - d14, ((RectangularShape)cloneable).getWidth(), ((RectangularShape)cloneable).getHeight() + d14);
                    }
                    shapeArray[n4] = new Rectangle2D.Double(this.logicalBounds.getMinX(), d12, this.logicalBounds.getWidth(), d13);
                }
                ++n4;
            }
        }
        int n5 = 0;
        while (n5 < this.getNumGlyphs()) {
            this.glyphLogicalBounds[n5] = shapeArray[n5];
            ++n5;
        }
    }

    public GVTGlyphMetrics getGlyphMetrics(int n) {
        if (this.glyphMetrics[n] != null) {
            return this.glyphMetrics[n];
        }
        Point2D point2D = this.defaultGlyphPositions[n];
        char c = this.ci.setIndex(this.ci.getBeginIndex() + n);
        this.ci.setIndex(this.ci.getBeginIndex());
        AWTGlyphGeometryCache.Value value = AWTGVTFont.getGlyphGeometry(this.gvtFont, c, this.awtGlyphVector, n, point2D);
        Rectangle2D rectangle2D = value.getBounds2D();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() * (double)this.scaleFactor, rectangle2D.getY() * (double)this.scaleFactor, rectangle2D.getWidth() * (double)this.scaleFactor, rectangle2D.getHeight() * (double)this.scaleFactor);
        float f = (float)(this.defaultGlyphPositions[n + 1].getX() - this.defaultGlyphPositions[n].getX());
        this.glyphMetrics[n] = new GVTGlyphMetrics(f * this.scaleFactor, this.ascent + this.descent, double_, 0);
        return this.glyphMetrics[n];
    }

    public Shape getGlyphOutline(int n) {
        if (this.glyphOutlines[n] == null) {
            Point2D point2D = this.defaultGlyphPositions[n];
            char c = this.ci.setIndex(this.ci.getBeginIndex() + n);
            this.ci.setIndex(this.ci.getBeginIndex());
            AWTGlyphGeometryCache.Value value = AWTGVTFont.getGlyphGeometry(this.gvtFont, c, this.awtGlyphVector, n, point2D);
            Shape shape = value.getOutline();
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.getGlyphPosition(n).getX(), this.getGlyphPosition(n).getY());
            AffineTransform affineTransform2 = this.getGlyphTransform(n);
            if (affineTransform2 != null) {
                affineTransform.concatenate(affineTransform2);
            }
            affineTransform.scale(this.scaleFactor, this.scaleFactor);
            this.glyphOutlines[n] = affineTransform.createTransformedShape(shape);
        }
        return this.glyphOutlines[n];
    }

    static boolean outlinesPositioned() {
        return outlinesPositioned;
    }

    public Point2D getGlyphPosition(int n) {
        return this.glyphPositions[n];
    }

    public float[] getGlyphPositions(int n, int n2, float[] fArray) {
        if (fArray == null) {
            fArray = new float[n2 * 2];
        }
        int n3 = n;
        while (n3 < n + n2) {
            Point2D point2D = this.getGlyphPosition(n3);
            fArray[(n3 - n) * 2] = (float)point2D.getX();
            fArray[(n3 - n) * 2 + 1] = (float)point2D.getY();
            ++n3;
        }
        return fArray;
    }

    public AffineTransform getGlyphTransform(int n) {
        return this.glyphTransforms[n];
    }

    public Shape getGlyphVisualBounds(int n) {
        if (this.glyphVisualBounds[n] == null) {
            Point2D point2D = this.defaultGlyphPositions[n];
            char c = this.ci.setIndex(this.ci.getBeginIndex() + n);
            this.ci.setIndex(this.ci.getBeginIndex());
            AWTGlyphGeometryCache.Value value = AWTGVTFont.getGlyphGeometry(this.gvtFont, c, this.awtGlyphVector, n, point2D);
            Rectangle2D rectangle2D = value.getOutlineBounds2D();
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.getGlyphPosition(n).getX(), this.getGlyphPosition(n).getY());
            AffineTransform affineTransform2 = this.getGlyphTransform(n);
            if (affineTransform2 != null) {
                affineTransform.concatenate(affineTransform2);
            }
            affineTransform.scale(this.scaleFactor, this.scaleFactor);
            this.glyphVisualBounds[n] = affineTransform.createTransformedShape(rectangle2D);
        }
        return this.glyphVisualBounds[n];
    }

    public int getNumGlyphs() {
        return this.awtGlyphVector.getNumGlyphs();
    }

    public Shape getOutline() {
        if (this.outline != null) {
            return this.outline;
        }
        this.outline = new GeneralPath();
        int n = 0;
        while (n < this.getNumGlyphs()) {
            if (this.glyphVisible[n]) {
                Shape shape = this.getGlyphOutline(n);
                this.outline.append(shape, false);
            }
            ++n;
        }
        return this.outline;
    }

    public Shape getOutline(float f, float f2) {
        Shape shape = this.getOutline();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        shape = affineTransform.createTransformedShape(shape);
        return shape;
    }

    public Rectangle2D getGeometricBounds() {
        if (this.visualBounds == null) {
            Shape shape = this.getOutline();
            this.visualBounds = shape.getBounds2D();
        }
        return this.visualBounds;
    }

    public void performDefaultLayout() {
        Point2D point2D;
        if (this.defaultGlyphPositions == null) {
            this.awtGlyphVector.performDefaultLayout();
            this.defaultGlyphPositions = new Point2D.Float[this.getNumGlyphs() + 1];
            int n = 0;
            while (n <= this.getNumGlyphs()) {
                this.defaultGlyphPositions[n] = this.awtGlyphVector.getGlyphPosition(n);
                ++n;
            }
        }
        this.outline = null;
        this.visualBounds = null;
        this.logicalBounds = null;
        this.bounds2D = null;
        float f = 0.0f;
        int n = 0;
        while (n < this.getNumGlyphs()) {
            this.glyphTransforms[n] = null;
            this.glyphVisualBounds[n] = null;
            this.glyphLogicalBounds[n] = null;
            this.glyphOutlines[n] = null;
            this.glyphMetrics[n] = null;
            point2D = this.defaultGlyphPositions[n];
            float f2 = (float)(point2D.getX() * (double)this.scaleFactor - (double)f);
            float f3 = (float)(point2D.getY() * (double)this.scaleFactor);
            char c = this.ci.setIndex(n + this.ci.getBeginIndex());
            if (this.glyphPositions[n] == null) {
                this.glyphPositions[n] = new Point2D.Float(f2, f3);
            } else {
                this.glyphPositions[n].x = f2;
                this.glyphPositions[n].y = f3;
            }
            ++n;
        }
        point2D = this.defaultGlyphPositions[n];
        this.glyphPositions[n] = new Point2D.Float((float)(point2D.getX() * (double)this.scaleFactor - (double)f), (float)(point2D.getY() * (double)this.scaleFactor));
    }

    public void setGlyphPosition(int n, Point2D point2D) {
        this.glyphPositions[n].x = (float)point2D.getX();
        this.glyphPositions[n].y = (float)point2D.getY();
        this.outline = null;
        this.visualBounds = null;
        this.logicalBounds = null;
        this.bounds2D = null;
        if (n != this.getNumGlyphs()) {
            this.glyphVisualBounds[n] = null;
            this.glyphLogicalBounds[n] = null;
            this.glyphOutlines[n] = null;
            this.glyphMetrics[n] = null;
        }
    }

    public void setGlyphTransform(int n, AffineTransform affineTransform) {
        this.glyphTransforms[n] = affineTransform;
        this.outline = null;
        this.visualBounds = null;
        this.logicalBounds = null;
        this.bounds2D = null;
        this.glyphVisualBounds[n] = null;
        this.glyphLogicalBounds[n] = null;
        this.glyphOutlines[n] = null;
        this.glyphMetrics[n] = null;
    }

    public void setGlyphVisible(int n, boolean bl) {
        if (bl == this.glyphVisible[n]) {
            return;
        }
        this.glyphVisible[n] = bl;
        this.outline = null;
        this.visualBounds = null;
        this.logicalBounds = null;
        this.bounds2D = null;
        this.glyphVisualBounds[n] = null;
        this.glyphLogicalBounds[n] = null;
        this.glyphOutlines[n] = null;
        this.glyphMetrics[n] = null;
    }

    public boolean isGlyphVisible(int n) {
        return this.glyphVisible[n];
    }

    public int getCharacterCount(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.getNumGlyphs()) {
            n2 = this.getNumGlyphs() - 1;
        }
        int n3 = 0;
        int n4 = n + this.ci.getBeginIndex();
        int n5 = n2 + this.ci.getBeginIndex();
        char c = this.ci.setIndex(n4);
        while (this.ci.getIndex() <= n5) {
            n3 = ArabicTextHandler.isLigature(c) ? (n3 += ArabicTextHandler.getNumChars(c)) : ++n3;
            c = this.ci.next();
        }
        return n3;
    }

    public void draw(Graphics2D graphics2D, AttributedCharacterIterator attributedCharacterIterator) {
        Object object;
        int n;
        int n2 = this.getNumGlyphs();
        attributedCharacterIterator.first();
        TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO);
        if (textPaintInfo == null) {
            return;
        }
        if (!textPaintInfo.visible) {
            return;
        }
        Paint paint = textPaintInfo.fillPaint;
        Stroke stroke = textPaintInfo.strokeStroke;
        Paint paint2 = textPaintInfo.strokePaint;
        if (paint == null && (paint2 == null || stroke == null)) {
            return;
        }
        boolean bl = drawGlyphVectorWorks;
        if (bl && stroke != null && paint2 != null) {
            bl = false;
        }
        if (bl && paint != null && !(paint instanceof Color)) {
            bl = false;
        }
        if (bl) {
            Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            Object object3 = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
            if (object2 == RenderingHints.VALUE_TEXT_ANTIALIAS_ON && object3 == RenderingHints.VALUE_STROKE_PURE) {
                bl = false;
            }
        }
        if (bl && (((n = ((AffineTransform)(object = graphics2D.getTransform())).getType()) & 0x20) != 0 || (n & 0x10) != 0)) {
            bl = false;
        }
        if (bl) {
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                if (!this.glyphVisible[n3]) {
                    bl = false;
                    break;
                }
                AffineTransform affineTransform = this.glyphTransforms[n3];
                if (!(affineTransform == null || ((n4 = affineTransform.getType()) & 0xFFFFFFFE) == 0 || glyphVectorTransformWorks && (n4 & 0x20) == 0 && (n4 & 0x10) == 0)) {
                    bl = false;
                    break;
                }
                ++n3;
            }
        }
        if (bl) {
            double d = this.scaleFactor;
            double[] dArray = new double[6];
            int n5 = 0;
            while (n5 < n2) {
                Point2D point2D = this.glyphPositions[n5];
                double d2 = ((Point2D)point2D).getX();
                double d3 = ((Point2D)point2D).getY();
                AffineTransform affineTransform = this.glyphTransforms[n5];
                if (affineTransform != null) {
                    affineTransform.getMatrix(dArray);
                    d2 += dArray[4];
                    d3 += dArray[5];
                    if (dArray[0] != 1.0 || dArray[1] != 0.0 || dArray[2] != 0.0 || dArray[3] != 1.0) {
                        dArray[4] = 0.0;
                        dArray[5] = 0.0;
                        affineTransform = new AffineTransform(dArray);
                    } else {
                        affineTransform = null;
                    }
                }
                point2D = new Point2D.Double(d2 / d, d3 / d);
                this.awtGlyphVector.setGlyphPosition(n5, point2D);
                this.awtGlyphVector.setGlyphTransform(n5, affineTransform);
                ++n5;
            }
            graphics2D.scale(d, d);
            graphics2D.setPaint(paint);
            graphics2D.drawGlyphVector(this.awtGlyphVector, 0.0f, 0.0f);
            graphics2D.scale(1.0 / d, 1.0 / d);
            int n6 = 0;
            while (n6 < n2) {
                Point2D point2D = this.defaultGlyphPositions[n6];
                this.awtGlyphVector.setGlyphPosition(n6, point2D);
                this.awtGlyphVector.setGlyphTransform(n6, null);
                ++n6;
            }
        } else {
            object = this.getOutline();
            if (paint != null) {
                graphics2D.setPaint(paint);
                graphics2D.fill((Shape)object);
            }
            if (stroke != null && paint2 != null) {
                graphics2D.setStroke(stroke);
                graphics2D.setPaint(paint2);
                graphics2D.draw((Shape)object);
            }
        }
    }

    static {
        String string = System.getProperty("java.specification.version");
        if ("1.4".compareTo(string) <= 0) {
            outlinesPositioned = true;
            drawGlyphVectorWorks = true;
            glyphVectorTransformWorks = true;
        } else if ("Mac OS X".equals(System.getProperty("os.name"))) {
            outlinesPositioned = true;
            drawGlyphVectorWorks = false;
            glyphVectorTransformWorks = false;
        } else {
            outlinesPositioned = false;
            drawGlyphVectorWorks = true;
            glyphVectorTransformWorks = false;
        }
    }
}

