/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.timeline.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.gemoc.timeline.model.Branch;
import org.eclipse.gemoc.timeline.model.ITimelineWindowListener;
import org.eclipse.gemoc.timeline.view.ITimelineListener;
import org.eclipse.gemoc.timeline.view.ITimelineProvider;

public class TimelineWindow
implements ITimelineListener {
    private ITimelineProvider provider;
    private int maxTimelineIndex;
    private final List<ITimelineWindowListener> listeners = new ArrayList<ITimelineWindowListener>();
    private int start;
    private int length;

    public TimelineWindow(ITimelineProvider provider) {
        this.setProvider(provider, 0);
    }

    public ITimelineProvider getProvider() {
        return this.provider;
    }

    public List<Branch> getBranches() {
        ArrayList<Branch> res = new ArrayList<Branch>();
        if (this.getProvider() != null) {
            int numberOfBranches = this.provider.getNumberOfBranches();
            int branch = 0;
            while (branch < numberOfBranches) {
                if (this.isBranchVisibleInWindow(branch)) {
                    res.add(new Branch(this, branch));
                }
                ++branch;
            }
        }
        Collections.sort(res);
        return res;
    }

    private boolean isBranchVisibleInWindow(int branch) {
        return this.provider.getStart(branch) <= this.getEnd() && this.provider.getEnd(branch) > this.getStart();
    }

    public int getMaxTimelineIndex() {
        return this.maxTimelineIndex;
    }

    public int getMaxSelectedIndex(int branch) {
        int res = 0;
        int begin = Math.max(this.getStart(), this.provider.getStart(branch));
        int end = Math.min(this.getEnd(), this.provider.getEnd(branch));
        int choice = begin;
        while (choice < end) {
            int selectedPossibleStep = this.getProvider().getSelectedPossibleStep(branch, choice);
            res = Math.max(res, selectedPossibleStep);
            ++choice;
        }
        return res;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        if (this.start != start) {
            this.start = start;
            for (ITimelineWindowListener listener : this.getListeners()) {
                listener.startChanged(start);
            }
        }
    }

    public int getLength() {
        return this.length;
    }

    public int getEnd() {
        return this.getStart() + this.getLength();
    }

    public void setLength(int length) {
        if (this.length != length) {
            this.length = length;
            for (ITimelineWindowListener listener : this.getListeners()) {
                listener.lengthChanged(length);
            }
        }
    }

    public void setProvider(ITimelineProvider newProvider, int newStart) {
        if (this.provider != null && !this.provider.equals(newProvider) || newProvider != null && !newProvider.equals(this.provider)) {
            if (this.provider != null) {
                this.provider.removeTimelineListener(this);
            }
            this.provider = newProvider;
            this.maxTimelineIndex = 0;
            if (this.provider != null) {
                int numberOfBranches = this.provider.getNumberOfBranches();
                int branch = 0;
                while (branch < numberOfBranches) {
                    this.maxTimelineIndex = Math.max(this.maxTimelineIndex, this.provider.getEnd(branch) - 1);
                    ++branch;
                }
                this.provider.addTimelineListener(this);
                for (ITimelineWindowListener listener : this.getListeners()) {
                    listener.providerChanged(newProvider);
                }
                if (newStart >= 0 && newStart <= this.getMaxTimelineIndex()) {
                    this.setStart(newStart);
                }
            }
        }
    }

    private boolean isInWindow(int index) {
        return this.getStart() <= index && index < this.getEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimelineWindowListener(ITimelineWindowListener listener) {
        List<ITimelineWindowListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimelineWindowListener(ITimelineWindowListener listener) {
        List<ITimelineWindowListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void startChanged(int branch, int newStart) {
        if (this.isInWindow(newStart)) {
            for (ITimelineWindowListener listener : this.getListeners()) {
                listener.startChanged(branch, newStart);
            }
        }
    }

    @Override
    public void endChanged(int branch, int end) {
        this.maxTimelineIndex = Math.max(this.maxTimelineIndex, end);
        if (this.isInWindow(end)) {
            for (ITimelineWindowListener listener : this.getListeners()) {
                listener.endChanged(branch, end);
            }
        }
    }

    @Override
    public void textAtChanged(int branch, String text) {
        if (this.isBranchVisibleInWindow(branch)) {
            for (ITimelineWindowListener listener : this.getListeners()) {
                listener.textAtChanged(branch, text);
            }
        }
    }

    @Override
    public void numberOfPossibleStepsAtChanged(int branch, int index, int numberOfPossibleStep) {
        if (this.isInWindow(index)) {
            for (ITimelineWindowListener listener : this.getListeners()) {
                listener.numberOfPossibleStepsAtChanged(branch, index, numberOfPossibleStep);
            }
        }
    }

    @Override
    public void textAtChanged(int branch, int index, String text) {
        if (this.isInWindow(index)) {
            for (ITimelineWindowListener listener : this.getListeners()) {
                listener.textAtChanged(branch, index, text);
            }
        }
    }

    @Override
    public void atChanged(int branch, int index, int possibleStep, Object object) {
        if (this.isInWindow(index)) {
            for (ITimelineWindowListener listener : this.getListeners()) {
                listener.atChanged(branch, index, possibleStep, object);
            }
        }
    }

    @Override
    public void isSelectedChanged(int branch, int index, int possibleStep, boolean selected) {
        if (this.isInWindow(index)) {
            for (ITimelineWindowListener listener : this.getListeners()) {
                listener.isSelectedChanged(branch, index, possibleStep, selected);
            }
        }
    }

    @Override
    public void textAtChanged(int branch, int index, int possibleStep, String text) {
        if (this.isInWindow(index)) {
            for (ITimelineWindowListener listener : this.getListeners()) {
                listener.textAtChanged(branch, index, possibleStep, text);
            }
        }
    }

    @Override
    public void followingsChanged(int branch, int index, int possibleStep, int[][] followings) {
        if (this.isInWindow(index) && this.isInWindow(index + 1)) {
            for (ITimelineWindowListener listener : this.getListeners()) {
                listener.followingsChanged(branch, index, possibleStep, followings);
            }
        }
    }

    @Override
    public void precedingsChanged(int branch, int index, int possibleStep, int[][] precedings) {
        if (this.isInWindow(index - 1) && this.isInWindow(index)) {
            for (ITimelineWindowListener listener : this.getListeners()) {
                listener.precedingsChanged(branch, index, possibleStep, precedings);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ITimelineWindowListener> getListeners() {
        ArrayList<ITimelineWindowListener> l;
        List<ITimelineWindowListener> list = this.listeners;
        synchronized (list) {
            l = new ArrayList<ITimelineWindowListener>(this.listeners);
        }
        return l;
    }
}

