/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.engine.ui.provider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.gemoc.dsl.debug.Variable;
import org.eclipse.gemoc.dsl.debug.ide.adapter.value.DSLObjectValue;
import org.eclipse.gemoc.dsl.debug.ide.adapter.variable.DSLObjectVariable;
import org.eclipse.gemoc.dsl.debug.ide.ui.provider.OverlayImageDescriptor;
import org.eclipse.gemoc.executionframework.debugger.DefaultDynamicPartAccessor;
import org.eclipse.gemoc.executionframework.debugger.IDynamicPartAccessor;
import org.eclipse.gemoc.executionframework.engine.ui.Activator;
import org.eclipse.gemoc.xdsmlframework.commons.DynamicAnnotationHelper;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class DSLVariableLabelDecorator
extends BaseLabelProvider
implements ILabelDecorator {
    protected final Map<ImageDescriptor, Image> imagesCache = new HashMap<ImageDescriptor, Image>();
    private final Image staticDataLocked = new Image((Device)Display.getDefault(), Activator.getImageDescriptor("icons/full/deco16/bottomright_lock_closed.gif").getImageData(100));
    private final Image staticDataUnlocked = new Image((Device)Display.getDefault(), Activator.getImageDescriptor("icons/full/deco16/bottomright_lock_open.gif").getImageData(100));
    private final Image dynamicData = new Image((Device)Display.getDefault(), Activator.getImageDescriptor("icons/full/deco16/topright_lock.gif").getImageData(100));
    private final IDynamicPartAccessor dynamicPartAccessor = new DefaultDynamicPartAccessor();

    public Image decorateImage(Image image, Object element) {
        Image res;
        Image img = image;
        if (image == null) {
            return image;
        }
        if (element instanceof Variable) {
            Variable v = (Variable)element;
            boolean isDynamic = v.getDeclarationType().equals("mutable data");
            res = this.getImageForMutableType(img, isDynamic, v.isSupportModifications());
        } else if (element instanceof DSLObjectVariable) {
            DSLObjectVariable dslVar = (DSLObjectVariable)element;
            boolean isDynamic = false;
            if (dslVar.getObject() instanceof EObject) {
                isDynamic = this.dynamicPartAccessor.isDynamic((EObject)dslVar.getObject());
            } else if (dslVar.getObject() instanceof EObjectContainmentEList) {
                EObjectContainmentEList l = (EObjectContainmentEList)dslVar.getObject();
                isDynamic = this.dynamicPartAccessor.isDynamic(l.getEObject());
            } else if (dslVar.getParentValue() != null && dslVar.getParentValue().getValue() instanceof EObject) {
                EStructuralFeature p = null;
                try {
                    p = ((EObject)dslVar.getParentValue().getValue()).eClass().getEStructuralFeature(dslVar.getName());
                    if (p != null) {
                        isDynamic = DynamicAnnotationHelper.isDynamic((EStructuralFeature)p);
                    }
                }
                catch (DebugException debugException) {
                    // empty catch block
                }
            }
            res = this.getImageForMutableType(image, isDynamic, dslVar.supportsValueModification());
        } else if (element instanceof DSLObjectValue) {
            DSLObjectValue dslVar = (DSLObjectValue)element;
            res = this.getImageForMutableType(image, false, false);
        } else {
            res = image;
        }
        return res;
    }

    protected Image getImageForMutableType(Image baseImage, boolean isDynamic, boolean supportModification) {
        OverlayImageDescriptor descriptor = !isDynamic ? (supportModification ? new OverlayImageDescriptor(baseImage, this.staticDataUnlocked) : new OverlayImageDescriptor(baseImage, this.staticDataLocked)) : new OverlayImageDescriptor(baseImage, this.dynamicData);
        Image cachedImage = this.imagesCache.get(descriptor);
        if (cachedImage == null) {
            cachedImage = descriptor.createImage();
            this.imagesCache.put((ImageDescriptor)descriptor, cachedImage);
        }
        Image res = cachedImage;
        return res;
    }

    public String decorateText(String text, Object element) {
        String res = text;
        return res;
    }

    public void dispose() {
        this.staticDataLocked.dispose();
        this.staticDataUnlocked.dispose();
        for (Image cachedImage : this.imagesCache.values()) {
            cachedImage.dispose();
        }
        super.dispose();
    }
}

