/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.builder;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

/**
 * A dummy data object containing representing an error during the build.
 */
@Data
@SuppressWarnings("all")
public class BuilderError {
  /**
   * The error message
   */
  private final String message;

  /**
   * The {@link EObject} to which the message is associated
   */
  private final EObject location;

  public BuilderError(final String message, final EObject location) {
    super();
    this.message = message;
    this.location = location;
  }

  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.message== null) ? 0 : this.message.hashCode());
    return prime * result + ((this.location== null) ? 0 : this.location.hashCode());
  }

  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    BuilderError other = (BuilderError) obj;
    if (this.message == null) {
      if (other.message != null)
        return false;
    } else if (!this.message.equals(other.message))
      return false;
    if (this.location == null) {
      if (other.location != null)
        return false;
    } else if (!this.location.equals(other.location))
      return false;
    return true;
  }

  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("message", this.message);
    b.add("location", this.location);
    return b.toString();
  }

  @Pure
  public String getMessage() {
    return this.message;
  }

  @Pure
  public EObject getLocation() {
    return this.location;
  }
}
