/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.processors;

import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;

/**
 * Just a dummy implementation of {@link MelangeProcessor} that automatically
 * browses the current {@link Resource} and dispatches to the most precise
 * method depending on the actual type of the current {@link EObject}.
 */
@SuppressWarnings("all")
public class DispatchMelangeProcessor implements MelangeProcessor {
  @Override
  public void preProcess(final EObject object, final boolean preLinkingPhase) {
    this._preProcess(object, preLinkingPhase);
  }

  public void _preProcess(final EObject object, final boolean preLinkingPhase) {
    if ((object != null)) {
      final Consumer<EObject> _function = (EObject it) -> {
        this.preProcess(it, preLinkingPhase);
      };
      object.eContents().forEach(_function);
    }
  }

  @Override
  public void postProcess(final EObject object) {
    this._postProcess(object);
  }

  public void _postProcess(final EObject object) {
    if ((object != null)) {
      final Consumer<EObject> _function = (EObject it) -> {
        this.postProcess(it);
      };
      object.eContents().forEach(_function);
    }
  }
}
