/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.debugger;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gemoc.executionframework.debugger.IDynamicPartAccessor;
import org.eclipse.gemoc.executionframework.debugger.MutableField;
import org.eclipse.gemoc.xdsmlframework.commons.DynamicAnnotationHelper;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

public class DefaultDynamicPartAccessor
implements IDynamicPartAccessor {
    Map<EClass, Integer> counters = new HashMap<EClass, Integer>();

    @Override
    public List<MutableField> extractMutableField(EObject eObject) {
        ArrayList<MutableField> result = new ArrayList<MutableField>();
        if (eObject == null) {
            return result;
        }
        List mutableProperties = eObject.eClass().getEAllStructuralFeatures().stream().filter(p -> DynamicAnnotationHelper.isDynamic((EStructuralFeature)p)).collect(Collectors.toList());
        for (EStructuralFeature feature : mutableProperties) {
            Supplier<Object> getter = () -> eObject.eGet(feature);
            Consumer<Object> setter = newValue -> eObject.eSet(feature, newValue);
            MutableField field = new MutableField(String.valueOf(feature.getName()) + " (" + this.getName(eObject) + " :" + eObject.eClass().getName() + ")", eObject, feature, getter, setter);
            result.add(field);
        }
        return result;
    }

    private String getName(EObject eObject) {
        DefaultDeclarativeQualifiedNameProvider nameprovider = new DefaultDeclarativeQualifiedNameProvider();
        EAttribute idProp = eObject.eClass().getEIDAttribute();
        if (idProp != null) {
            Object id = eObject.eGet((EStructuralFeature)idProp);
            if (id != null) {
                DecimalFormat formatter = new DecimalFormat("00");
                String idString = id.toString();
                if (id instanceof Integer) {
                    idString = formatter.format((Integer)id);
                }
                return String.valueOf(eObject.eClass().getName()) + "_" + idString;
            }
            if (!this.counters.containsKey(eObject.eClass())) {
                this.counters.put(eObject.eClass(), 0);
            }
            Integer counter = this.counters.get(eObject.eClass());
            this.counters.put(eObject.eClass(), counter + 1);
            return String.valueOf(eObject.eClass().getName()) + "_" + counter;
        }
        QualifiedName qname = nameprovider.getFullyQualifiedName(eObject);
        if (qname == null) {
            return eObject.toString();
        }
        return qname.toString();
    }

    @Override
    public boolean isDynamic(EObject obj) {
        if (obj == null) {
            return false;
        }
        return DynamicAnnotationHelper.isDynamic((EClass)obj.eClass());
    }
}

