/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.client.internal;

import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpUpgrader;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.WebSocketConstants;
import org.eclipse.jetty.websocket.core.client.CoreClientUpgradeRequest;

public class HttpUpgraderOverHTTP2
implements HttpUpgrader {
    private static final PreEncodedHttpField WS_VERSION_FIELD = new PreEncodedHttpField(HttpHeader.SEC_WEBSOCKET_VERSION, WebSocketConstants.SPEC_VERSION_STRING);
    private final CoreClientUpgradeRequest clientUpgradeRequest;

    public HttpUpgraderOverHTTP2(CoreClientUpgradeRequest clientUpgradeRequest) {
        this.clientUpgradeRequest = clientUpgradeRequest;
    }

    public void prepare(HttpRequest request) {
        request.upgradeProtocol("websocket").method(HttpMethod.CONNECT).headers(headers -> headers.put((HttpField)WS_VERSION_FIELD));
        this.clientUpgradeRequest.requestComplete();
    }

    public void upgrade(HttpResponse response, EndPoint endPoint, Callback callback) {
        try {
            this.clientUpgradeRequest.upgrade(response, endPoint);
            callback.succeeded();
        }
        catch (Throwable x) {
            callback.failed(x);
        }
    }
}

