/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.timeline.editpart;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gemoc.timeline.editpart.BranchEditPart;
import org.eclipse.gemoc.timeline.editpart.ChoiceEditPart;
import org.eclipse.gemoc.timeline.editpart.ConnectionEditPart;
import org.eclipse.gemoc.timeline.editpart.PossibleStepEditPart;
import org.eclipse.gemoc.timeline.editpart.TimelineWindowEditPart;
import org.eclipse.gemoc.timeline.model.Branch;
import org.eclipse.gemoc.timeline.model.Choice;
import org.eclipse.gemoc.timeline.model.Connection;
import org.eclipse.gemoc.timeline.model.PossibleStep;
import org.eclipse.gemoc.timeline.model.TimelineWindow;

public class TimelineEditPartFactory
implements EditPartFactory {
    private final boolean withLabel;

    public TimelineEditPartFactory(boolean withLabel) {
        this.withLabel = withLabel;
    }

    public EditPart createEditPart(EditPart context, Object model) {
        Object res;
        if (model instanceof PossibleStep) {
            res = new PossibleStepEditPart(this.withLabel);
        } else if (model instanceof Connection) {
            res = new ConnectionEditPart();
        } else if (model instanceof Choice) {
            res = new ChoiceEditPart();
        } else if (model instanceof Branch) {
            res = new BranchEditPart();
        } else if (model instanceof TimelineWindow) {
            res = new TimelineWindowEditPart();
        } else {
            throw new IllegalStateException("don't know what to do with " + model.getClass().getName());
        }
        res.setModel(model);
        return res;
    }
}

