/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.interpreter.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.ast.AstPackage;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecoretools.ale.core.env.ClosedAleEnvironmentException;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.env.IBehaviors;
import org.eclipse.emf.ecoretools.ale.core.interpreter.DiagnosticLogger;
import org.eclipse.emf.ecoretools.ale.core.interpreter.IAleInterpreter;
import org.eclipse.emf.ecoretools.ale.core.interpreter.ILookupEngineListener;
import org.eclipse.emf.ecoretools.ale.core.interpreter.IServiceCallListener;
import org.eclipse.emf.ecoretools.ale.core.interpreter.impl.DebugQueryEnvironment;
import org.eclipse.emf.ecoretools.ale.core.interpreter.impl.OptimizedEvaluationResult;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.impl.AleEnvironmentClassLoading;
import org.eclipse.emf.ecoretools.ale.core.interpreter.notapi.AleEngine;
import org.eclipse.emf.ecoretools.ale.core.interpreter.notapi.EvalEnvironment;
import org.eclipse.emf.ecoretools.ale.core.interpreter.services.EvalBodyService;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationPackage;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.sirius.common.tools.api.interpreter.ClassLoading;
import org.eclipse.sirius.common.tools.api.interpreter.ClassLoadingCallback;
import org.eclipse.sirius.common.tools.api.interpreter.EPackageLoadingCallback;
import org.eclipse.sirius.common.tools.api.interpreter.IEvaluationResult;
import org.eclipse.sirius.common.tools.api.interpreter.JavaExtensionsManager;

public class AleInterpreter
implements IAleInterpreter,
AutoCloseable {
    public static final String NO_MAIN_ERROR = "No operation with @main found";
    private IQueryEnvironment queryEnvironment;
    private JavaExtensionsManager javaExtensions;
    private EPackageLoadingCallback ePackageCallBack;
    private DiagnosticLogger logger;
    private List<IServiceCallListener> serviceListeners;
    private AleEngine currentEngine;
    private IAleEnvironment environment;
    protected boolean isClosed = false;
    private final ClassLoadingCallback callback = new ClassLoadingCallback(){

        public void loaded(String qualifiedName, Class<?> clazz) {
            ServiceUtils.registerServices((IQueryEnvironment)AleInterpreter.this.queryEnvironment, (Set)ServiceUtils.getServices((IReadOnlyQueryEnvironment)AleInterpreter.this.queryEnvironment, clazz));
        }

        public void notFound(String qualifiedName) {
        }

        public void unloaded(String qualifiedName, Class<?> clazz) {
            ServiceUtils.removeServices((IQueryEnvironment)AleInterpreter.this.queryEnvironment, (Set)ServiceUtils.getServices((IReadOnlyQueryEnvironment)AleInterpreter.this.queryEnvironment, clazz));
        }
    };

    public AleInterpreter(IAleEnvironment environment, IQueryEnvironment context) {
        this(environment, context, false);
    }

    public AleInterpreter(IAleEnvironment environment, IQueryEnvironment context, boolean isDebug) {
        this.environment = environment;
        this.queryEnvironment = isDebug ? AleInterpreter.toDebugContext(context) : context;
        this.queryEnvironment.registerEPackage((EPackage)ImplementationPackage.eINSTANCE);
        this.queryEnvironment.registerEPackage((EPackage)AstPackage.eINSTANCE);
        this.ePackageCallBack = new EPackageLoadingCallback(){

            public void loaded(String nsURI, EPackage pak) {
                AleInterpreter.this.queryEnvironment.registerEPackage(pak);
            }

            public void unloaded(String nsURI, EPackage pak) {
                AleInterpreter.this.queryEnvironment.removeEPackage(pak);
            }
        };
        this.javaExtensions = JavaExtensionsManager.createManagerWithOverride();
        this.javaExtensions.setClassLoadingOverride((ClassLoading)new AleEnvironmentClassLoading());
        this.javaExtensions.addClassLoadingCallBack(this.callback);
        this.javaExtensions.addEPackageCallBack(this.ePackageCallBack);
        this.serviceListeners = new ArrayList<IServiceCallListener>();
    }

    private static IQueryEnvironment toDebugContext(IQueryEnvironment context) {
        DebugQueryEnvironment debugContext = new DebugQueryEnvironment(context);
        debugContext.registerListener(new ILookupEngineListener(){

            @Override
            public void preLookup(String name, IType[] argumentTypes) {
            }

            @Override
            public void postLookup(IService foundService) {
                if (foundService instanceof EvalBodyService) {
                    System.out.println("Call : " + foundService.getLongSignature());
                }
            }
        });
        return debugContext;
    }

    @Override
    public IEvaluationResult eval(EObject caller, Method main, List<Object> args) throws ClosedAleEnvironmentException {
        Objects.requireNonNull(caller, "caller");
        Objects.requireNonNull(main, "main");
        Objects.requireNonNull(args, "args");
        if (this.isClosed) {
            throw new ClosedAleEnvironmentException("AleInterpreter has been closed");
        }
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        IBehaviors behaviors = this.environment.getBehaviors();
        behaviors.getParsedFiles().stream().filter(parseResult -> parseResult.getDiagnostic().getSeverity() != 0).forEach(parseResult -> diagnostic.merge(parseResult.getDiagnostic()));
        this.logger = new DiagnosticLogger(behaviors);
        EvaluationResult evalResult = this.doEval(caller, main, args);
        if (evalResult.getDiagnostic().getSeverity() != 0) {
            diagnostic.merge(evalResult.getDiagnostic());
        }
        return new OptimizedEvaluationResult(Optional.ofNullable(evalResult.getResult()), (Diagnostic)diagnostic);
    }

    private EvaluationResult doEval(EObject caller, Method operation, List<Object> args) {
        this.registerServices(this.environment.getBehaviors().getServices());
        EvalEnvironment env = new EvalEnvironment(this.environment, this.logger, this.serviceListeners);
        ArrayList<Object> inputs = new ArrayList<Object>();
        inputs.add(caller);
        inputs.addAll(args);
        this.initDynamicFeatures(inputs, env);
        this.currentEngine = new AleEngine(env, this.environment);
        return this.currentEngine.eval(caller, operation, args);
    }

    public IQueryEnvironment getQueryEnvironment() {
        return this.queryEnvironment;
    }

    @Override
    public DiagnosticLogger getLogger() {
        return this.logger;
    }

    @Override
    public void registerServices(Iterable<String> services) {
        services.forEach(srv -> this.javaExtensions.addImport(srv));
        this.javaExtensions.reloadIfNeeded();
    }

    @Override
    public void initScope(Set<String> plugins, Set<String> project) {
        this.javaExtensions.updateScope(plugins, project);
        this.javaExtensions.reloadIfNeeded();
    }

    @Override
    public void addServiceListener(IServiceCallListener listener) {
        this.serviceListeners.add(listener);
    }

    @Override
    public List<IServiceCallListener> getServiceListeners() {
        return this.serviceListeners;
    }

    @Override
    public AleEngine getCurrentEngine() {
        return this.currentEngine;
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.javaExtensions.removeClassLoadingCallBack(this.callback);
        this.javaExtensions.removeEPackageCallBack(this.ePackageCallBack);
        this.javaExtensions.dispose();
    }

    private void initDynamicFeatures(List<Object> inputElems, EvalEnvironment env) {
        HashSet<EObject> accessibleInputElements = new HashSet<EObject>();
        Set<Resource> allResources = inputElems.stream().filter(elem -> elem instanceof EObject).map(elem -> ((EObject)elem).eResource()).filter(res -> res != null).collect(Collectors.toSet());
        allResources.forEach(res -> res.getAllContents().forEachRemaining(e -> {
            boolean bl = accessibleInputElements.add((EObject)e);
        }));
        inputElems.stream().filter(elem -> elem instanceof EObject).filter(elem -> ((EObject)elem).eResource() == null).forEach(elem -> {
            boolean bl = accessibleInputElements.add((EObject)elem);
        });
        env.initialize(accessibleInputElements);
    }
}

