/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide.sirius.ui;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gemoc.dsl.debug.ide.sirius.ui.DebugSiriusIdeUiPlugin;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.dialect.marker.TraceabilityMarkerNavigationProvider;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public final class SiriusEditorUtils {
    private SiriusEditorUtils() {
    }

    public static List<Session> getSessions(URI uri) {
        ArrayList<Session> res = new ArrayList<Session>();
        URI resourceURI = uri.trimFragment();
        block0: for (Session session : SessionManager.INSTANCE.getSessions()) {
            for (Resource resource : session.getSemanticResources()) {
                if (!resourceURI.equals(resource.getURI())) continue;
                res.add(session);
                continue block0;
            }
        }
        return res;
    }

    public static List<DRepresentation> getRepresentations(Session session, URI instructionURI) {
        ArrayList<DRepresentation> res = new ArrayList<DRepresentation>();
        EObject instruction = session.getTransactionalEditingDomain().getResourceSet().getEObject(instructionURI, false);
        for (DView view : session.getSelectedViews()) {
            for (DRepresentationDescriptor rdescriptor : view.getOwnedRepresentationDescriptors()) {
                DRepresentation representation = rdescriptor.getRepresentation();
                if (!SiriusEditorUtils.representSemanticElement(representation, instruction)) continue;
                res.add(representation);
            }
        }
        return res;
    }

    public static boolean representSemanticElement(DRepresentation representation, EObject instruction) {
        boolean res = false;
        if (representation.eCrossReferences().contains((Object)instruction)) {
            res = true;
        } else {
            for (DRepresentationElement representationElement : representation.getRepresentationElements()) {
                if (!representationElement.eCrossReferences().contains((Object)instruction)) continue;
                res = true;
                break;
            }
        }
        return res;
    }

    public static void showInstruction(DialectEditor editorPart, EObject instruction) {
        URI resourceURI = instruction.eResource().getURI();
        if (resourceURI.isPlatformResource()) {
            String resourcePath = resourceURI.toPlatformString(true);
            IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resourcePath));
            try {
                IMarker marker = resource.createMarker("org.eclipse.emf.ecore.diagnostic");
                marker.setAttribute("uri", (Object)EcoreUtil.getURI((EObject)instruction).toString());
                TraceabilityMarkerNavigationProvider navigationProvider = new TraceabilityMarkerNavigationProvider(editorPart);
                navigationProvider.gotoMarker(marker);
                marker.delete();
            }
            catch (CoreException e) {
                DebugSiriusIdeUiPlugin.INSTANCE.log((Object)e);
            }
        }
    }

    public static void showInstructions(DialectEditor editorPart, List<EObject> instructions) {
        LinkedHashSet<DRepresentationElement> representationElements = new LinkedHashSet<DRepresentationElement>();
        for (EObject instruction : instructions) {
            for (EObject eObj : new EObjectQuery(instruction).getInverseReferences(ViewpointPackage.eINSTANCE.getDRepresentationElement_SemanticElements())) {
                if (!(eObj instanceof DRepresentationElement)) continue;
                representationElements.add((DRepresentationElement)eObj);
            }
            SiriusEditorUtils.showInstruction(editorPart, instruction);
        }
        DialectUIManager.INSTANCE.setSelection(editorPart, new ArrayList(representationElements));
    }
}

