/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.addon.eaop.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.eclipse.gemoc.commons.utils.ExtensibleInputStream;
import org.eclipse.gemoc.executionframework.addon.eaop.server.Activator;
import org.eclipse.gemoc.executionframework.addon.eaop.server.EaopServerImpl;
import org.eclipse.gemoc.executionframework.addon.eaop.server.rpclaunch.EaopJsonRPCLauncher;
import org.eclipse.gemoc.protocols.eaop.api.services.IEngineAddonProtocolClient;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/eaop")
public class EaopServerEndPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(EaopServerEndPoint.class);
    boolean supportHeader = true;
    Map<Session, ExtensibleInputStream> activeSessions = new HashMap<Session, ExtensibleInputStream>();
    EaopServerImpl server;

    @OnOpen
    public void onOpen(final Session session) {
        LOGGER.info("Starting connection...");
        Activator.debug("Starting connection");
        String engineId = "";
        this.server = new EaopServerImpl();
        Activator.getDefault().getStartedEaopServer().add(this.server);
        ExtensibleInputStream in = new ExtensibleInputStream();
        this.activeSessions.put(session, in);
        OutputStream outputstream = new OutputStream(){
            ByteArrayOutputStream internal = new ByteArrayOutputStream();

            @Override
            public void write(int b) throws IOException {
                this.internal.write(b);
            }

            @Override
            public void flush() throws IOException {
                String response = new String(this.internal.toByteArray(), "UTF-8");
                if (!EaopServerEndPoint.this.supportHeader) {
                    response = response.substring(response.indexOf("{"));
                }
                session.getBasicRemote().sendText(response);
                this.internal.reset();
                LOGGER.debug("Response sent: " + response);
                System.out.println("[DEBUG] Sent: " + response);
            }
        };
        Launcher<IEngineAddonProtocolClient> serverSideLauncher = EaopJsonRPCLauncher.createLauncher(this.server, IEngineAddonProtocolClient.class, (InputStream)in, outputstream);
        this.server.connectClient((IEngineAddonProtocolClient)serverSideLauncher.getRemoteProxy());
        serverSideLauncher.startListening();
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        this.activeSessions.remove(session);
        Activator.getDefault().getStartedEaopServer().remove(this.server);
        LOGGER.debug("Closing session " + session.getId() + " " + session.getRequestURI());
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        if (!message.startsWith("Content-Length:")) {
            this.supportHeader = false;
            message = this.addHeader(message);
        }
        System.out.println("[DEBUG] Message: " + message);
        ExtensibleInputStream inputStream = this.activeSessions.get(session);
        if (inputStream != null) {
            inputStream.addMessage(message);
        }
    }

    public String addHeader(String requestContent) {
        String header = "";
        try {
            int length = requestContent.getBytes("UTF-8").length;
            header = "Content-Length: " + length + "\n\n";
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage());
        }
        return String.valueOf(header) + requestContent;
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        LOGGER.error("Error " + throwable.getMessage() + " on session " + session.getId() + " " + session.getRequestURI(), throwable);
    }
}

