/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.templates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.ui.templates.AbstractNewPluginTemplateWizard;
import org.eclipse.pde.ui.templates.BaseOptionTemplateSection;
import org.eclipse.pde.ui.templates.TemplateOption;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class OptionTemplateWizardPage
extends WizardPage {
    private BaseOptionTemplateSection section;
    private List<TemplateOption> options;
    private String helpContextId;

    public OptionTemplateWizardPage(BaseOptionTemplateSection section, ArrayList<TemplateOption> options, String helpContextId) {
        super("");
        this.section = section;
        this.options = options;
        this.helpContextId = helpContextId;
    }

    public void createControl(Composite composite) {
        Composite container = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        int i = 0;
        while (i < this.options.size()) {
            TemplateOption option = this.options.get(i);
            option.createControl(container, 2);
            ++i;
        }
        if (this.helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, this.helpContextId);
        }
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        container.forceFocus();
    }

    public void setVisible(boolean visible) {
        IWizard wizard;
        if (visible && this.section.isDependentOnParentWizard() && (wizard = this.getWizard()) instanceof AbstractNewPluginTemplateWizard) {
            AbstractNewPluginTemplateWizard templateWizard = (AbstractNewPluginTemplateWizard)wizard;
            this.section.initializeFields(templateWizard.getData());
        }
        super.setVisible(visible);
    }
}

