/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hyperlinking;

import com.google.inject.Inject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkHelper;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class DefaultHyperlinkDetector
implements IHyperlinkDetector {
    @Inject
    private IHyperlinkHelper helper;
    @Inject
    private XtextDocumentUtil xtextDocumentUtil;

    public IHyperlink[] detectHyperlinks(final ITextViewer textViewer, final IRegion region, final boolean canShowMultipleHyperlinks) {
        return (IHyperlink[])this.xtextDocumentUtil.getXtextDocument(textViewer).tryReadOnly((IUnitOfWork)new IUnitOfWork<IHyperlink[], XtextResource>(){

            public IHyperlink[] exec(XtextResource resource) throws Exception {
                if (DefaultHyperlinkDetector.this.helper instanceof ISourceViewerAware && textViewer instanceof ISourceViewer) {
                    ((ISourceViewerAware)((Object)DefaultHyperlinkDetector.this.helper)).setSourceViewer((ISourceViewer)textViewer);
                }
                return DefaultHyperlinkDetector.this.helper.createHyperlinksByOffset(resource, region.getOffset(), canShowMultipleHyperlinks);
            }
        });
    }

    public void setHelper(IHyperlinkHelper helper) {
        this.helper = helper;
    }

    public IHyperlinkHelper getHelper() {
        return this.helper;
    }
}

