/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.builder;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import fr.inria.diverse.melange.lib.slicing.ecore.StrictEcore;
import fr.inria.diverse.melange.metamodel.melange.Language;
import fr.inria.diverse.melange.metamodel.melange.Slice;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Builder for the {@link Slice} operator.
 */
@SuppressWarnings("all")
public class SliceBuilder extends LanguageOperatorBuilder<Slice> {
  @Inject
  @Extension
  private RenamerHelper _renamerHelper;

  public SliceBuilder(final Slice op, final ModelTypingSpaceBuilder root) {
    super(op, root);
  }

  /**
   * Copy the set of {@link EPackage} built from the {@link Language} pointed by
   * the current {@link Slice} operator, slice it according to the slicing
   * criterion and apply the renaming rules.
   */
  @Override
  public void make() {
    boolean _isEmpty = this.targetModel.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      final Set<EPackage> sliceBase = IterableExtensions.<EPackage>toSet(EcoreUtil.<EPackage>copyAll(this.targetModel));
      final Function1<EPackage, List<EModelElement>> _function = (EPackage it) -> {
        return this.getClasses(it, this.source.getRoots());
      };
      final List<EModelElement> roots = IterableExtensions.<EModelElement>toList(Iterables.<EModelElement>concat(IterableExtensions.<EPackage, List<EModelElement>>map(sliceBase, _function)));
      EPackage _head = IterableExtensions.<EPackage>head(sliceBase);
      final StrictEcore slicer = new StrictEcore(roots, _head, false, "ecore", false, true);
      slicer.slice();
      final Function1<EPackage, Boolean> _function_1 = (EPackage it) -> {
        EObject _eContainer = it.eContainer();
        return Boolean.valueOf((_eContainer == null));
      };
      this.model = IterableExtensions.<EPackage>toSet(IterableExtensions.<EPackage>filter(Iterables.<EPackage>filter(slicer.getclonedElts(), EPackage.class), _function_1));
      final Consumer<EPackage> _function_2 = (EPackage it) -> {
        this._renamerHelper.applyRenaming(it, this.source.getMappingRules());
      };
      this.model.forEach(_function_2);
    }
  }

  /**
   * Search in {@code rootPackage} for {@link EClass}es named as in {@code classes}
   */
  private List<EModelElement> getClasses(final EPackage rootPackage, final List<String> classes) {
    final ArrayList<EModelElement> res = CollectionLiterals.<EModelElement>newArrayList();
    final Consumer<EClass> _function = (EClass cl) -> {
      boolean _contains = classes.contains(cl.getName());
      if (_contains) {
        res.add(cl);
      }
    };
    Iterables.<EClass>filter(rootPackage.getEClassifiers(), EClass.class).forEach(_function);
    return res;
  }
}
